/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.BatchQuery;
import com.google.code.facebookapi.CommunicationStrategy;
import com.google.code.facebookapi.DefaultCommunicationStrategy;
import com.google.code.facebookapi.FacebookApiUrls;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookMethod;
import com.google.code.facebookapi.FacebookSignatureUtil;
import com.google.code.facebookapi.IFacebookMethod;
import com.google.code.facebookapi.Pair;
import com.google.code.facebookapi.Pairs;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClient {
    protected static Log log = LogFactory.getLog(BasicClient.class);
    protected URL serverUrl;
    protected URL serverUrlHttps;
    private CommunicationStrategy communicationStrategy;
    protected final String apiKey;
    protected final String secret;
    protected boolean sessionSecret;
    protected boolean batchMode;
    protected List<BatchQuery> queries;
    protected String permissionsApiKey;

    public boolean isBatchMode() {
        return this.batchMode;
    }

    protected List<BatchQuery> getQueries() {
        return this.queries;
    }

    protected BasicClient(String apiKey, String secret, boolean sessionSecret) {
        this(null, null, apiKey, secret, sessionSecret, new DefaultCommunicationStrategy());
    }

    protected BasicClient(URL serverUrl, URL serverUrlHttps, String apiKey, String secret, boolean sessionSecret, CommunicationStrategy communicationStrategy) {
        this.apiKey = apiKey;
        this.secret = secret;
        this.sessionSecret = sessionSecret || secret.endsWith("__");
        this.serverUrl = null != serverUrl ? serverUrl : FacebookApiUrls.getDefaultServerUrl();
        this.serverUrlHttps = null != serverUrlHttps ? serverUrlHttps : FacebookApiUrls.getDefaultHttpsServerUrl();
        this.communicationStrategy = communicationStrategy;
        this.batchMode = false;
        this.queries = null;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean isSessionSecret() {
        return this.sessionSecret;
    }

    public void beginPermissionsMode(String apiKey) {
        this.permissionsApiKey = apiKey;
    }

    public void endPermissionsMode() {
        this.permissionsApiKey = null;
    }

    public void setServerUrl(String newUrl) {
        String base = newUrl;
        if (base.startsWith("http")) {
            base = base.substring(base.indexOf("://") + 3);
        }
        try {
            String url = "http://" + base;
            this.serverUrl = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    public void setServerUrlHttps(String newUrl) {
        String base = newUrl;
        if (base.startsWith("https")) {
            base = base.substring(base.indexOf("://") + 3);
        }
        try {
            String url = "https://" + base;
            this.serverUrlHttps = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    public String callMethod(String responseFormat, IFacebookMethod method, String sessionKey, Pair<String, CharSequence> ... paramPairs) throws FacebookException {
        return this.callMethod(responseFormat, method, sessionKey, Arrays.asList(paramPairs), null, null);
    }

    public String callMethod(String responseFormat, IFacebookMethod method, String sessionKey, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException {
        return this.callMethod(responseFormat, method, sessionKey, paramPairs, null, null);
    }

    public String callMethod(String responseFormat, IFacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException {
        return this.callMethod(responseFormat, method, null, Arrays.asList(paramPairs), null, null);
    }

    public String callMethod(String responseFormat, IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException {
        return this.callMethod(responseFormat, method, null, paramPairs, null, null);
    }

    protected SortedMap<String, String> prepareRequestParams(String responseFormat, IFacebookMethod method, String sessionKey, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException {
        boolean includeSession;
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (Pair<String, CharSequence> p : paramPairs) {
            String key = (String)p.first;
            CharSequence oldVal = params.put(key, BasicClientHelper.toString((CharSequence)p.second));
            if (oldVal == null) continue;
            log.warn((Object)String.format("For parameter %s, overwrote old value %s with new value %s.", key, oldVal, p.second));
        }
        if (this.permissionsApiKey != null) {
            params.put("call_as_apikey", this.permissionsApiKey);
        }
        params.put("v", "1.0");
        params.put("call_id", Long.toString(System.currentTimeMillis()));
        params.put("method", method.methodName());
        if (responseFormat != null) {
            params.put("format", responseFormat);
        }
        params.put("api_key", this.apiKey);
        boolean bl = includeSession = sessionKey != null;
        if (includeSession) {
            params.put("session_key", sessionKey);
        }
        params.remove("sig");
        if (this.sessionSecret) {
            params.put("ss", "1");
        }
        String signature = FacebookSignatureUtil.generateSignature(params, this.secret);
        params.put("sig", signature);
        return params;
    }

    public String callMethod(String responseFormat, IFacebookMethod method, String sessionKey, Collection<Pair<String, CharSequence>> paramPairs, String fileName, InputStream fileStream) throws FacebookException {
        boolean fileCall;
        SortedMap<String, String> params = this.prepareRequestParams(responseFormat, method, sessionKey, paramPairs);
        boolean bl = fileCall = fileName != null || fileStream != null;
        if (this.batchMode) {
            if (fileCall) {
                throw new FacebookException(100, "File upload API calls cannot be batched:  " + method.methodName());
            }
            boolean addToBatch = true;
            if (method.methodName().equals(FacebookMethod.USERS_GET_LOGGED_IN_USER.methodName())) {
                Exception trace = new Exception();
                StackTraceElement[] traceElems = trace.getStackTrace();
                int index = 0;
                for (StackTraceElement elem : traceElems) {
                    if (elem.getMethodName().indexOf("_") != -1) {
                        StackTraceElement caller = traceElems[index + 1];
                        boolean calledFromSelf = caller.getClassName().equals(BasicClient.class.getName());
                        boolean calledFromAuth = caller.getMethodName().startsWith("auth_");
                        if (!calledFromSelf || calledFromAuth) break;
                        addToBatch = false;
                        break;
                    }
                    ++index;
                }
            }
            if (addToBatch) {
                this.queries.add(new BatchQuery(method, params));
            }
            return null;
        }
        try {
            URL url;
            boolean doHttps = FacebookMethod.AUTH_GET_SESSION.equals(method) && "true".equals(params.get("generate_session_secret"));
            URL uRL = url = doHttps ? this.serverUrlHttps : this.serverUrl;
            if (fileCall) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(method.methodName() + ": POST-FILE: " + url.toString() + ": " + params));
                }
                return this.communicationStrategy.postRequest(url, params, fileName, fileStream);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(method.methodName() + ": POST: " + url.toString() + ": " + params));
            }
            return this.communicationStrategy.postRequest(url, params);
        }
        catch (IOException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    public void beginBatch() {
        this.batchMode = true;
        this.queries = new ArrayList<BatchQuery>();
    }

    public List<String> executeBatch(boolean serial) throws FacebookException {
        this.batchMode = false;
        List<BatchQuery> q = this.queries;
        this.queries = null;
        int BATCH_LIMIT = 20;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<BatchQuery> buffer = new ArrayList<BatchQuery>(20);
        while (!q.isEmpty()) {
            boolean batchFull;
            buffer.add(q.remove(0));
            boolean bl = batchFull = buffer.size() >= 20;
            if (!batchFull && !q.isEmpty()) continue;
            List<String> batchRawResponse = this.batch_run(BasicClient.encodeMethods(buffer), serial);
            result.addAll(batchRawResponse);
            if (!batchFull) continue;
            buffer = new ArrayList(20);
        }
        return result;
    }

    protected List<String> batch_run(String methods, boolean serial) throws FacebookException {
        String call = this.callMethod("json", (IFacebookMethod)FacebookMethod.BATCH_RUN, null, Arrays.asList(Pairs.newPair("method_feed", methods), Pairs.newPair10("serial_only", serial)), null, null);
        try {
            JSONArray arr = new JSONArray(call);
            ArrayList<String> out = new ArrayList<String>();
            int l = arr.length();
            for (int i = 0; i < l; ++i) {
                out.add(arr.getString(i));
            }
            return out;
        }
        catch (JSONException ex) {
            throw BasicClientHelper.runtimeException((Exception)((Object)ex));
        }
    }

    protected static String encodeMethods(List<BatchQuery> queryList) throws FacebookException {
        JSONArray result = new JSONArray();
        for (BatchQuery query : queryList) {
            if (query.getMethod().takesFile()) {
                throw new FacebookException(100, "File upload API calls cannot be batched:  " + query.getMethod().methodName());
            }
            result.put((Object)BasicClientHelper.delimit(query.getParams().entrySet(), "&", "=", true));
        }
        return result.toString();
    }
}

