/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.AllocationType;
import com.google.code.facebookapi.ApplicationProperty;
import com.google.code.facebookapi.ApplicationPropertySet;
import com.google.code.facebookapi.AssociationInfo;
import com.google.code.facebookapi.AssociationType;
import com.google.code.facebookapi.Attachment;
import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.BatchQuery;
import com.google.code.facebookapi.BundleActionLink;
import com.google.code.facebookapi.BundleStoryTemplate;
import com.google.code.facebookapi.FacebookApiUrls;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookMethod;
import com.google.code.facebookapi.FacebookSignatureUtil;
import com.google.code.facebookapi.IFacebookMethod;
import com.google.code.facebookapi.IFacebookRestClient;
import com.google.code.facebookapi.IFeedImage;
import com.google.code.facebookapi.IPair;
import com.google.code.facebookapi.JsonHelper;
import com.google.code.facebookapi.Metric;
import com.google.code.facebookapi.PageProfileField;
import com.google.code.facebookapi.Pair;
import com.google.code.facebookapi.Pairs;
import com.google.code.facebookapi.Permission;
import com.google.code.facebookapi.PhotoTag;
import com.google.code.facebookapi.ProfileField;
import com.google.code.facebookapi.ProfileFieldItem;
import com.google.code.facebookapi.ProfileInfoField;
import com.google.code.facebookapi.PropertyType;
import com.google.code.facebookapi.TemplatizedAction;
import com.google.code.facebookapi.XmlHelper;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleClient
implements IFacebookRestClient<Object> {
    protected static Log log = LogFactory.getLog(ExtensibleClient.class);
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 1024;
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected URL _serverUrl = FacebookApiUrls.getDefaultServerUrl();
    protected int _connectTimeout = -1;
    protected int _readTimeout = -1;
    private String responseFormat;
    protected final String _apiKey;
    protected final String _secret;
    protected boolean _isDesktop;
    protected String cacheSessionKey;
    protected Long cacheUserId;
    protected Long cacheSessionExpires;
    protected String cacheSessionSecret;
    protected String rawResponse;
    protected boolean batchMode;
    protected List<BatchQuery> queries;
    protected String permissionsApiKey = null;
    @Deprecated
    protected Boolean cacheAppAdded;
    protected Boolean cacheAppUser;

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public List<BatchQuery> getQueries() {
        return this.queries;
    }

    protected ExtensibleClient(String responseFormat, String apiKey, String secret) {
        this(responseFormat, apiKey, secret, null);
    }

    protected ExtensibleClient(String responseFormat, String apiKey, String secret, String sessionKey) {
        this(responseFormat, apiKey, secret, sessionKey, false);
    }

    protected ExtensibleClient(String responseFormat, String apiKey, String secret, String sessionKey, boolean sessionSecret) {
        this.responseFormat = responseFormat;
        this._apiKey = apiKey;
        this._secret = secret;
        this.cacheSessionKey = sessionKey;
        if (sessionSecret || secret.endsWith("__")) {
            this._isDesktop = true;
        }
        this.batchMode = false;
        this.queries = new ArrayList<BatchQuery>();
    }

    @Override
    public URL getServerUrl() {
        return this._serverUrl;
    }

    @Override
    public void setServerUrl(URL url) {
        this._serverUrl = url;
    }

    @Override
    public void setServerUrl(String url) {
        try {
            this._serverUrl = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    @Override
    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this._readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this._readTimeout = readTimeout;
    }

    @Override
    public String getResponseFormat() {
        return this.responseFormat;
    }

    @Override
    public String getApiKey() {
        return this._apiKey;
    }

    @Override
    public String getSecret() {
        return this._secret;
    }

    @Override
    public void beginPermissionsMode(String apiKey) {
        this.permissionsApiKey = apiKey;
    }

    @Override
    public void endPermissionsMode() {
        this.permissionsApiKey = null;
    }

    public String getSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setSessionSecret(String key) {
        this.cacheSessionSecret = key;
    }

    @Override
    @Deprecated
    public Boolean getCacheAppAdded() {
        return this.cacheAppAdded;
    }

    @Override
    @Deprecated
    public void setCacheAppAdded(Boolean cacheAppAdded) {
        this.cacheAppAdded = cacheAppAdded;
    }

    @Override
    public Boolean getCacheAppUser() {
        return this.cacheAppUser;
    }

    @Override
    public void setCacheAppUser(Boolean cacheAppUser) {
        this.cacheAppUser = cacheAppUser;
    }

    @Override
    public String getCacheSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setCacheSessionSecret(String cacheSessionSecret) {
        this.cacheSessionSecret = cacheSessionSecret;
    }

    @Override
    public void setCacheSession(String cacheSessionKey, Long cacheUserId, Long cacheSessionExpires) {
        this.setCacheSessionKey(cacheSessionKey);
        this.setCacheUserId(cacheUserId);
        this.setCacheSessionExpires(cacheSessionExpires);
    }

    @Override
    public Long getCacheSessionExpires() {
        return this.cacheSessionExpires;
    }

    public void setCacheSessionExpires(Long cacheSessionExpires) {
        this.cacheSessionExpires = cacheSessionExpires;
    }

    @Override
    public String getCacheSessionKey() {
        return this.cacheSessionKey;
    }

    public void setCacheSessionKey(String cacheSessionKey) {
        this.cacheSessionKey = cacheSessionKey;
    }

    @Override
    public Long getCacheUserId() {
        return this.cacheUserId;
    }

    public void setCacheUserId(Long cacheUserId) {
        this.cacheUserId = cacheUserId;
    }

    @Override
    public Object friends_areFriends(long userId1, long userId2) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, Pairs.newPair("uids1", userId1), Pairs.newPair("uids2", userId2));
    }

    @Override
    public Object friends_areFriends(Collection<Long> userIds1, Collection<Long> userIds2) throws FacebookException {
        if (userIds1 == null || userIds2 == null || userIds1.isEmpty() || userIds2.isEmpty()) {
            throw new IllegalArgumentException("Collections passed to friends_areFriends should not be null or empty");
        }
        if (userIds1.size() != userIds2.size()) {
            throw new IllegalArgumentException(String.format("Collections should be same size: got userIds1: %d elts; userIds2: %d elts", userIds1.size(), userIds2.size()));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, Pairs.newPair("uids1", BasicClientHelper.delimit(userIds1)), Pairs.newPair("uids2", BasicClientHelper.delimit(userIds2)));
    }

    @Override
    public boolean fbml_refreshRefUrl(String url) throws FacebookException {
        try {
            return this.fbml_refreshRefUrl(new URL(url));
        }
        catch (MalformedURLException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    protected void handleFeedImages(List<Pair<String, CharSequence>> params, Collection<? extends IPair<? extends Object, URL>> images) {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("At most four images are allowed, got " + images.size());
        }
        if (null != images && !images.isEmpty()) {
            int image_count = 0;
            for (IPair<? extends Object, URL> iPair : images) {
                ++image_count;
                assert (null != iPair.getFirst()) : "Image URL must be provided";
                String name = "image_" + image_count;
                params.add(Pairs.newPair(name, iPair.getFirst()));
                if (null == iPair.getSecond()) continue;
                params.add(Pairs.newPair(name + "_link", iPair.getSecond()));
            }
        }
    }

    @Override
    public String auth_getSession(String authToken) throws FacebookException {
        return this.auth_getSession(authToken, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String auth_getSession(String authToken, boolean generateSessionSecret) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        Pairs.addParam("auth_token", authToken, params);
        if (generateSessionSecret) {
            Pairs.addParam("generate_session_secret", "true", params);
        }
        String rawResponse = this.callMethod((IFacebookMethod)FacebookMethod.AUTH_GET_SESSION, params);
        log.debug((Object)("Facebook response:  " + rawResponse));
        if ("json".equals(this.getResponseFormat())) {
            try {
                JSONObject json = new JSONObject(rawResponse);
                this.cacheSessionKey = json.getString("session_key");
                this.cacheUserId = json.getLong("uid");
                this.cacheSessionExpires = json.getLong("expires");
                if (!generateSessionSecret) return this.cacheSessionKey;
                this.cacheSessionSecret = json.getString("secret");
                return this.cacheSessionKey;
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        } else {
            Document d = XmlHelper.parseCallResult(rawResponse, this.factory);
            this.cacheSessionKey = XmlHelper.extractString(d.getElementsByTagName("session_key").item(0));
            this.cacheUserId = XmlHelper.extractLong(d.getElementsByTagName("uid").item(0));
            this.cacheSessionExpires = XmlHelper.extractLong(d.getElementsByTagName("expires").item(0));
            if (!generateSessionSecret) return this.cacheSessionKey;
            this.cacheSessionSecret = XmlHelper.extractString(d.getElementsByTagName("secret").item(0));
        }
        return this.cacheSessionKey;
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate) throws FacebookException {
        return this.feed_publishTemplatizedAction(actorId, titleTemplate, null, null, null, null, null, null);
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException {
        return this.feed_publishTemplatizedAction(titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images, null);
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(Integer actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException {
        return this.feed_publishTemplatizedAction((long)actorId, titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images);
    }

    @Override
    public Object groups_getMembers(Number groupId) throws FacebookException {
        assert (null != groupId);
        return this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET_MEMBERS, Pairs.newPair("gid", groupId));
    }

    @Override
    public Object friends_getAppUsers() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_APP_USERS, new Pair[0]);
    }

    @Override
    public Object fql_query(CharSequence query) throws FacebookException {
        assert (null != query);
        return this.callMethod((IFacebookMethod)FacebookMethod.FQL_QUERY, Pairs.newPair("query", query));
    }

    private String generateSignature(List<String> params) {
        String secret = this._secret;
        return FacebookSignatureUtil.generateSignature(params, secret);
    }

    @Override
    public Object groups_get(Long userId, Collection<Long> groupIds) throws FacebookException {
        boolean hasGroups;
        boolean bl = hasGroups = null != groupIds && !groupIds.isEmpty();
        if (null != userId) {
            return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, Pairs.newPair("uid", userId), Pairs.newPair("gids", BasicClientHelper.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, Pairs.newPair("uid", userId));
        }
        return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, Pairs.newPair("gids", BasicClientHelper.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[0]);
    }

    protected String callMethod(IFacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException {
        return this.callMethod(this.responseFormat, method, Arrays.asList(paramPairs), null, null);
    }

    protected String callMethod(IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException {
        return this.callMethod(this.responseFormat, method, paramPairs, null, null);
    }

    protected String callMethod(IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs, String fileName, InputStream fileStream) throws FacebookException {
        return this.callMethod(this.responseFormat, method, paramPairs, fileName, fileStream);
    }

    protected String callMethod(String format, IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs, String fileName, InputStream fileStream) throws FacebookException {
        boolean includeSession;
        this.rawResponse = null;
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (this.permissionsApiKey != null) {
            params.put("call_as_apikey", this.permissionsApiKey);
        }
        if (this.isDesktop()) {
            params.put("ss", "1");
        }
        params.put("method", method.methodName());
        params.put("api_key", this._apiKey);
        params.put("v", "1.0");
        if (null != format) {
            params.put("format", format);
        }
        params.put("call_id", Long.toString(System.currentTimeMillis()));
        boolean bl = includeSession = !method.requiresNoSession() && this.cacheSessionKey != null;
        if (includeSession) {
            params.put("session_key", this.cacheSessionKey);
        }
        for (Pair<String, CharSequence> p : paramPairs) {
            CharSequence oldVal = params.put((String)p.first, FacebookSignatureUtil.toString((CharSequence)p.second));
            if (oldVal == null) continue;
            log.warn((Object)String.format("For parameter %s, overwrote old value %s with new value %s.", p.first, oldVal, p.second));
        }
        assert (!params.containsKey("sig"));
        String signature = this.generateSignature(FacebookSignatureUtil.convert(params.entrySet()));
        params.put("sig", signature);
        if (this.batchMode) {
            boolean addToBatch = true;
            if (method.methodName().equals(FacebookMethod.USERS_GET_LOGGED_IN_USER.methodName())) {
                Exception trace = new Exception();
                StackTraceElement[] traceElems = trace.getStackTrace();
                int index = 0;
                for (StackTraceElement elem : traceElems) {
                    if (elem.getMethodName().indexOf("_") != -1) {
                        StackTraceElement caller = traceElems[index + 1];
                        if (!caller.getClassName().equals(ExtensibleClient.class.getName()) || caller.getMethodName().startsWith("auth_")) break;
                        addToBatch = false;
                        break;
                    }
                    ++index;
                }
            }
            if (addToBatch) {
                this.queries.add(new BatchQuery(method, params));
            }
            return null;
        }
        boolean doHttps = FacebookMethod.AUTH_GET_SESSION.equals(method) && "true".equals(params.get("generate_session_secret"));
        try {
            this.rawResponse = method.takesFile() ? this.postFileRequest(method, params, fileName, fileStream) : this.postRequest(method, params, doHttps);
            return this.rawResponse;
        }
        catch (IOException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    private void validateVoidResponse(String rawResponse) throws FacebookException {
        if ("json".equals(this.responseFormat)) {
            JsonHelper.parseCallResult(rawResponse);
        } else {
            XmlHelper.parseCallResult(rawResponse, this.factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postRequest(IFacebookMethod method, Map<String, String> params, boolean doHttps) throws IOException {
        String string;
        URL serverUrl;
        URL uRL = serverUrl = doHttps ? FacebookApiUrls.getDefaultHttpsServerUrl() : this._serverUrl;
        if (log.isDebugEnabled()) {
            log.debug((Object)(method.methodName() + ": POST: " + serverUrl.toString() + ": " + params));
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            conn = (HttpURLConnection)serverUrl.openConnection();
            if (this._connectTimeout != -1) {
                conn.setConnectTimeout(this._connectTimeout);
            }
            if (this._readTimeout != -1) {
                conn.setReadTimeout(this._readTimeout);
            }
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);
            conn.connect();
            out = conn.getOutputStream();
            String paramString = null == params ? "" : BasicClientHelper.delimit(params.entrySet(), "&", "=", true);
            out.write(paramString.toString().getBytes("UTF-8"));
            in = conn.getInputStream();
            string = BasicClientHelper.toString(in);
        }
        catch (Throwable throwable) {
            BasicClientHelper.close(in);
            BasicClientHelper.close(out);
            BasicClientHelper.disconnect(conn);
            throw throwable;
        }
        BasicClientHelper.close(in);
        BasicClientHelper.close(out);
        BasicClientHelper.disconnect(conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String postFileRequest(IFacebookMethod method, Map<String, String> params, String fileName, InputStream fileStream) throws IOException {
        String string;
        if (log.isDebugEnabled()) {
            log.debug((Object)(method.methodName() + ": POST-FILE: " + this._serverUrl.toString() + ": " + params));
        }
        HttpURLConnection con = null;
        OutputStream urlOut = null;
        InputStream in = null;
        try {
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            con = (HttpURLConnection)this._serverUrl.openConnection();
            if (this._connectTimeout != -1) {
                con.setConnectTimeout(this._connectTimeout);
            }
            if (this._readTimeout != -1) {
                con.setReadTimeout(this._readTimeout);
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setRequestProperty("MIME-version", "1.0");
            urlOut = con.getOutputStream();
            DataOutputStream out = new DataOutputStream(urlOut);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                out.writeBytes(PREF + boundary + CRLF);
                out.writeBytes("Content-Type: text/plain;charset=utf-8\r\n");
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"" + CRLF);
                out.writeBytes(CRLF);
                byte[] valueBytes = entry.getValue().toString().getBytes("UTF-8");
                out.write(valueBytes);
                out.writeBytes(CRLF);
            }
            out.writeBytes(PREF + boundary + CRLF);
            out.writeBytes("Content-Type: image\r\n");
            out.writeBytes("Content-disposition: form-data; filename=\"" + fileName + "\"" + CRLF);
            out.writeBytes(CRLF);
            byte[] buf = new byte[1024];
            int len = 0;
            while (len >= 0) {
                out.write(buf, 0, len);
                len = fileStream.read(buf);
            }
            out.writeBytes("\r\n--" + boundary + PREF + CRLF);
            out.flush();
            in = con.getInputStream();
            string = BasicClientHelper.toString(in);
        }
        catch (Throwable throwable) {
            BasicClientHelper.close(urlOut);
            BasicClientHelper.close(in);
            BasicClientHelper.disconnect(con);
            throw throwable;
        }
        BasicClientHelper.close(urlOut);
        BasicClientHelper.close(in);
        BasicClientHelper.disconnect(con);
        return string;
    }

    @Override
    public boolean fbml_refreshRefUrl(URL url) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_REF_URL, Pairs.newPair("url", url)));
    }

    @Override
    public Object users_getStandardInfo(Collection<Long> userIds, Collection<ProfileField> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, Pairs.newPair("uids", BasicClientHelper.delimit(userIds)), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public Object users_getStandardInfo(Collection<Long> userIds, Set<CharSequence> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, Pairs.newPair("uids", BasicClientHelper.delimit(userIds)), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public Object users_getInfo(Iterable<Long> userIds, Collection<ProfileField> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, Pairs.newPair("uids", BasicClientHelper.delimit(userIds)), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public Object users_getInfo(Iterable<Long> userIds, Set<CharSequence> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, Pairs.newPair("uids", BasicClientHelper.delimit(userIds)), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public long users_getLoggedInUser() throws FacebookException {
        if (this.cacheUserId == null || this.cacheUserId == -1L || this.batchMode) {
            this.cacheUserId = this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_LOGGED_IN_USER, new Pair[0]));
        }
        return this.cacheUserId;
    }

    @Override
    public boolean isDesktop() {
        return this._isDesktop;
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded() throws FacebookException {
        if (this.cacheAppAdded == null) {
            this.cacheAppAdded = this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED, new Pair[0]));
        }
        return this.cacheAppAdded;
    }

    @Override
    public boolean users_isAppUser() throws FacebookException {
        if (this.cacheAppUser == null) {
            this.cacheAppUser = this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
        }
        return this.cacheAppUser;
    }

    @Override
    public boolean users_isAppUser(Long userId) throws FacebookException {
        if (userId != null) {
            return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER_NOSESSION, Pairs.newPair("uid", userId)));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
    }

    @Override
    public boolean users_setStatus(String status) throws FacebookException {
        return this.users_setStatus(status, false, false);
    }

    @Override
    public boolean users_clearStatus() throws FacebookException {
        return this.users_setStatus(null, true);
    }

    @Override
    public boolean fbml_refreshImgSrc(String imageUrl) throws FacebookException {
        try {
            return this.fbml_refreshImgSrc(new URL(imageUrl));
        }
        catch (MalformedURLException ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    @Override
    public boolean fbml_refreshImgSrc(URL imageUrl) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_IMG_SRC, Pairs.newPair("url", imageUrl)));
    }

    @Override
    public Object friends_get() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET, new Pair[0]);
    }

    private String toFriendsGetResponse(List<Long> ids) {
        if ("json".equals(this.responseFormat)) {
            JSONArray out = new JSONArray();
            for (Long id : ids) {
                out.put((Object)id);
            }
            return out.toString();
        }
        try {
            DocumentBuilderFactory localFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = localFactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElementNS("http://api.facebook.com/1.0/", "friends_get_response");
            root.setAttributeNS("http://api.facebook.com/1.0/", "friends_get_response", "http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd");
            root.setAttribute("list", "true");
            for (Long id : ids) {
                Element uid = doc.createElement("uid");
                uid.appendChild(doc.createTextNode(Long.toString(id)));
                root.appendChild(uid);
            }
            doc.appendChild(root);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            StringWriter out = new StringWriter();
            t.transform(new DOMSource(doc), new StreamResult(out));
            return out.toString();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Object friends_get(Long uid) throws FacebookException {
        if (uid != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_NOSESSION, Pairs.newPair("uid", uid));
        }
        return this.friends_get();
    }

    @Override
    public String auth_createToken() throws FacebookException {
        String d = this.callMethod((IFacebookMethod)FacebookMethod.AUTH_CREATE_TOKEN, new Pair[0]);
        return this.extractString(d);
    }

    @Override
    public String getRawResponse() {
        return this.rawResponse;
    }

    @Override
    @Deprecated
    public boolean feed_PublishTemplatizedAction(TemplatizedAction action) throws FacebookException {
        return this.templatizedFeedHandler(action.getTitleTemplate(), action.getTitleParams(), action.getBodyTemplate(), action.getBodyParams(), action.getBodyGeneral(), action.getPictures(), action.getTargetIds(), action.getPageActorId());
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds) throws FacebookException {
        return this.templatizedFeedHandler(titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, pictures, targetIds, null);
    }

    @Deprecated
    protected boolean templatizedFeedHandler(String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<?, URL>> pictures, String targetIds, Long pageId) throws FacebookException {
        assert (pictures == null || pictures.size() <= 4);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(15);
        Pairs.addParam("title_template", titleTemplate, params);
        Pairs.addParamIfNotBlank("title_data", titleData, params);
        boolean hasBody = Pairs.addParamIfNotBlank("body_template", bodyTemplate, params);
        if (hasBody) {
            Pairs.addParamIfNotBlank("body_data", bodyData, params);
        }
        Pairs.addParamIfNotBlank("body_general", bodyGeneral, params);
        if (pictures != null) {
            int count = 1;
            for (IPair<?, URL> picture : pictures) {
                String url = picture.getFirst().toString();
                if (url.startsWith("http://UID/")) {
                    url = url.substring("http://UID/".length());
                }
                Pairs.addParam("image_" + count, url, params);
                if (picture.getSecond() != null) {
                    Pairs.addParam("image_" + count + "_link", picture.getSecond().toString(), params);
                }
                ++count;
            }
        }
        Pairs.addParamIfNotBlank("target_ids", targetIds, params);
        Pairs.addParamIfNotBlank("page_actor_id", pageId, params);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, params));
    }

    @Override
    public boolean users_hasAppPermission(Permission perm) throws FacebookException {
        return this.users_hasAppPermission(perm, null);
    }

    @Override
    public boolean users_hasAppPermission(Permission perm, Long userId) throws FacebookException {
        if (userId != null) {
            return this.extractBoolean10(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION_NOSESSION, Pairs.newPair("ext_perm", perm.getName()), Pairs.newPair("uid", userId)));
        }
        return this.extractBoolean10(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION, Pairs.newPair("ext_perm", perm.getName())));
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear) throws FacebookException {
        return this.users_setStatus(newStatus, clear, false);
    }

    @Override
    public Object pages_getInfo(Collection<Long> pageIds, Collection<PageProfileField> fields) throws FacebookException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, Pairs.newPair("page_ids", BasicClientHelper.delimit(pageIds)), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public Object pages_getInfo(Collection<Long> pageIds, Set<CharSequence> fields) throws FacebookException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, Pairs.newPair("page_ids", BasicClientHelper.delimit(pageIds)), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public Object pages_getInfo(Long userId, Collection<PageProfileField> fields) throws FacebookException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        if (userId == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, Pairs.newPair("uid", userId), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public Object pages_getInfo(Long userId, Set<CharSequence> fields) throws FacebookException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        if (userId == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, Pairs.newPair("uid", userId), Pairs.newPair("fields", BasicClientHelper.delimit(fields)));
    }

    @Override
    public boolean pages_isAppAdded(Long pageId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_APP_ADDED, Pairs.newPair("page_id", pageId)));
    }

    @Override
    public boolean pages_isFan(Long pageId, Long userId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, Pairs.newPair("page_id", pageId), Pairs.newPair("uid", userId)));
    }

    @Override
    public boolean pages_isFan(Long pageId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, Pairs.newPair("page_id", pageId)));
    }

    @Override
    public boolean pages_isAdmin(Long pageId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_ADMIN, Pairs.newPair("page_id", pageId)));
    }

    @Override
    public boolean fbml_setRefHandle(String handle, String fbmlMarkup) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_SET_REF_HANDLE, Pairs.newPair("handle", handle), Pairs.newPair("fbml", fbmlMarkup)));
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(Pairs.newPair("status", newStatus));
        }
        if (clear) {
            params.add(Pairs.newPair("clear", "true"));
        }
        if (statusIncludesVerb) {
            params.add(Pairs.newPair("status_includes_verb", "true"));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS, params));
    }

    @Override
    public Object data_getCookies() throws FacebookException {
        return this.data_getCookies(this.users_getLoggedInUser(), null);
    }

    @Override
    public Object data_getCookies(Long userId) throws FacebookException {
        return this.data_getCookies(userId, null);
    }

    @Override
    public Object data_getCookies(String name) throws FacebookException {
        return this.data_getCookies(this.users_getLoggedInUser(), name);
    }

    @Override
    public Object data_getCookies(Long userId, CharSequence name) throws FacebookException {
        if (name == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, Pairs.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, Pairs.newPair("uid", userId), Pairs.newPair("name", name));
    }

    @Override
    public boolean data_setCookie(String name, String value) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, String path) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value) throws FacebookException {
        return this.data_setCookie(userId, name, value, null, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, CharSequence path) throws FacebookException {
        return this.data_setCookie(userId, name, value, null, path);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires, String path) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires) throws FacebookException {
        return this.data_setCookie(userId, name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires, CharSequence path) throws FacebookException {
        if (name == null || "".equals(name)) {
            throw new FacebookException(100, "The cookie name cannot be null or empty!");
        }
        if (value == null) {
            value = "";
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        Pairs.addParam("uid", userId, params);
        Pairs.addParam("name", name, params);
        Pairs.addParam("value", value, params);
        Pairs.addParamIfNotBlankZero("expires", expires, params);
        Pairs.addParamIfNotBlank("path", path, params);
        String doc = this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_COOKIE, params);
        return this.extractBoolean(doc);
    }

    @Override
    public String data_getUserPreference(int prefId) throws FacebookException {
        return this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_USER_PREFERENCE, Pairs.newPair("pref_id", prefId)));
    }

    @Override
    public Object data_getUserPreferences() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_USER_PREFERENCES, new Pair[0]);
    }

    @Override
    public void data_setUserPreference(int prefId, String value) throws FacebookException {
        if (value != null && value.length() > 128) {
            throw new FacebookException(100, String.format("Attempt to set a preference which hold a maximum of 128 characters to a value with %d characters. The Facebook API silently truncates this value to 128 characters which can lead to unpredictable results. If you want the truncation behaviour, please truncate the string in your Java code.", value.length()));
        }
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_USER_PREFERENCE, Pairs.newPair("pref_id", prefId), Pairs.newPair("value", value)));
    }

    @Override
    public void data_setUserPreferences(Map<Integer, String> values, boolean replace) throws FacebookException {
        JSONObject prefs = new JSONObject();
        for (Integer key : values.keySet()) {
            try {
                prefs.put(key.toString(), (Object)values.get(key));
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        }
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_USER_PREFERENCES, Pairs.newPair("values", prefs.toString()), Pairs.newPairTF("replace", replace)));
    }

    @Override
    public long data_createObject(String objectType, Map<String, String> properties) throws FacebookException {
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.DATA_CREATE_OBJECT, Pairs.newPair("obj_type", objectType), Pairs.newPair("properties", JsonHelper.toJson(properties))));
    }

    @Override
    public void data_updateObject(long objectId, Map<String, String> properties, boolean replace) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_UPDATE_OBJECT, Pairs.newPair("obj_id", String.valueOf(objectId)), Pairs.newPair("properties", JsonHelper.toJson(properties)), Pairs.newPairTF("replace", replace)));
    }

    @Override
    public void data_deleteObject(long objectId) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_DELETE_OBJECT, Pairs.newPair("obj_id", objectId)));
    }

    @Override
    public void data_deleteObjects(Collection<Long> objectIds) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_DELETE_OBJECTS, Pairs.newPair("obj_ids", BasicClientHelper.delimit(objectIds))));
    }

    @Override
    public Object data_getObject(long objectId) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT, Pairs.newPair("obj_id", objectId));
    }

    @Override
    public Object data_getObjects(Collection<Long> objectIds) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECTS, Pairs.newPair("obj_ids", BasicClientHelper.delimit(objectIds)));
    }

    @Override
    public Object data_getObjectProperty(long objectId, String propertyName) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT_PROPERTY, Pairs.newPair("obj_id", objectId), Pairs.newPair("prop_name", propertyName));
    }

    @Override
    public void data_setObjectProperty(long objectId, String propertyName, String value) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_OBJECT_PROPERTY, Pairs.newPair("obj_id", objectId), Pairs.newPair("prop_name", propertyName), Pairs.newPair("value", value)));
    }

    @Override
    public void data_createObjectType(String name) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_CREATE_OBJECT_TYPE, Pairs.newPair("name", name)));
    }

    @Override
    public void data_dropObjectType(String objectType) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_DROP_OBJECT_TYPE, Pairs.newPair("obj_type", objectType)));
    }

    @Override
    public void data_renameObjectType(String objectType, String newName) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_RENAME_OBJECT_TYPE, Pairs.newPair("obj_type", objectType), Pairs.newPair("new_name", newName)));
    }

    @Override
    public void data_defineObjectProperty(String objectType, String propertyName, PropertyType propertyType) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_DEFINE_OBJECT_PROPERTY, Pairs.newPair("obj_type", objectType), Pairs.newPair("prop_name", propertyName), Pairs.newPair("prop_type", propertyType.getValue())));
    }

    @Override
    public void data_undefineObjectProperty(String objectType, String propertyName) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_UNDEFINE_OBJECT_PROPERTY, Pairs.newPair("obj_type", objectType), Pairs.newPair("prop_name", propertyName)));
    }

    @Override
    public void data_renameObjectProperty(String objectType, String propertyName, String newPropertyName) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_RENAME_OBJECT_PROPERTY, Pairs.newPair("obj_type", objectType), Pairs.newPair("prop_name", propertyName), Pairs.newPair("new_name", newPropertyName)));
    }

    @Override
    public Object data_getObjectTypes() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT_TYPES, new Pair[0]);
    }

    @Override
    public Object data_getObjectType(String objectType) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT_TYPE, Pairs.newPair("obj_type", objectType));
    }

    @Override
    public void data_defineAssociation(String associationName, AssociationType associationType, AssociationInfo associationInfo1, AssociationInfo associationInfo2, String inverseName) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        Pairs.addParam("name", associationName, params);
        Pairs.addParam("assoc_type", associationType.getValue(), params);
        JSONObject assocInfo1 = new JSONObject();
        try {
            assocInfo1.put("alias", (Object)associationInfo1.getAlias());
            assocInfo1.put("object_type", (Object)associationInfo1.getObjectType());
            assocInfo1.put("unique", associationInfo1.isUnique());
        }
        catch (JSONException ex) {
            throw BasicClientHelper.runtimeException((Exception)((Object)ex));
        }
        Pairs.addParam("assoc_info1", assocInfo1.toString(), params);
        JSONObject assocInfo2 = new JSONObject();
        try {
            assocInfo2.put("alias", (Object)associationInfo2.getAlias());
            assocInfo2.put("object_type", (Object)associationInfo2.getObjectType());
            assocInfo2.put("unique", associationInfo2.isUnique());
        }
        catch (JSONException ex) {
            throw BasicClientHelper.runtimeException((Exception)((Object)ex));
        }
        Pairs.addParam("assoc_info2", assocInfo2, params);
        Pairs.addParamIfNotBlank("inverse", inverseName, params);
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_DEFINE_ASSOCIATION, params));
    }

    @Override
    public void data_undefineAssociation(String name) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_UNDEFINE_ASSOCIATION, Pairs.newPair("name", name)));
    }

    @Override
    public void data_renameAssociation(String name, String newName, String newAlias1, String newAlias2) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        Pairs.addParam("name", name, params);
        Pairs.addParam("new_name", newName, params);
        Pairs.addParamIfNotBlank("new_alias1", newAlias1, params);
        Pairs.addParamIfNotBlank("new_alias2", newAlias2, params);
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_RENAME_ASSOCIATION, params));
    }

    @Override
    public Object data_getAssociationDefinition(String name) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_ASSOCIATION_DEFINITION, Pairs.newPair("name", name));
    }

    @Override
    public Object data_getAssociationDefinitions() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_ASSOCIATION_DEFINITIONS, new Pair[0]);
    }

    @Override
    public void data_setAssociation(String associationName, long object1Id, long object2Id, String data, Date associationTime) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        Pairs.addParam("name", associationName, params);
        Pairs.addParam("obj_id1", object1Id, params);
        Pairs.addParam("obj_id2", object2Id, params);
        Pairs.addParamIfNotBlank("data", data, params);
        Pairs.addParamSecondsIfNotBlank("assoc_time", associationTime, params);
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_ASSOCIATION, params));
    }

    @Override
    public void data_removeAssociation(String associationName, long object1Id, long object2Id) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_REMOVE_ASSOCIATION, Pairs.newPair("name", associationName), Pairs.newPair("obj_id1", object1Id), Pairs.newPair("obj_id2", object2Id)));
    }

    @Override
    public void data_removeAssociatedObjects(String associationName, long objectId) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.DATA_REMOVE_ASSOCIATED_OBJECTS, Pairs.newPair("name", associationName), Pairs.newPair("obj_id", objectId)));
    }

    @Override
    public long data_getAssociatedObjectCount(String associationName, long objectId) throws FacebookException {
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_ASSOCIATED_OBJECT_COUNT, Pairs.newPair("name", associationName), Pairs.newPair("obj_id", objectId)));
    }

    @Override
    public boolean admin_setAppProperties(Map<ApplicationProperty, String> properties) throws FacebookException {
        if (properties == null || properties.isEmpty()) {
            return true;
        }
        JSONObject encoding1 = new JSONObject();
        JSONArray encoding2 = new JSONArray();
        for (ApplicationProperty property : properties.keySet()) {
            JSONObject temp = new JSONObject();
            if (property.getType().equals("string")) {
                try {
                    encoding1.put(property.getName(), (Object)properties.get((Object)property));
                    temp.put(property.getName(), (Object)properties.get((Object)property));
                    encoding2.put((Object)temp);
                    continue;
                }
                catch (JSONException ex) {
                    throw BasicClientHelper.runtimeException((Exception)((Object)ex));
                }
            }
            String val = properties.get((Object)property);
            val = val == null || val.equals("") || val.equalsIgnoreCase("false") || val.equals("0") ? "0" : "1";
            try {
                encoding1.put(property.getName(), (Object)val);
                temp.put(property.getName(), (Object)val);
                encoding2.put((Object)temp);
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        }
        try {
            String d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, Pairs.newPair("properties", encoding1));
            return this.extractBoolean(d);
        }
        catch (FacebookException e) {
            String d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, Pairs.newPair("properties", encoding2));
            return this.extractBoolean(d);
        }
    }

    @Override
    @Deprecated
    public JSONObject admin_getAppProperties(Collection<ApplicationProperty> properties) throws FacebookException {
        String json = this.admin_getAppPropertiesAsString(properties);
        if (json == null) {
            return null;
        }
        try {
            if (json.matches("\\{.*\\}")) {
                return new JSONObject(json);
            }
            JSONArray temp = new JSONArray(json);
            JSONObject result = new JSONObject();
            for (int count = 0; count < temp.length(); ++count) {
                JSONObject obj = (JSONObject)temp.get(count);
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String next = (String)it.next();
                    result.put(next, obj.get(next));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new FacebookException(-1, "Failed to parse server response:  " + json);
        }
    }

    @Override
    public Map<ApplicationProperty, String> admin_getAppPropertiesMap(Collection<ApplicationProperty> properties) throws FacebookException {
        return ExtensibleClient.parseAppProperties(this.admin_getAppPropertiesAsString(properties));
    }

    protected static Map<ApplicationProperty, String> parseAppProperties(String json) {
        TreeMap<ApplicationProperty, String> out = new TreeMap<ApplicationProperty, String>();
        if (json == null) {
            return null;
        }
        if (json.startsWith("{")) {
            try {
                JSONObject obj = new JSONObject(json);
                Iterator keys = obj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = obj.getString(key);
                    out.put(ApplicationProperty.valueOf(key.toUpperCase()), val);
                }
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        }
        return out;
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate) throws FacebookException {
        return this.feed_publishTemplatizedAction(titleTemplate, null);
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Long pageActorId) throws FacebookException {
        return this.feed_publishTemplatizedAction(titleTemplate, null, null, null, null, null, null, pageActorId);
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images, Long pageActorId) throws FacebookException {
        assert (null != titleTemplate && !"".equals(titleTemplate));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(15);
        params.add(Pairs.newPair("title_template", titleTemplate));
        if (null != titleData && !titleData.isEmpty()) {
            JSONObject titleDataJson = new JSONObject();
            try {
                for (String key : titleData.keySet()) {
                    titleDataJson.put(key, (Object)titleData.get(key));
                }
            }
            catch (Exception ex) {
                throw BasicClientHelper.runtimeException(ex);
            }
            params.add(Pairs.newPair("title_data", titleDataJson));
        }
        if (null != bodyTemplate && !"".equals(bodyTemplate)) {
            params.add(Pairs.newPair("body_template", bodyTemplate));
            if (null != bodyData && !bodyData.isEmpty()) {
                JSONObject bodyDataJson = new JSONObject();
                try {
                    for (String key : bodyData.keySet()) {
                        bodyDataJson.put(key, (Object)bodyData.get(key));
                    }
                }
                catch (Exception ex) {
                    throw BasicClientHelper.runtimeException(ex);
                }
                params.add(Pairs.newPair("body_data", bodyDataJson));
            }
        }
        if (null != bodyTemplate && !"".equals(bodyTemplate)) {
            params.add(Pairs.newPair("body_template", bodyTemplate));
        }
        if (null != targetIds && !targetIds.isEmpty()) {
            params.add(Pairs.newPair("target_ids", BasicClientHelper.delimit(targetIds)));
        }
        if (bodyGeneral != null) {
            params.add(Pairs.newPair("body_general", bodyGeneral));
        }
        if (pageActorId != null) {
            params.add(Pairs.newPair("page_actor_id", pageActorId));
        }
        this.handleFeedImages(params, images);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, params));
    }

    @Override
    public Object friends_getList(Long friendListId) throws FacebookException {
        if (null != friendListId && 0L <= friendListId) {
            throw new IllegalArgumentException("given invalid friendListId " + friendListId);
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET, Pairs.newPair("flid", friendListId));
    }

    @Override
    public Object friends_getLists() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_LISTS, new Pair[0]);
    }

    @Override
    public boolean admin_setAppProperties(ApplicationPropertySet properties) throws FacebookException {
        if (null == properties || properties.isEmpty()) {
            throw new IllegalArgumentException("expecting a non-empty set of application properties");
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, Pairs.newPair("properties", properties.toJson())));
    }

    @Override
    public ApplicationPropertySet admin_getAppPropertiesAsSet(Collection<ApplicationProperty> properties) throws FacebookException {
        String propJson = this.admin_getAppPropertiesAsString(properties);
        return new ApplicationPropertySet(propJson);
    }

    @Override
    public void beginBatch() {
        this.batchMode = true;
        this.queries = new ArrayList<BatchQuery>();
    }

    protected String encodeMethods(List<BatchQuery> queryList) throws FacebookException {
        JSONArray result = new JSONArray();
        for (BatchQuery query : queryList) {
            if (query.getMethod().takesFile()) {
                throw new FacebookException(100, "File upload API calls cannot be batched:  " + query.getMethod().methodName());
            }
            result.put((Object)BasicClientHelper.delimit(query.getParams().entrySet(), "&", "=", true));
        }
        return result.toString();
    }

    @Override
    public String batch_run(String methods, boolean serial) throws FacebookException {
        if (!serial) {
            return this.callMethod((IFacebookMethod)FacebookMethod.BATCH_RUN, Pairs.newPair("method_feed", methods));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.BATCH_RUN, Pairs.newPair("method_feed", methods), Pairs.newPair("serial_only", "1"));
    }

    @Override
    public Object application_getPublicInfo(Long applicationId, String applicationKey, String applicationCanvas) throws FacebookException {
        Pair<String, CharSequence> pair = null;
        if (applicationId != null && applicationId > 0L) {
            pair = Pairs.newPair("application_id", applicationId);
        } else if (applicationKey != null && !"".equals(applicationKey)) {
            pair = Pairs.newPair("application_api_key", applicationKey);
        } else if (applicationCanvas != null && !"".equals(applicationCanvas)) {
            pair = Pairs.newPair("application_canvas_name", applicationCanvas);
        } else {
            throw new FacebookException(100, "You must specify at least/most one of {applicationId, applicationKey, applicationCanvas}");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.APPLICATION_GET_PUBLIC_INFO, pair);
    }

    @Override
    public Object application_getPublicInfoById(Long applicationId) throws FacebookException {
        return this.application_getPublicInfo(applicationId, null, null);
    }

    @Override
    public Object application_getPublicInfoByApiKey(String applicationKey) throws FacebookException {
        return this.application_getPublicInfo(null, applicationKey, null);
    }

    @Override
    public Object application_getPublicInfoByCanvasName(String applicationCanvas) throws FacebookException {
        return this.application_getPublicInfo(null, null, applicationCanvas);
    }

    @Override
    public int admin_getAllocation(String allocationType) throws FacebookException {
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_ALLOCATION, Pairs.newPair("integration_point_name", allocationType)));
    }

    @Override
    public int admin_getAllocation(String allocationType, Long userId) throws FacebookException {
        if (userId != null) {
            return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_ALLOCATION, Pairs.newPair("integration_point_name", allocationType), Pairs.newPair("user", userId)));
        }
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_ALLOCATION, Pairs.newPair("integration_point_name", allocationType)));
    }

    @Override
    public int admin_getAllocation(AllocationType allocationType) throws FacebookException {
        return this.admin_getAllocation(allocationType.getName());
    }

    @Override
    public int admin_getAllocation(AllocationType allocationType, Long userId) throws FacebookException {
        return this.admin_getAllocation(allocationType.getName(), userId);
    }

    @Override
    @Deprecated
    public int admin_getNotificationAllocation() throws FacebookException {
        return this.admin_getAllocation("notifications_per_day");
    }

    @Override
    @Deprecated
    public int admin_getRequestAllocation() throws FacebookException {
        return this.admin_getAllocation("requests_per_day");
    }

    @Override
    @Deprecated
    public Object admin_getDailyMetrics(Set<Metric> metrics, Date start, Date end) throws FacebookException {
        return this.admin_getDailyMetrics(metrics, start.getTime(), end.getTime());
    }

    @Override
    @Deprecated
    public Object admin_getDailyMetrics(Set<Metric> metrics, long start, long end) throws FacebookException {
        int size = 2 + (metrics != null ? metrics.size() : 0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(size);
        if (metrics != null) {
            metrics.remove((Object)Metric.ACTIVE_USERS);
            if (!metrics.isEmpty()) {
                JSONArray metricsJson = new JSONArray();
                for (Metric metric : metrics) {
                    metricsJson.put((Object)metric.getName());
                }
                params.add(Pairs.newPair("metrics", metricsJson));
            }
        }
        params.add(Pairs.newPair("start_date", start / 1000L));
        params.add(Pairs.newPair("end_date", end / 1000L));
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_DAILY_METRICS, params);
    }

    @Override
    public Object permissions_checkGrantedApiAccess(String apiKey) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_GRANTED_API_ACCESS, Pairs.newPair("permissions_apikey", apiKey));
    }

    @Override
    public Object permissions_checkAvailableApiAccess(String apiKey) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_AVAILABLE_API_ACCESS, Pairs.newPair("permissions_apikey", apiKey));
    }

    @Override
    public boolean permissions_grantApiAccess(String apiKey, Set<FacebookMethod> methods) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (methods != null && !methods.isEmpty()) {
            JSONArray methodsJson = new JSONArray();
            for (FacebookMethod method : methods) {
                methodsJson.put((Object)method.methodName());
            }
            params.add(Pairs.newPair("method_arr", methodsJson));
        }
        params.add(Pairs.newPair("permissions_apikey", apiKey));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_GRANT_API_ACCESS, params));
    }

    @Override
    public boolean permissions_grantFullApiAccess(String apiKey) throws FacebookException {
        return this.permissions_grantApiAccess(apiKey, null);
    }

    @Override
    public boolean permissions_revokeApiAccess(String apiKey) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_REVOKE_API_ACCESS, Pairs.newPair("permissions_apikey", apiKey)));
    }

    @Override
    public String auth_promoteSession() throws FacebookException {
        return this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_PROMOTE_SESSION, new Pair[0]));
    }

    @Override
    public boolean auth_revokeAuthorization() throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_REVOKE_AUTHORIZATION, new Pair[0]));
    }

    @Override
    public boolean auth_revokeExtendedPermission(Permission perm) throws FacebookException {
        return this.auth_revokeExtendedPermission(perm, null);
    }

    @Override
    public boolean auth_revokeExtendedPermission(Permission perm, Long userId) throws FacebookException {
        if (userId != null) {
            return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_REVOKE_EXTENDED_PERMISSION_NOSESSION, Pairs.newPair("perm", perm.getName()), Pairs.newPair("uid", userId)));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_REVOKE_EXTENDED_PERMISSION, Pairs.newPair("perm", perm.getName())));
    }

    @Override
    public boolean auth_expireSession() throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_EXPIRE_SESSION, new Pair[0]));
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded(Long userId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED_NOSESSION, Pairs.newPair("uid", userId)));
    }

    @Override
    public boolean users_setStatus(String status, Long userId) throws FacebookException {
        return this.users_setStatus(status, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, Long userId) throws FacebookException {
        return this.users_setStatus(newStatus, clear, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(Pairs.newPair("status", newStatus));
        }
        if (clear) {
            params.add(Pairs.newPair("clear", "true"));
        }
        if (statusIncludesVerb) {
            params.add(Pairs.newPair("status_includes_verb", "true"));
        }
        params.add(Pairs.newPair("uid", userId));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS_NOSESSION, params));
    }

    @Override
    @Deprecated
    public Object feed_getRegisteredTemplateBundleByID(Long id) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATE_BY_ID, Pairs.newPair("template_bundle_id", id));
    }

    @Override
    @Deprecated
    public Object feed_getRegisteredTemplateBundles() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATES, new Pair[0]);
    }

    @Override
    @Deprecated
    public Boolean feed_publishUserAction(Long bundleId) throws FacebookException {
        return this.feed_publishUserAction(bundleId, null, null, null);
    }

    @Override
    @Deprecated
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<Long> targetIds, String bodyGeneral) throws FacebookException {
        return this.feed_publishUserAction(bundleId, templateData, null, targetIds, bodyGeneral, 0);
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(String template) throws FacebookException {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(template);
        return this.feed_registerTemplateBundle(temp);
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(Collection<String> templates) throws FacebookException {
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(Collection<String> templates, Collection<BundleStoryTemplate> shortTemplates, BundleStoryTemplate longTemplate) throws FacebookException {
        return this.feed_registerTemplateBundle(templates, shortTemplates, longTemplate, null);
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(Collection<String> templates, Collection<BundleStoryTemplate> shortTemplates, BundleStoryTemplate longTemplate, List<BundleActionLink> actionLinks) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray templateArray = new JSONArray();
        for (String template : templates) {
            templateArray.put((Object)template);
        }
        params.add(Pairs.newPair("one_line_story_templates", templateArray));
        if (shortTemplates != null && !shortTemplates.isEmpty()) {
            JSONArray shortArray = new JSONArray();
            for (BundleStoryTemplate template : shortTemplates) {
                shortArray.put((Object)template.toJson());
            }
            params.add(Pairs.newPair("short_story_templates", shortArray));
        }
        if (longTemplate != null) {
            params.add(Pairs.newPair("full_story_template", longTemplate.toJson()));
        }
        if (actionLinks != null && !actionLinks.isEmpty()) {
            JSONArray actionLinkArray = new JSONArray();
            for (BundleActionLink actionLink : actionLinks) {
                actionLinkArray.put((Object)actionLink.toJson());
            }
            params.add(Pairs.newPair("action_links", actionLinkArray));
        }
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.FEED_REGISTER_TEMPLATE, params));
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(String template, String shortTemplate, String longTemplate) throws FacebookException {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add(template);
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    @Deprecated
    public Object profile_getFBML() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    @Deprecated
    public Object profile_getFBML(Long userId) throws FacebookException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, Pairs.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    @Deprecated
    public Object profile_getFBML(int type) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, Pairs.newPair("type", type));
    }

    @Override
    @Deprecated
    public Object profile_getFBML(int type, Long userId) throws FacebookException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, Pairs.newPair("type", type), Pairs.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, Pairs.newPair("type", type));
    }

    @Override
    @Deprecated
    public Object profile_getInfo(Long userId) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO, Pairs.newPair("uid", userId));
    }

    @Override
    @Deprecated
    public Object profile_getInfoOptions(String field) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO_OPTIONS, Pairs.newPair("field", field));
    }

    @Override
    @Deprecated
    public void profile_setInfo(Long userId, String title, boolean textOnly, List<ProfileInfoField> fields) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray json = new JSONArray();
        params.add(Pairs.newPair("uid", userId));
        params.add(Pairs.newPair("title", title));
        if (textOnly) {
            params.add(Pairs.newPair("type", "1"));
        } else {
            params.add(Pairs.newPair("type", "5"));
        }
        for (ProfileInfoField field : fields) {
            try {
                JSONObject innerJSON = new JSONObject();
                JSONArray fieldItems = new JSONArray();
                innerJSON.put("field", (Object)field.getFieldName());
                for (ProfileFieldItem item : field.getItems()) {
                    JSONObject itemJSON = new JSONObject();
                    for (String key : item.getMap().keySet()) {
                        itemJSON.put(key, (Object)item.getMap().get(key));
                    }
                    fieldItems.put((Object)itemJSON);
                }
                innerJSON.put("items", (Object)fieldItems);
                json.put((Object)innerJSON);
            }
            catch (Exception ex) {
                throw BasicClientHelper.runtimeException(ex);
            }
        }
        params.add(Pairs.newPair("info_fields", json));
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO, params));
    }

    @Override
    @Deprecated
    public void profile_setInfoOptions(ProfileInfoField field) throws FacebookException {
        JSONArray json = new JSONArray();
        for (ProfileFieldItem item : field.getItems()) {
            JSONObject itemJSON = new JSONObject();
            for (String key : item.getMap().keySet()) {
                try {
                    itemJSON.put(key, (Object)item.getMap().get(key));
                }
                catch (Exception ex) {
                    throw BasicClientHelper.runtimeException(ex);
                }
            }
            json.put((Object)itemJSON);
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(2);
        Pairs.addParam("field", field.getFieldName(), params);
        Pairs.addParam("options", json.toString(), params);
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO_OPTIONS, params));
    }

    @Override
    @Deprecated
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    @Deprecated
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    @Deprecated
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), ExtensibleClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    @Deprecated
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), ExtensibleClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    @Deprecated
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, null, null, ExtensibleClient.toString(fbmlMarkup), null);
    }

    @Override
    @Deprecated
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, null, null, ExtensibleClient.toString(fbmlMarkup), null);
    }

    @Override
    @Deprecated
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, null, ExtensibleClient.toString(fbmlMarkup), null, null);
    }

    @Override
    @Deprecated
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, null, ExtensibleClient.toString(fbmlMarkup), null, null);
    }

    @Override
    @Deprecated
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, ExtensibleClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    @Deprecated
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    @Deprecated
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml) throws FacebookException {
        return this.profile_setFBML(userId, profileFbml, actionFbml, mobileFbml, null);
    }

    @Override
    @Deprecated
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml, String profileMain) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        Pairs.addParamIfNotBlank("uid", userId, params);
        Pairs.addParamIfNotBlank("profile", profileFbml, params);
        Pairs.addParamIfNotBlank("profile_action", actionFbml, params);
        Pairs.addParamIfNotBlank("mobile_fbml", mobileFbml, params);
        Pairs.addParamIfNotBlank("profile_main", profileMain, params);
        FacebookMethod method = this.isDesktop() || userId == null ? FacebookMethod.PROFILE_SET_FBML : FacebookMethod.PROFILE_SET_FBML_NOSESSION;
        return this.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    @Override
    public Boolean liveMessage_send(Long recipient, String eventName, JSONObject message) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.LIVEMESSAGE_SEND, Pairs.newPair("recipient", recipient), Pairs.newPair("event_name", eventName), Pairs.newPair("message", message)));
    }

    @Override
    public Long links_post(Long userId, String url, String comment) throws FacebookException {
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.LINKS_POST, Pairs.newPair("uid", userId), Pairs.newPair("url", url), Pairs.newPair("comment", comment)));
    }

    @Override
    public Object admin_getMetrics(Set<Metric> metrics, Date start, Date end, long period) throws FacebookException {
        return this.admin_getMetrics(metrics, start.getTime(), end.getTime(), period);
    }

    @Override
    public Object admin_getMetrics(Set<Metric> metrics, long start, long end, long period) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (metrics != null && !metrics.isEmpty()) {
            JSONArray metricsJson = new JSONArray();
            for (Metric metric : metrics) {
                metricsJson.put((Object)metric.getName());
            }
            Pairs.addParam("metrics", metricsJson, params);
        }
        Pairs.addParam("start_time", start / 1000L, params);
        Pairs.addParam("end_time", end / 1000L, params);
        Pairs.addParam("period", period, params);
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_METRICS, params);
    }

    @Override
    @Deprecated
    public boolean feed_deactivateTemplateBundleByID(Long bundleId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_DEACTIVATE_TEMPLATE_BUNDLE, Pairs.newPair("template_bundle_id", bundleId)));
    }

    @Override
    @Deprecated
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<IFeedImage> images, List<Long> targetIds, String bodyGeneral, int storySize) throws FacebookException {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("Maximum of 4 images allowed per feed item.");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(Pairs.newPair("template_bundle_id", bundleId));
        if (targetIds != null && !targetIds.isEmpty()) {
            params.add(Pairs.newPair("target_ids", BasicClientHelper.delimit(targetIds)));
        }
        if (bodyGeneral != null && !"".equals(bodyGeneral)) {
            params.add(Pairs.newPair("body_general", bodyGeneral));
        }
        if (storySize == 1 || storySize == 2 || storySize == 4) {
            params.add(Pairs.newPair("story_size", storySize));
        }
        JSONObject jsonTemplateData = new JSONObject();
        if (templateData != null && !templateData.isEmpty()) {
            for (String key : templateData.keySet()) {
                try {
                    jsonTemplateData.put(key, (Object)templateData.get(key));
                }
                catch (Exception exception) {
                    throw BasicClientHelper.runtimeException(exception);
                }
            }
        }
        if (images != null && !images.isEmpty()) {
            try {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < images.size(); ++i) {
                    IFeedImage image = images.get(i);
                    JSONObject jsonImage = new JSONObject();
                    jsonImage.put("src", (Object)image.getImageUrlString());
                    jsonImage.put("href", (Object)image.getLinkUrl().toExternalForm());
                    jsonArray.put(i, (Object)jsonImage);
                }
                jsonTemplateData.put("images", (Object)jsonArray);
            }
            catch (Exception exception) {
                throw BasicClientHelper.runtimeException(exception);
            }
        }
        if (jsonTemplateData.length() > 0) {
            params.add(Pairs.newPair("template_data", jsonTemplateData));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_USER_ACTION, params));
    }

    @Override
    public Object stream_get(Long viewerId, List<Long> sourceIds, Date start, Date end, Integer limit, String filterKey, List<String> metadata) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (viewerId != null) {
            params.add(Pairs.newPair("viewer_id", viewerId));
        }
        if (sourceIds != null && !sourceIds.isEmpty()) {
            params.add(Pairs.newPair("source_ids", BasicClientHelper.delimit(sourceIds)));
        }
        if (start != null) {
            params.add(Pairs.newPair("start_time", start.getTime() / 1000L));
        }
        if (end != null) {
            params.add(Pairs.newPair("end_time", end.getTime() / 1000L));
        }
        if (limit != null) {
            params.add(Pairs.newPair("limit", limit));
        }
        if (!StringUtils.isEmpty((String)filterKey)) {
            params.add(Pairs.newPair("filter_key", filterKey));
        }
        JSONArray jsonMetadata = new JSONArray();
        if (metadata != null && !metadata.isEmpty()) {
            for (String key : metadata) {
                jsonMetadata.put((Object)key);
            }
        }
        if (jsonMetadata.length() > 0) {
            params.add(Pairs.newPair("metadata", jsonMetadata));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.STREAM_GET, params);
    }

    @Override
    public String stream_publish(String message, Attachment attachment, Collection<BundleActionLink> actionLinks, Long targetId, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (this.isDesktop()) {
            params.add(Pairs.newPair("session_key", this.getCacheSessionKey()));
        } else if (userId != null) {
            params.add(Pairs.newPair("uid", userId));
        }
        Pairs.addParamIfNotBlank("message", message, params);
        Pairs.addParamJsonIfNotBlank("attachment", attachment, params);
        JSONArray jsonActionLinks = BundleActionLink.toJsonArray(actionLinks);
        Pairs.addParamIfNotBlank("action_links", jsonActionLinks, params);
        Pairs.addParamIfNotBlank("target_id", targetId, params);
        return this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.STREAM_PUBLISH, params));
    }

    @Override
    public boolean stream_remove(String postId, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (this.isDesktop()) {
            params.add(Pairs.newPair("session_key", this.getCacheSessionKey()));
        } else if (userId != null) {
            params.add(Pairs.newPair("uid", userId));
        }
        Pairs.addParamIfNotBlank("post_id", postId, params);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.STREAM_REMOVE, params));
    }

    @Override
    public Object stream_getComments(String postId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        Pairs.addParamIfNotBlank("post_id", postId, params);
        return this.callMethod((IFacebookMethod)FacebookMethod.STREAM_GET_COMMENTS, params);
    }

    @Override
    public String stream_addComment(String postId, String comment, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        Pairs.addParamIfNotBlank("post_id", postId, params);
        Pairs.addParamIfNotBlank("comment", comment, params);
        Pairs.addParamIfNotBlank("uid", userId, params);
        return this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.STREAM_ADD_COMMENT, params));
    }

    @Override
    public boolean stream_removeComment(String commentId, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (this.isDesktop()) {
            params.add(Pairs.newPair("session_key", this.getCacheSessionKey()));
        } else if (userId != null) {
            params.add(Pairs.newPair("uid", userId));
        }
        Pairs.addParamIfNotBlank("comment_id", commentId, params);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.STREAM_REMOVE_COMMENT, params));
    }

    @Override
    public boolean stream_addLike(String postId, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (this.isDesktop()) {
            params.add(Pairs.newPair("session_key", this.getCacheSessionKey()));
        } else if (userId != null) {
            params.add(Pairs.newPair("uid", userId));
        }
        Pairs.addParamIfNotBlank("post_id", postId, params);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.STREAM_ADD_LIKE, params));
    }

    @Override
    public boolean stream_removeLike(String postId, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (this.isDesktop()) {
            params.add(Pairs.newPair("session_key", this.getCacheSessionKey()));
        } else if (userId != null) {
            params.add(Pairs.newPair("uid", userId));
        }
        Pairs.addParamIfNotBlank("post_id", postId, params);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.STREAM_REMOVE_LIKE, params));
    }

    @Override
    public Object stream_getFilters(Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (this.isDesktop()) {
            params.add(Pairs.newPair("session_key", this.getCacheSessionKey()));
        } else if (userId != null) {
            params.add(Pairs.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.STREAM_GET_FILTERS, params);
    }

    protected static String toString(CharSequence cs) {
        return BasicClientHelper.toString(cs);
    }

    protected boolean extractBoolean(String result) throws FacebookException {
        if ("json".equals(this.responseFormat)) {
            Object out = JsonHelper.parseCallResult(result);
            if (out instanceof Boolean) {
                return (Boolean)out;
            }
            return Boolean.parseBoolean(String.valueOf(out));
        }
        return XmlHelper.extractBoolean(XmlHelper.parseCallResult(result, this.factory));
    }

    protected boolean extractBoolean10(String result) throws FacebookException {
        return this.extractInt(result) == 1;
    }

    protected int extractInt(String result) throws FacebookException {
        if ("json".equals(this.responseFormat)) {
            return ((Number)JsonHelper.parseCallResult(result)).intValue();
        }
        return XmlHelper.extractInt(XmlHelper.parseCallResult(result, this.factory));
    }

    protected long extractLong(String result) throws FacebookException {
        if ("json".equals(this.responseFormat)) {
            return ((Number)JsonHelper.parseCallResult(result)).longValue();
        }
        return XmlHelper.extractLong(XmlHelper.parseCallResult(result, this.factory));
    }

    protected String extractString(String result) throws FacebookException {
        if ("json".equals(this.responseFormat)) {
            return String.valueOf(JsonHelper.parseCallResult(result));
        }
        return XmlHelper.extractString(XmlHelper.parseCallResult(result, this.factory));
    }

    @Override
    public Object events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime) throws FacebookException {
        return this.events_get(userId, eventIds, startTime, endTime, null);
    }

    @Override
    public Object events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime, String rsvp_status) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        Pairs.addParamIfNotBlankZero("uid", userId, params);
        Pairs.addParamDelimitIfNotBlankEmpty("eids", eventIds, params);
        Pairs.addParamIfNotBlankZero("start_time", startTime, params);
        Pairs.addParamIfNotBlankZero("end_time", endTime, params);
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET, params);
    }

    @Override
    public Object events_getMembers(Long eventId) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_MEMBERS, Pairs.newPair("eid", eventId));
    }

    @Override
    public Long events_create(Map<String, String> event_info) throws FacebookException {
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_CREATE, Pairs.newPair("event_info", new JSONObject(event_info))));
    }

    @Override
    public boolean events_edit(Long eid, Map<String, String> event_info) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_EDIT, Pairs.newPair("eid", eid), Pairs.newPair("event_info", new JSONObject(event_info))));
    }

    @Override
    public boolean events_cancel(Long eid, String cancel_message) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_CANCEL, Pairs.newPair("eid", eid), Pairs.newPair("cancel_message", cancel_message)));
    }

    @Override
    public boolean events_rsvp(Long eid, String rsvp_status) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_RSVP, Pairs.newPair("eid", eid), Pairs.newPair("rsvp_status", rsvp_status)));
    }

    @Override
    public boolean sms_canSend() throws FacebookException {
        return this.sms_canSend(this.users_getLoggedInUser());
    }

    @Override
    public boolean sms_canSend(Long userId) throws FacebookException {
        int out = this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_CAN_SEND, Pairs.newPair("uid", userId)));
        return out == 0;
    }

    @Override
    public Integer sms_send(String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException {
        return this.sms_send(this.users_getLoggedInUser(), message, smsSessionId, makeNewSession);
    }

    @Override
    public Integer sms_send(Long userId, String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException {
        if (smsSessionId != null && smsSessionId != 0) {
            return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, Pairs.newPair("uid", userId), Pairs.newPair("message", message), Pairs.newPair("session_id", smsSessionId), Pairs.newPair10("req_session", makeNewSession)));
        }
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, Pairs.newPair("uid", userId), Pairs.newPair("message", message), Pairs.newPair10("req_session", makeNewSession)));
    }

    @Override
    public void sms_sendMessage(Long userId, CharSequence message) throws FacebookException {
        this.sms_send(userId, ((Object)message).toString(), null, false);
    }

    @Override
    public int sms_sendMessageWithSession(Long userId, CharSequence message) throws FacebookException {
        return this.sms_send(userId, ((Object)message).toString(), null, true);
    }

    @Override
    public Object connect_registerUsers(Collection<Map<String, String>> accounts) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.CONNECT_REGISTER_USERS, Pairs.newPair("accounts", JsonHelper.toJsonListOfMaps(accounts)));
    }

    @Override
    public Object connect_unregisterUsers(Collection<String> email_hashes) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.CONNECT_UNREGISTER_USERS, Pairs.newPair("email_hashes", JsonHelper.toJsonListOfStrings(email_hashes)));
    }

    @Override
    public int connect_getUnconnectedFriendsCount() throws FacebookException {
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.CONNECT_GET_UNCONNECTED_FRIENDS_COUNT, new Pair[0]));
    }

    @Override
    public Object photos_get(Collection<String> photoIds) throws FacebookException {
        return this.photos_get(null, null, photoIds);
    }

    @Override
    public Object photos_get(Long subjId, String albumId) throws FacebookException {
        return this.photos_get(subjId, albumId, null);
    }

    @Override
    public Object photos_get(Long subjId, Collection<String> photoIds) throws FacebookException {
        return this.photos_get(subjId, null, photoIds);
    }

    @Override
    public Object photos_get(Long subjId) throws FacebookException {
        return this.photos_get(subjId, null, null);
    }

    @Override
    public Object photos_get(Long subjId, String albumId, Collection<String> photoIds) throws FacebookException {
        boolean hasPhotoIds;
        boolean hasUserId = null != subjId && 0L != subjId;
        boolean hasAlbumId = albumId != null;
        boolean bl = hasPhotoIds = null != photoIds && !photoIds.isEmpty();
        if (!(hasUserId || hasAlbumId || hasPhotoIds)) {
            throw new IllegalArgumentException("At least one of photoIds, albumId, or subjId must be provided");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        if (hasUserId) {
            params.add(Pairs.newPair("subj_id", subjId));
        }
        if (hasAlbumId) {
            params.add(Pairs.newPair("aid", albumId));
        }
        if (hasPhotoIds) {
            params.add(Pairs.newPair("pids", BasicClientHelper.delimit(photoIds)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET, params);
    }

    @Override
    public Object photos_getTags(Collection<String> photoIds) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_TAGS, Pairs.newPair("pids", BasicClientHelper.delimit(photoIds)));
    }

    @Override
    public boolean photos_addTag(String photoId, CharSequence tagText, Double xPct, Double yPct) throws FacebookException {
        return this.photos_addTag(photoId, xPct, yPct, null, tagText);
    }

    private boolean photos_addTag(String photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText) throws FacebookException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        Pair<String, CharSequence> tagData = taggedUserId != null ? Pairs.newPair("tag_uid", taggedUserId) : Pairs.newPair("tag_text", tagText);
        String d = this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, Pairs.newPair("pid", photoId), tagData, Pairs.newPair("x", xPct), Pairs.newPair("y", yPct));
        return this.extractBoolean(d);
    }

    @Override
    public Object photos_createAlbum(String albumName) throws FacebookException {
        return this.photos_createAlbum(albumName, null, null);
    }

    @Override
    public boolean photos_addTag(String photoId, Long taggedUserId, Double xPct, Double yPct) throws FacebookException {
        return this.photos_addTag(photoId, xPct, yPct, taggedUserId, null);
    }

    @Override
    public Object photos_addTags(String photoId, Collection<PhotoTag> tags) throws FacebookException {
        assert (photoId != null);
        assert (null != tags && !tags.isEmpty());
        JSONArray jsonTags = new JSONArray();
        for (PhotoTag tag : tags) {
            jsonTags.put((Object)tag.jsonify());
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, Pairs.newPair("pid", photoId), Pairs.newPair("tags", jsonTags));
    }

    @Override
    public Object photos_createAlbum(String name, String description, String location) throws FacebookException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        params.add(Pairs.newPair("name", name));
        if (null != description) {
            params.add(Pairs.newPair("description", description));
        }
        if (null != location) {
            params.add(Pairs.newPair("location", location));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_CREATE_ALBUM, params);
    }

    @Override
    public Object photos_getAlbums(Collection<String> albumIds) throws FacebookException {
        return this.photos_getAlbums(null, albumIds);
    }

    @Override
    public Object photos_getAlbums(Long userId) throws FacebookException {
        return this.photos_getAlbums(userId, null);
    }

    @Override
    public Object photos_getAlbums(Long userId, Collection<String> albumIds) throws FacebookException {
        boolean hasAlbumIds;
        boolean hasUserId = null != userId && userId != 0L;
        boolean bl = hasAlbumIds = null != albumIds && !albumIds.isEmpty();
        if (hasUserId && hasAlbumIds) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, Pairs.newPair("uid", userId), Pairs.newPair("aids", BasicClientHelper.delimit(albumIds)));
        }
        if (hasUserId) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, Pairs.newPair("uid", userId));
        }
        if (hasAlbumIds) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, Pairs.newPair("aids", BasicClientHelper.delimit(albumIds)));
        }
        throw new FacebookException(100, "Atleast one of userId or albumIds is required.");
    }

    @Override
    public Object photos_getByAlbum(String albumId, Collection<String> photoIds) throws FacebookException {
        return this.photos_get(null, albumId, photoIds);
    }

    @Override
    public Object photos_getByAlbum(String albumId) throws FacebookException {
        return this.photos_get(null, albumId, null);
    }

    private boolean photos_addTag(String photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText, Long userId) throws FacebookException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        if (taggedUserId != null) {
            params.add(Pairs.newPair("tag_uid", taggedUserId));
        } else {
            params.add(Pairs.newPair("tag_text", tagText));
        }
        params.add(Pairs.newPair("x", xPct));
        params.add(Pairs.newPair("y", yPct));
        params.add(Pairs.newPair("pid", photoId));
        params.add(Pairs.newPair("owner_uid", userId));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, params));
    }

    @Override
    public boolean photos_addTag(String photoId, Long taggedUserId, Double pct, Double pct2, Long userId) throws FacebookException {
        return this.photos_addTag(photoId, pct, pct2, taggedUserId, null, userId);
    }

    @Override
    public boolean photos_addTag(String photoId, CharSequence tagText, Double pct, Double pct2, Long userId) throws FacebookException {
        return this.photos_addTag(photoId, pct, pct2, null, tagText);
    }

    @Override
    public Object photos_createAlbum(String albumName, Long userId) throws FacebookException {
        return this.photos_createAlbum(albumName, null, null, userId);
    }

    @Override
    public Object photos_createAlbum(String name, String description, String location, Long userId) throws FacebookException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        params.add(Pairs.newPair("name", name));
        if (null != description) {
            params.add(Pairs.newPair("description", description));
        }
        if (null != location) {
            params.add(Pairs.newPair("location", location));
        }
        params.add(Pairs.newPair("uid", userId));
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_CREATE_ALBUM_NOSESSION, params);
    }

    @Override
    public Object photos_addTags(String photoId, Collection<PhotoTag> tags, Long userId) throws FacebookException {
        assert (photoId != null);
        assert (null != tags && !tags.isEmpty());
        String tagStr = null;
        try {
            JSONArray jsonTags = new JSONArray();
            for (PhotoTag tag : tags) {
                jsonTags.put((Object)tag.jsonify());
            }
            tagStr = jsonTags.toString();
        }
        catch (Exception ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, Pairs.newPair("pid", photoId), Pairs.newPair("tags", tagStr), Pairs.newPair("uid", userId));
    }

    @Override
    public Object photos_upload(File photo) throws FacebookException {
        return this.photos_upload(photo, null, null);
    }

    @Override
    public Object photos_uploadWithCaption(File photo, String caption) throws FacebookException {
        return this.photos_upload(photo, caption, null);
    }

    @Override
    public Object photos_uploadToAlbum(File photo, String albumId) throws FacebookException {
        return this.photos_upload(photo, null, albumId);
    }

    @Override
    public Object photos_upload(File photo, String caption, String albumId) throws FacebookException {
        return this.photos_upload(null, photo, caption, albumId);
    }

    @Override
    public Object photos_upload(Long userId, File photo) throws FacebookException {
        return this.photos_upload(userId, photo, null, null);
    }

    @Override
    public Object photos_uploadWithCaption(Long userId, File photo, String caption) throws FacebookException {
        return this.photos_upload(userId, photo, caption, null);
    }

    @Override
    public Object photos_uploadToAlbum(Long userId, File photo, String albumId) throws FacebookException {
        return this.photos_upload(userId, photo, null, albumId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object photos_upload(Long userId, File photo, String caption, String albumId) throws FacebookException {
        Object object;
        FileInputStream fileInputStream = new FileInputStream(photo);
        BufferedInputStream fileStream = new BufferedInputStream(fileInputStream);
        try {
            object = this.photos_upload(userId, caption, albumId, photo.getName(), fileStream);
        }
        catch (Throwable throwable) {
            try {
                BasicClientHelper.close(fileStream);
                BasicClientHelper.close(fileInputStream);
                throw throwable;
            }
            catch (IOException ex) {
                throw BasicClientHelper.runtimeException(ex);
            }
        }
        BasicClientHelper.close(fileStream);
        BasicClientHelper.close(fileInputStream);
        return object;
    }

    @Override
    public Object photos_upload(Long userId, String caption, String albumId, String fileName, InputStream fileStream) throws FacebookException {
        if (fileStream == null) {
            throw new FacebookException(100, "fileStream specified was null. fileName was specified as " + fileName);
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        Pairs.addParamIfNotBlank("aid", albumId, params);
        Pairs.addParamIfNotBlank("caption", caption, params);
        boolean uid = Pairs.addParamIfNotBlankZero("uid", userId, params);
        FacebookMethod method = uid ? FacebookMethod.PHOTOS_UPLOAD_NOSESSION : FacebookMethod.PHOTOS_UPLOAD;
        return this.callMethod((IFacebookMethod)method, params, fileName, fileStream);
    }

    @Override
    @Deprecated
    public Object notifications_get() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_GET, new Pair[0]);
    }

    @Override
    @Deprecated
    public URL notifications_send(Collection<Long> recipientIds, CharSequence notification, CharSequence email) throws FacebookException {
        this.notifications_send(recipientIds, notification);
        return null;
    }

    @Override
    @Deprecated
    public Collection<String> notifications_send(Collection<Long> recipientIds, CharSequence notification) throws FacebookException {
        return this.notifications_send(recipientIds, ((Object)notification).toString(), false);
    }

    @Override
    @Deprecated
    public Collection<String> notifications_send(CharSequence notification) throws FacebookException {
        return this.notifications_send(Arrays.asList(this.users_getLoggedInUser()), notification);
    }

    @Override
    @Deprecated
    public Collection<String> notifications_send(Collection<Long> recipientIds, String notification, boolean isAppToUser) throws FacebookException {
        FacebookMethod method = FacebookMethod.NOTIFICATIONS_SEND;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        Pairs.addParam("type", isAppToUser ? "app_to_user" : "user_to_user", params);
        Pairs.addParam("notification", notification, params);
        Pairs.addParamDelimitIfNotBlankEmpty("to_ids", recipientIds, params);
        String outString = this.extractString(this.callMethod((IFacebookMethod)method, params));
        if (outString.trim().length() == 0) {
            return Collections.emptySet();
        }
        return new TreeSet<String>(Arrays.asList(outString.split(",")));
    }

    @Override
    public Collection<String> notifications_sendEmail(Collection<Long> recipients, CharSequence subject, CharSequence text, CharSequence fbml) throws FacebookException {
        FacebookMethod method = this.isDesktop() ? FacebookMethod.NOTIFICATIONS_SEND_EMAIL_SESSION : FacebookMethod.NOTIFICATIONS_SEND_EMAIL_NOSESSION;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        Pairs.addParam("recipients", BasicClientHelper.delimit(recipients), params);
        Pairs.addParam("subject", subject, params);
        Pairs.addParamIfNotBlank("text", text, params);
        Pairs.addParamIfNotBlank("fbml", fbml, params);
        String outString = this.extractString(this.callMethod((IFacebookMethod)method, params));
        if (outString.trim().length() == 0) {
            return Collections.emptySet();
        }
        return new TreeSet<String>(Arrays.asList(outString.split(",")));
    }

    @Override
    public Collection<String> notifications_sendFbmlEmail(Collection<Long> recipients, String subject, String fbml) throws FacebookException {
        return this.notifications_sendEmail(recipients, subject, null, fbml);
    }

    @Override
    public Collection<String> notifications_sendTextEmail(Collection<Long> recipients, String subject, String email) throws FacebookException {
        return this.notifications_sendEmail(recipients, subject, email, null);
    }

    @Override
    public Collection<String> notifications_sendEmailToCurrentUser(String subject, String email, String fbml) throws FacebookException {
        return this.notifications_sendEmail(Arrays.asList(this.users_getLoggedInUser()), subject, email, fbml);
    }

    @Override
    public Collection<String> notifications_sendFbmlEmailToCurrentUser(String subject, String fbml) throws FacebookException {
        return this.notifications_sendEmailToCurrentUser(subject, null, fbml);
    }

    @Override
    public Collection<String> notifications_sendTextEmailToCurrentUser(String subject, String email) throws FacebookException {
        return this.notifications_sendEmailToCurrentUser(subject, email, null);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailStr(Collection<Long> recipients, CharSequence subject, CharSequence fbml, CharSequence text) throws FacebookException {
        return ((Object)BasicClientHelper.delimit(this.notifications_sendEmail(recipients, subject, text, fbml))).toString();
    }

    @Override
    @Deprecated
    public String notifications_sendEmail(Collection<Long> recipients, CharSequence subject, CharSequence fbml) throws FacebookException {
        return this.notifications_sendEmailStr(recipients, subject, fbml, null);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailPlain(Collection<Long> recipients, CharSequence subject, CharSequence text) throws FacebookException {
        return this.notifications_sendEmailStr(recipients, subject, null, text);
    }

    @Override
    public String admin_getAppPropertiesAsString(Collection<ApplicationProperty> properties) throws FacebookException {
        JSONArray props = new JSONArray();
        for (ApplicationProperty property : properties) {
            props.put((Object)property.getName());
        }
        String rawResponse = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_APP_PROPERTIES, Pairs.newPair("properties", props));
        log.debug((Object)("Facebook response: " + rawResponse));
        if ("json".equals(this.getResponseFormat())) {
            return JsonHelper.parseCallResult(rawResponse).toString();
        }
        return XmlHelper.extractString(XmlHelper.parseCallResult(rawResponse, this.factory));
    }

    @Override
    public List<String> executeBatch(boolean serial) throws FacebookException {
        int BATCH_LIMIT = 20;
        this.batchMode = false;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<BatchQuery> buffer = new ArrayList<BatchQuery>();
        while (!this.queries.isEmpty()) {
            buffer.add(this.queries.remove(0));
            if (buffer.size() != BATCH_LIMIT && !this.queries.isEmpty()) continue;
            String batchRawResponse = this.batch_run(this.encodeMethods(buffer), serial);
            result.add(batchRawResponse);
            if (buffer.size() == BATCH_LIMIT) {
                log.debug((Object)"Clearing buffer for the next run.");
                buffer.clear();
                continue;
            }
            log.trace((Object)"No need to clear buffer, this is the final iteration of the batch");
        }
        return result;
    }

    @Override
    public void fbml_deleteCustomTags(Collection<String> names) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.FBML_DELETE_CUSTOM_TAGS, Pairs.newPair("names", JsonHelper.toJsonListOfStrings(names))));
    }

    @Override
    public Object fbml_getCustomTags(String appId) throws FacebookException {
        if (StringUtils.isBlank((String)appId)) {
            return this.callMethod((IFacebookMethod)FacebookMethod.FBML_GET_CUSTOM_TAGS, new Pair[0]);
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.FBML_GET_CUSTOM_TAGS, Pairs.newPair("app_id", appId));
    }

    @Override
    public void fbml_registerCustomTags(Collection<JSONObject> tags) throws FacebookException {
        this.validateVoidResponse(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REGISTER_CUSTOM_TAGS, Pairs.newPair("tags", new JSONArray(tags))));
    }

    @Override
    public int intl_uploadNativeStrings(Map<String, String> native_strings) throws FacebookException {
        JSONArray array = new JSONArray();
        try {
            for (Map.Entry<String, String> entry : native_strings.entrySet()) {
                JSONObject obj = new JSONObject();
                obj.put("text", (Object)entry.getKey());
                obj.put("description", (Object)entry.getValue());
                array.put((Object)obj);
            }
        }
        catch (JSONException ex) {
            throw BasicClientHelper.runtimeException((Exception)((Object)ex));
        }
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.INTL_UPLOAD_NATIVE_STRINGS, Pairs.newPair("native_strings", array)));
    }
}

