/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.Pair;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pairs {
    protected static Log log = LogFactory.getLog(Pairs.class);

    protected static Pair<String, CharSequence> newPair(String name, Object value) {
        return new Pair<String, CharSequence>(name, String.valueOf(value));
    }

    @Deprecated
    protected static Pair<String, CharSequence> newPair(String name, boolean value) {
        return Pairs.newPair10(name, value);
    }

    protected static Pair<String, CharSequence> newPair10(String name, boolean value) {
        return Pairs.newPair(name, value ? "1" : "0");
    }

    protected static Pair<String, CharSequence> newPairTF(String name, boolean value) {
        return Pairs.newPair(name, value ? "true" : "false");
    }

    protected static Pair<String, CharSequence> newPair(String name, CharSequence value) {
        return new Pair<String, CharSequence>(name, value);
    }

    protected static Pair<String, CharSequence> newPair(String name, Long value) {
        return new Pair<String, CharSequence>(name, Long.toString(value));
    }

    protected static Pair<String, CharSequence> newPair(String name, Integer value) {
        return new Pair<String, CharSequence>(name, Integer.toString(value));
    }

    protected static boolean addParam(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        params.add(Pairs.newPair(name, value));
        return true;
    }

    protected static boolean addParamIfNotBlank(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        if (value != null) {
            return Pairs.addParam(name, value, params);
        }
        return false;
    }

    protected static boolean addParamSecondsIfNotBlank(String name, Date value, Collection<Pair<String, CharSequence>> params) {
        if (value != null) {
            return Pairs.addParam(name, value.getTime() / 1000L, params);
        }
        return false;
    }

    protected static boolean addParamIfNotBlankZero(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        if (value != null && value != 0L) {
            return Pairs.addParam(name, value, params);
        }
        return false;
    }

    protected static boolean addParamDelimitIfNotBlankEmpty(String name, Iterable<?> value, Collection<Pair<String, CharSequence>> params) {
        return Pairs.addParamIfNotBlank(name, BasicClientHelper.delimit(value), params);
    }

    protected static boolean addParam(String name, Object value, Collection<Pair<String, CharSequence>> params) {
        params.add(Pairs.newPair(name, value));
        return true;
    }

    protected static boolean addParam(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        params.add(Pairs.newPair(name, value));
        return true;
    }

    protected static boolean addParamIfNotBlank(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        if (value != null && !"".equals(value)) {
            params.add(Pairs.newPair(name, value));
            return true;
        }
        return false;
    }
}

