/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.ExtensibleClient;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.SpecificReturnTypeAdapter;
import com.google.code.facebookapi.XmlHelper;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacebookXmlRestClientBase
extends SpecificReturnTypeAdapter<Document> {
    protected static Log log = LogFactory.getLog(FacebookXmlRestClientBase.class);
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public boolean isNamespaceAware() {
        return this.factory.isNamespaceAware();
    }

    public void setNamespaceAware(boolean v) {
        this.factory.setNamespaceAware(v);
    }

    public FacebookXmlRestClientBase(ExtensibleClient client) {
        super("xml", client);
        this.factory.setNamespaceAware(true);
    }

    public FacebookXmlRestClientBase(String apiKey, String secret) {
        this(new ExtensibleClient("xml", apiKey, secret));
    }

    public FacebookXmlRestClientBase(String apiKey, String secret, String sessionKey) {
        this(new ExtensibleClient("xml", apiKey, secret, sessionKey));
    }

    Document parseCallResult(Object rawResponse) throws FacebookException {
        return XmlHelper.parseCallResult(rawResponse, this.factory);
    }

    public void printDom(Node n, String prefix) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("\n");
            XmlHelper.printDom(n, prefix, sb);
            log.debug((Object)sb.toString());
        }
    }

    @Override
    public List<Document> executeBatch(boolean serial) throws FacebookException {
        List<String> clientResults = this.client.executeBatch(serial);
        ArrayList<Document> result = new ArrayList<Document>();
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            for (String clientResult : clientResults) {
                Document doc = builder.parse(new InputSource(new StringReader(clientResult)));
                NodeList responses = doc.getElementsByTagName("batch_run_response_elt");
                for (int count = 0; count < responses.getLength(); ++count) {
                    Node responseNode = responses.item(count);
                    Document respDoc = builder.newDocument();
                    responseNode = respDoc.importNode(responseNode, true);
                    respDoc.appendChild(responseNode);
                    try {
                        respDoc = XmlHelper.parseCallResult(respDoc);
                        result.add(respDoc);
                        continue;
                    }
                    catch (FacebookException ignored) {
                        result.add(null);
                    }
                }
            }
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Error parsing batch response", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Error parsing batch response", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing batch response", ex);
        }
        return result;
    }
}

