/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.watcher.ShardProvider;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.annotation.Nullable;

public final class TimebasedShardProvider
implements ShardProvider {
    static final String PREVIOUS_SHARD_FUNCTION_FORMAT = "TO_BASE64(SHA512(FORMAT_TIMESTAMP('%s', TIMESTAMP_SUB(CURRENT_TIMESTAMP(), INTERVAL %d SECOND), 'UTC')))";
    static final String CURRENT_SHARD_FUNCTION_FORMAT = "TO_BASE64(SHA512(FORMAT_TIMESTAMP('%s', CURRENT_TIMESTAMP(), 'UTC')))";
    static final ZoneId UTC_ID = ZoneId.of("UTC");
    private final String column;
    private final String shardExpression;
    private final String previousShardExpression;
    private final String sqlAppendment;

    public static TimebasedShardProvider create(String column, Interval interval) {
        return new TimebasedShardProvider(column, interval);
    }

    TimebasedShardProvider(String column, Interval interval) {
        this(column, interval, interval.defaultPreviousShardSeconds);
    }

    TimebasedShardProvider(String column, Interval interval, int previousShardSeconds) {
        this.column = column;
        this.shardExpression = String.format(CURRENT_SHARD_FUNCTION_FORMAT, interval.cloudSpannerDateFormat);
        this.previousShardExpression = String.format(PREVIOUS_SHARD_FUNCTION_FORMAT, interval.cloudSpannerDateFormat, previousShardSeconds);
        this.sqlAppendment = String.format(" AND `%s` IN (%s, %s)", this.column, this.shardExpression, this.previousShardExpression);
    }

    @Override
    public void appendShardFilter(Statement.Builder statement) {
        statement.append(this.sqlAppendment);
    }

    @Override
    @Nullable
    public Value getShardValue() {
        return null;
    }

    public static final class TimebasedShardId {
        private final Value value;
        private final Interval interval;
        private final LocalDateTime fetchTime;

        private TimebasedShardId(Value value, Interval interval, LocalDateTime fetchTime) {
            this.value = value;
            this.interval = interval;
            this.fetchTime = fetchTime;
        }

        public boolean shouldRefresh() {
            return !this.fetchTime.format(this.interval.refreshIntervalDateFormat).equals(LocalDateTime.now(UTC_ID).format(this.interval.refreshIntervalDateFormat));
        }

        public Value getValue() {
            return this.value;
        }
    }

    public static enum Interval {
        DAY("%F", false),
        WEEK("%Y-%W", false),
        MONTH("%yyyy-%m", false),
        YEAR("%Y", false),
        MINUTE_OF_HOUR("%M", "mm", true, 45),
        HOUR_OF_DAY("%H", "HH", true),
        DAY_OF_WEEK("%u", true),
        DAY_OF_MONTH("%d", true),
        WEEK_OF_YEAR("%W", true),
        DAY_OF_YEAR("%j", true);

        private final String cloudSpannerDateFormat;
        private final DateTimeFormatter refreshIntervalDateFormat;
        private final boolean cyclic;
        private final String shardIdExpression;
        private final Statement currentShardIdStatement;
        private int defaultPreviousShardSeconds;

        private Interval(String cloudSpannerDateFormat, boolean cyclic) {
            this(cloudSpannerDateFormat, "yyyy-MM-dd", cyclic, 60);
        }

        private Interval(String cloudSpannerDateFormat, String localDateFormat, boolean cyclic) {
            this(cloudSpannerDateFormat, localDateFormat, cyclic, 60);
        }

        private Interval(String cloudSpannerDateFormat, String javaDateFormat, boolean cyclic, int defaultPreviousShardSeconds) {
            this.cloudSpannerDateFormat = cloudSpannerDateFormat;
            this.refreshIntervalDateFormat = DateTimeFormatter.ofPattern(javaDateFormat, Locale.US);
            this.cyclic = cyclic;
            this.shardIdExpression = String.format(TimebasedShardProvider.CURRENT_SHARD_FUNCTION_FORMAT, cloudSpannerDateFormat);
            this.currentShardIdStatement = Statement.of((String)("SELECT " + this.shardIdExpression));
            this.defaultPreviousShardSeconds = defaultPreviousShardSeconds;
        }

        public TimebasedShardId getCurrentShardId(ReadContext readContext) {
            LocalDateTime fetchTime = LocalDateTime.now(UTC_ID);
            Throwable throwable = null;
            try (ResultSet rs = readContext.executeQuery(this.currentShardIdStatement, new Options.QueryOption[0]);){
                if (rs.next()) {
                    TimebasedShardId timebasedShardId = new TimebasedShardId(Value.string((String)rs.getString(0)), this, fetchTime);
                    return timebasedShardId;
                }
                try {
                    throw new IllegalStateException("Shard expression did not return any results");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        public String getShardIdExpression() {
            return this.shardIdExpression;
        }

        String getDateFormat() {
            return this.cloudSpannerDateFormat;
        }

        public boolean isCyclic() {
            return this.cyclic;
        }
    }
}

