/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiService;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.watcher.CommitTimestampRepository;
import com.google.cloud.spanner.watcher.RowImpl;
import com.google.cloud.spanner.watcher.ShardProvider;
import com.google.cloud.spanner.watcher.SpannerTableChangeWatcher;
import com.google.cloud.spanner.watcher.SpannerTableTailer;
import com.google.cloud.spanner.watcher.TableId;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class SpannerTableChangeSetPoller
extends AbstractApiService
implements SpannerTableChangeWatcher {
    static final Logger logger = Logger.getLogger(SpannerTableChangeSetPoller.class.getName());
    static final String POLL_QUERY = "SELECT *\nFROM %s\nWHERE `%s`=@changeSet";
    static final String DEFAULT_CHANGE_SET_TABLE_NAME = "CHANGE_SETS";
    static final String DEFAULT_CHANGE_SET_ID_COLUMN = "CHANGE_SET_ID";
    static final String DEFAULT_CHANGE_SET_COMMIT_TS_COLUMN = "COMMIT_TIMESTAMP";
    private final SpannerTableChangeWatcher changeSetWatcher;
    private final TableId table;
    private final String dataTableChangeSetIdColumn;
    private final String changeSetTableIdColumn;
    private final List<SpannerTableChangeWatcher.RowChangeCallback> callbacks = new LinkedList<SpannerTableChangeWatcher.RowChangeCallback>();
    private final DatabaseClient client;

    public static Builder newBuilder(Spanner spanner, TableId table) {
        return new Builder(spanner, TableId.of(table.getDatabaseId(), DEFAULT_CHANGE_SET_TABLE_NAME), table);
    }

    public static Builder newBuilder(Spanner spanner, TableId changeSetTable, TableId table) {
        return new Builder(spanner, changeSetTable, table);
    }

    private SpannerTableChangeSetPoller(Builder builder) {
        this.changeSetWatcher = builder.tailerBuilder.build();
        this.table = builder.table;
        this.dataTableChangeSetIdColumn = builder.dataTableChangeSetIdColumn;
        this.changeSetTableIdColumn = builder.changeSetTableIdColumn;
        this.client = builder.spanner.getDatabaseClient(builder.table.getDatabaseId());
    }

    @Override
    public TableId getTable() {
        return this.changeSetWatcher.getTable();
    }

    @Override
    public void addCallback(SpannerTableChangeWatcher.RowChangeCallback callback) {
        Preconditions.checkState((this.state() == ApiService.State.NEW ? 1 : 0) != 0);
        this.callbacks.add(callback);
    }

    protected void doStart() {
        this.changeSetWatcher.addCallback(new SpannerTableChangeWatcher.RowChangeCallback(){

            @Override
            public void rowChange(TableId table, SpannerTableChangeWatcher.Row row, Timestamp commitTimestamp) {
                SpannerTableChangeSetPoller.this.pollTableForChanges(row.getString(SpannerTableChangeSetPoller.this.changeSetTableIdColumn), commitTimestamp);
            }
        });
        this.changeSetWatcher.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                SpannerTableChangeSetPoller.this.notifyFailed(failure);
            }

            public void running() {
                SpannerTableChangeSetPoller.this.notifyStarted();
            }

            public void terminated(ApiService.State from) {
                SpannerTableChangeSetPoller.this.notifyStopped();
            }
        }, MoreExecutors.directExecutor());
        this.changeSetWatcher.startAsync();
    }

    void pollTableForChanges(String changeSet, Timestamp commitTimestamp) {
        Statement.Builder statementBuilder = Statement.newBuilder((String)String.format(POLL_QUERY, this.table.getSqlIdentifier(), this.dataTableChangeSetIdColumn));
        try (ResultSet rs = this.client.singleUse().executeQuery(((Statement.Builder)statementBuilder.bind("changeSet").to(changeSet)).build(), new Options.QueryOption[0]);){
            while (rs.next()) {
                for (SpannerTableChangeWatcher.RowChangeCallback callback : this.callbacks) {
                    callback.rowChange(this.table, new RowImpl(rs), commitTimestamp);
                }
            }
        }
    }

    protected void doStop() {
        this.changeSetWatcher.stopAsync();
    }

    public static class Builder {
        private final SpannerTableTailer.Builder tailerBuilder;
        private final Spanner spanner;
        private final TableId table;
        private String dataTableChangeSetIdColumn = "CHANGE_SET_ID";
        private String changeSetTableIdColumn = "CHANGE_SET_ID";

        Builder(Spanner spanner, TableId changeSetsTable, final TableId table) {
            this.tailerBuilder = SpannerTableTailer.newBuilder(spanner, changeSetsTable).setShardProvider(new ShardProvider(){

                @Override
                public Value getShardValue() {
                    return Value.string((String)table.getFullName());
                }

                @Override
                public void appendShardFilter(Statement.Builder statementBuilder) {
                }
            });
            this.spanner = spanner;
            this.table = table;
        }

        public Builder setDataTableChangeSetIdColumn(String column) {
            this.dataTableChangeSetIdColumn = (String)Preconditions.checkNotNull((Object)column);
            return this;
        }

        public Builder setChangeSetTableIdColumn(String column) {
            this.changeSetTableIdColumn = (String)Preconditions.checkNotNull((Object)column);
            return this;
        }

        public Builder setCommitTimestampRepository(CommitTimestampRepository repository) {
            this.tailerBuilder.setCommitTimestampRepository(repository);
            return this;
        }

        public Builder setPollInterval(Duration interval) {
            this.tailerBuilder.setPollInterval(interval);
            return this;
        }

        public Builder setExecutor(ScheduledExecutorService executor) {
            this.tailerBuilder.setExecutor(executor);
            return this;
        }

        public SpannerTableChangeSetPoller build() {
            return new SpannerTableChangeSetPoller(this);
        }
    }
}

