/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;

public class SpannerEmulatorUtil {
    public static void maybeCreateInstanceAndDatabase(Spanner spanner, DatabaseId databaseId) {
        SpannerException spannerException;
        Preconditions.checkArgument((boolean)NoCredentials.getInstance().equals((Object)((SpannerOptions)spanner.getOptions()).getCredentials()));
        try {
            spanner.getInstanceAdminClient().createInstance(InstanceInfo.newBuilder((InstanceId)databaseId.getInstanceId()).setDisplayName("Automatically Generated Test Instance").setNodeCount(1).setInstanceConfigId(InstanceConfigId.of((String)databaseId.getInstanceId().getProject(), (String)"emulator-config")).build()).get();
        }
        catch (ExecutionException executionException) {
            spannerException = (SpannerException)executionException.getCause();
            if (spannerException.getErrorCode() != ErrorCode.ALREADY_EXISTS) {
                throw spannerException;
            }
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
        try {
            spanner.getDatabaseAdminClient().createDatabase(databaseId.getInstanceId().getInstance(), databaseId.getDatabase(), (Iterable)ImmutableList.of()).get();
        }
        catch (ExecutionException executionException) {
            spannerException = (SpannerException)executionException.getCause();
            if (spannerException.getErrorCode() != ErrorCode.ALREADY_EXISTS) {
                throw spannerException;
            }
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
    }
}

