/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.watcher.ShardProvider;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public class FixedShardProvider
implements ShardProvider {
    private final String column;
    private final String parameterName;
    private final Value value;
    private final String sqlAppendment;

    public static FixedShardProvider create(String column, boolean value) {
        return new FixedShardProvider(column, Value.bool((boolean)value));
    }

    public static FixedShardProvider create(String column, ByteArray value) {
        return new FixedShardProvider(column, Value.bytes((ByteArray)value));
    }

    public static FixedShardProvider create(String column, Date value) {
        return new FixedShardProvider(column, Value.date((Date)value));
    }

    public static FixedShardProvider create(String column, double value) {
        return new FixedShardProvider(column, Value.float64((double)value));
    }

    public static FixedShardProvider create(String column, long value) {
        return new FixedShardProvider(column, Value.int64((long)value));
    }

    public static FixedShardProvider create(String column, BigDecimal value) {
        return new FixedShardProvider(column, Value.numeric((BigDecimal)value));
    }

    public static FixedShardProvider create(String column, String value) {
        return new FixedShardProvider(column, Value.string((String)value));
    }

    public static FixedShardProvider create(String column, Timestamp value) {
        return new FixedShardProvider(column, Value.timestamp((Timestamp)value));
    }

    public static FixedShardProvider create(String column, Value value) {
        return new FixedShardProvider(column, value);
    }

    FixedShardProvider(String column, Value value) {
        this(column, value, "shard");
    }

    FixedShardProvider(String column, Value value, String parameterName) {
        this.column = (String)Preconditions.checkNotNull((Object)column);
        this.parameterName = (String)Preconditions.checkNotNull((Object)parameterName);
        this.value = (Value)Preconditions.checkNotNull((Object)value);
        this.sqlAppendment = value.getType().getCode() == Type.Code.ARRAY ? String.format(" AND `%s` IS NOT NULL AND `%s` IN UNNEST(@%s)", column, column, parameterName) : String.format(" AND `%s`=@%s", column, parameterName);
    }

    @Override
    public void appendShardFilter(Statement.Builder statementBuilder) {
        statementBuilder.append(this.sqlAppendment);
        statementBuilder.bind(this.parameterName).to(this.value);
    }

    @Override
    public Value getShardValue() {
        return this.value;
    }

    @Override
    public String getColumnName() {
        return this.column;
    }
}

