/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.watcher.it;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SpannerTestHelper {
    private static final Logger logger = Logger.getLogger(SpannerTestHelper.class.getName());
    private static final String INSTANCE_ID_FORMAT = "scw-test-instance-%08d-%s";
    private static final String DATABASE_ID_FORMAT = "scw-test-db-%08d";
    private static final Random RND = new Random();
    private static final String SPANNER_PROJECT_ID = System.getProperty("spanner.project", ServiceOptions.getDefaultProjectId());
    private static final String SPANNER_CREDENTIALS_FILE = System.getProperty("spanner.credentials");

    public static void setupSpanner(ITSpannerEnv env) throws Exception {
        env.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(SpannerTestHelper.SPANNER_PROJECT_ID)).setCredentials(SpannerTestHelper.getSpannerCredentials())).build().getService();
        if (env.instanceId == null) {
            env.isOwnedInstance = true;
            env.instanceId = String.format(INSTANCE_ID_FORMAT, SpannerTestHelper.RND.nextInt(100000000), Timestamp.ofTimeSecondsAndNanos((long)TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS), (int)0).toString().replace(":", "-").toLowerCase());
        }
        if (env.isOwnedInstance) {
            InstanceConfig instanceConfig;
            logger.log(Level.INFO, "Using owned test instance");
            logger.log(Level.INFO, "Getting nearest instance config");
            try {
                instanceConfig = (InstanceConfig)env.spanner.getInstanceAdminClient().listInstanceConfigs(new Options.ListOption[0]).getValues().iterator().next();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Getting nearest instance config failed. Using default config.");
                instanceConfig = new InstanceConfig(InstanceConfigId.of((String)SPANNER_PROJECT_ID, (String)"us-east1"), "Default config", env.spanner.getInstanceAdminClient());
            }
            try {
                logger.log(Level.INFO, "Creating test instance " + env.instanceId);
                env.instance = (Instance)env.spanner.getInstanceAdminClient().createInstance(InstanceInfo.newBuilder((InstanceId)InstanceId.of((String)SpannerTestHelper.SPANNER_PROJECT_ID, (String)env.instanceId)).setDisplayName("Test Instance").setNodeCount(1).setInstanceConfigId(instanceConfig.getId()).build()).get();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Creating test instance failed. Using first available instance.", e);
                env.instance = (Instance)env.spanner.getInstanceAdminClient().listInstances(new Options.ListOption[0]).iterateAll().iterator().next();
                env.instanceId = env.instance.getId().getInstance();
                env.isOwnedInstance = false;
            }
        }
    }

    public static void teardownSpanner(ITSpannerEnv env) {
        if (env.isOwnedInstance) {
            logger.log(Level.INFO, "Checking for old test instances that should be deleted.");
            SpannerTestHelper.deleteOldTestInstances(env);
            logger.log(Level.INFO, "Deleting test instance " + env.instance.getId().getName());
            env.instance.delete();
        } else {
            for (Database db : env.databases) {
                db.drop();
            }
        }
        env.spanner.close();
    }

    private static void deleteOldTestInstances(ITSpannerEnv env) {
        for (Instance instance : env.spanner.getInstanceAdminClient().listInstances(new Options.ListOption[0]).iterateAll()) {
            logger.log(Level.INFO, "Found instance " + instance.getId().getName());
            if (!instance.getId().getInstance().matches("scw-test-instance-\\d{8}-\\d{4}-\\d{2}-\\d{2}T\\d{2}-\\d{2}-\\d{2}Z")) continue;
            logger.log(Level.INFO, "Found test instance " + instance.getId().getName());
            String ts = instance.getId().getInstance().substring(27);
            ts = ts.substring(0, 10) + ts.substring(10).replaceAll("-", ":");
            Timestamp created = Timestamp.parseTimestamp((String)ts.toUpperCase());
            logger.log(Level.INFO, "Created at " + created.toString());
            long ageInSeconds = TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS) - created.getSeconds();
            logger.log(Level.INFO, "Instance age in seconds: " + ageInSeconds);
            logger.log(Level.INFO, "Instance age in hours:" + TimeUnit.HOURS.convert(ageInSeconds, TimeUnit.SECONDS));
            if (TimeUnit.HOURS.convert(ageInSeconds, TimeUnit.SECONDS) <= 24L) continue;
            logger.log(Level.WARNING, String.format("Deleting test instance %s as it is more than 24 hours old.", new Object[0]));
        }
    }

    public static String getSpannerProjectId() {
        return SPANNER_PROJECT_ID;
    }

    public static Credentials getSpannerCredentials() throws IOException {
        if (SPANNER_CREDENTIALS_FILE != null) {
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(SPANNER_CREDENTIALS_FILE));
        }
        return GoogleCredentials.getApplicationDefault();
    }

    public static class ITSpannerEnv {
        private Instance instance;
        private String instanceId = System.getProperty("spanner.instance");
        private boolean isOwnedInstance;
        private Spanner spanner;
        private final List<Database> databases = new ArrayList<Database>();

        public Spanner getSpanner() {
            return this.spanner;
        }

        public Database createTestDb(Iterable<String> statements) throws SpannerException, InterruptedException, ExecutionException {
            String id = String.format(SpannerTestHelper.DATABASE_ID_FORMAT, RND.nextInt(100000000));
            Database database = (Database)this.spanner.getDatabaseAdminClient().createDatabase(this.instanceId, id, statements).get();
            this.databases.add(database);
            return database;
        }
    }
}

