/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ReproducibleLayerBuilder {
    private final ImmutableList<FileEntry> layerEntries;

    private static void clearTimeHeaders(TarArchiveEntry entry, Instant modTime) {
        entry.setModTime(modTime.toEpochMilli());
        String headerTime = Long.toString(modTime.getEpochSecond());
        long nanos = modTime.getNano();
        if (nanos > 0L) {
            headerTime = headerTime + "." + nanos;
        }
        entry.addPaxHeader("mtime", headerTime);
        entry.addPaxHeader("atime", headerTime);
        entry.addPaxHeader("ctime", headerTime);
        entry.addPaxHeader("LIBARCHIVE.creationtime", headerTime);
    }

    private static void setUserAndGroup(TarArchiveEntry entry, FileEntry layerEntry) {
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("");
        entry.setGroupName("");
        if (!layerEntry.getOwnership().isEmpty()) {
            String user = layerEntry.getOwnership();
            String group = "";
            int colonIndex = user.indexOf(58);
            if (colonIndex != -1) {
                group = user.substring(colonIndex + 1);
                user = user.substring(0, colonIndex);
            }
            if (!user.isEmpty()) {
                try {
                    entry.setUserId(Long.parseLong(user));
                }
                catch (NumberFormatException ignored) {
                    entry.setUserName(user);
                }
            }
            if (!group.isEmpty()) {
                try {
                    entry.setGroupId(Long.parseLong(group));
                }
                catch (NumberFormatException ignored) {
                    entry.setGroupName(group);
                }
            }
        }
    }

    public ReproducibleLayerBuilder(ImmutableList<FileEntry> layerEntries) {
        this.layerEntries = layerEntries;
    }

    public Blob build() throws IOException {
        UniqueTarArchiveEntries uniqueTarArchiveEntries = new UniqueTarArchiveEntries();
        for (FileEntry layerEntry : this.layerEntries) {
            TarArchiveEntry entry = new TarArchiveEntry(layerEntry.getSourceFile(), layerEntry.getExtractionPath().toString(), new LinkOption[0]);
            entry.setMode(entry.getMode() & 0xFFFFFE00 | layerEntry.getPermissions().getPermissionBits());
            ReproducibleLayerBuilder.setUserAndGroup(entry, layerEntry);
            ReproducibleLayerBuilder.clearTimeHeaders(entry, layerEntry.getModificationTime());
            uniqueTarArchiveEntries.add(entry);
        }
        List sortedFilesystemEntries = uniqueTarArchiveEntries.getSortedEntries();
        HashSet<String> names = new HashSet<String>();
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        for (TarArchiveEntry entry : sortedFilesystemEntries) {
            Verify.verify((!names.contains(entry.getName()) ? 1 : 0) != 0);
            names.add(entry.getName());
            tarStreamBuilder.addTarArchiveEntry(entry);
        }
        return Blobs.from(tarStreamBuilder::writeAsTarArchiveTo, false);
    }

    private static class UniqueTarArchiveEntries {
        private static final Path DIRECTORY_FILE = Paths.get(".", new String[0]);
        private final List<TarArchiveEntry> entries = new ArrayList<TarArchiveEntry>();
        private final Set<String> names = new HashSet<String>();

        private UniqueTarArchiveEntries() {
        }

        private void add(TarArchiveEntry tarArchiveEntry) throws IOException {
            if (this.names.contains(tarArchiveEntry.getName())) {
                return;
            }
            Path namePath = Paths.get(tarArchiveEntry.getName(), new String[0]);
            if (namePath.getParent() != namePath.getRoot()) {
                Path tarArchiveParentDir = (Path)Verify.verifyNotNull((Object)namePath.getParent());
                TarArchiveEntry dir = new TarArchiveEntry(DIRECTORY_FILE, tarArchiveParentDir.toString(), new LinkOption[0]);
                dir.setUserId(0);
                dir.setGroupId(0);
                dir.setUserName("");
                dir.setGroupName("");
                ReproducibleLayerBuilder.clearTimeHeaders(dir, FileEntriesLayer.DEFAULT_MODIFICATION_TIME);
                this.add(dir);
            }
            this.entries.add(tarArchiveEntry);
            this.names.add(tarArchiveEntry.getName());
        }

        private List<TarArchiveEntry> getSortedEntries() {
            ArrayList<TarArchiveEntry> sortedEntries = new ArrayList<TarArchiveEntry>(this.entries);
            sortedEntries.sort(Comparator.comparing(TarArchiveEntry::getName));
            return sortedEntries;
        }
    }
}

