/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.hash.Digests;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

class StringBlob
implements Blob {
    private final String content;

    StringBlob(String content) {
        this.content = content;
    }

    @Override
    public BlobDescriptor writeTo(OutputStream outputStream) throws IOException {
        try (ByteArrayInputStream stringIn = new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));){
            BlobDescriptor blobDescriptor = Digests.computeDigest(stringIn, outputStream);
            return blobDescriptor;
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

