/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.http.ResponseException;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.OciIndexTemplate;
import com.google.cloud.tools.jib.image.json.OciManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestListTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

abstract class AbstractManifestPuller<T extends ManifestTemplate, R>
implements RegistryEndpointProvider<R> {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final String imageQualifier;
    private final Class<T> manifestTemplateClass;

    AbstractManifestPuller(RegistryEndpointRequestProperties registryEndpointRequestProperties, String imageQualifier, Class<T> manifestTemplateClass) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.imageQualifier = imageQualifier;
        this.manifestTemplateClass = manifestTemplateClass;
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        if (this.manifestTemplateClass.equals(V21ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v1+json");
        }
        if (this.manifestTemplateClass.equals(V22ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v2+json");
        }
        if (this.manifestTemplateClass.equals(OciManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.oci.image.manifest.v1+json");
        }
        if (this.manifestTemplateClass.equals(V22ManifestListTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.list.v2+json");
        }
        return Arrays.asList("application/vnd.oci.image.manifest.v1+json", "application/vnd.docker.distribution.manifest.v2+json", "application/vnd.docker.distribution.manifest.v1+json", "application/vnd.docker.distribution.manifest.list.v2+json");
    }

    @Override
    public R handleResponse(Response response) throws IOException, UnknownManifestFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DescriptorDigest digest = Digests.computeDigest(response.getBody(), (OutputStream)byteArrayOutputStream).getDigest();
        String jsonString = byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
        T manifestTemplate = this.getManifestTemplateFromJson(jsonString);
        return this.computeReturn(new ManifestAndDigest<T>(manifestTemplate, digest));
    }

    abstract R computeReturn(ManifestAndDigest<T> var1);

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointRequestProperties.getImageName() + "/manifests/" + this.imageQualifier);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "pull image manifest for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + ":" + this.imageQualifier;
    }

    private T getManifestTemplateFromJson(String jsonString) throws IOException, UnknownManifestFormatException {
        ObjectNode node = (ObjectNode)new ObjectMapper().readValue(jsonString, ObjectNode.class);
        if (!node.has("schemaVersion")) {
            throw new UnknownManifestFormatException("Cannot find field 'schemaVersion' in manifest");
        }
        int schemaVersion = node.get("schemaVersion").asInt(-1);
        if (schemaVersion == -1) {
            throw new UnknownManifestFormatException("'schemaVersion' field is not an integer");
        }
        if (schemaVersion == 1) {
            return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, V21ManifestTemplate.class)));
        }
        if (schemaVersion == 2) {
            JsonNode mediaTypeNode = node.get("mediaType");
            if (mediaTypeNode == null) {
                if (node.get("manifests") != null) {
                    return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, OciIndexTemplate.class)));
                }
                if (node.get("config") != null) {
                    return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, OciManifestTemplate.class)));
                }
                throw new UnknownManifestFormatException("'schemaVersion' is 2, but neither 'manifests' nor 'config' exists");
            }
            String mediaType = mediaTypeNode.asText();
            if ("application/vnd.oci.image.manifest.v1+json".equals(mediaType)) {
                return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, OciManifestTemplate.class)));
            }
            if ("application/vnd.docker.distribution.manifest.v2+json".equals(mediaType)) {
                return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, V22ManifestTemplate.class)));
            }
            if ("application/vnd.docker.distribution.manifest.list.v2+json".equals(mediaType)) {
                return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, V22ManifestListTemplate.class)));
            }
            throw new UnknownManifestFormatException("Unknown mediaType: " + mediaType);
        }
        throw new UnknownManifestFormatException("Unknown schemaVersion: " + schemaVersion + " - only 1 and 2 are supported");
    }

    @Override
    public R handleHttpResponseException(ResponseException responseException) throws ResponseException, RegistryErrorException {
        throw responseException;
    }
}

