/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import java.nio.file.Paths;

public class Jib {
    public static final String REGISTRY_IMAGE_PREFIX = "registry://";
    public static final String DOCKER_DAEMON_IMAGE_PREFIX = "docker://";
    public static final String TAR_IMAGE_PREFIX = "tar://";

    public static JibContainerBuilder from(String baseImageReference) throws InvalidImageReferenceException {
        if (baseImageReference.startsWith(DOCKER_DAEMON_IMAGE_PREFIX)) {
            return Jib.from(DockerDaemonImage.named(baseImageReference.replaceFirst(DOCKER_DAEMON_IMAGE_PREFIX, "")));
        }
        if (baseImageReference.startsWith(TAR_IMAGE_PREFIX)) {
            return Jib.from(TarImage.at(Paths.get(baseImageReference.replaceFirst(TAR_IMAGE_PREFIX, ""), new String[0])));
        }
        return Jib.from(RegistryImage.named(baseImageReference.replaceFirst(REGISTRY_IMAGE_PREFIX, "")));
    }

    public static JibContainerBuilder from(ImageReference baseImageReference) {
        return Jib.from(RegistryImage.named(baseImageReference));
    }

    public static JibContainerBuilder from(RegistryImage registryImage) {
        return new JibContainerBuilder(registryImage);
    }

    public static JibContainerBuilder from(DockerDaemonImage dockerDaemonImage) {
        return new JibContainerBuilder(dockerDaemonImage);
    }

    public static JibContainerBuilder from(TarImage tarImage) {
        return new JibContainerBuilder(tarImage);
    }

    public static JibContainerBuilder fromScratch() {
        return Jib.from(ImageReference.scratch());
    }

    private Jib() {
    }
}

