/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RegistryAliasGroup {
    private static final ImmutableList<ImmutableSet<String>> REGISTRY_ALIAS_GROUPS = ImmutableList.of((Object)ImmutableSet.of((Object)"registry.hub.docker.com", (Object)"index.docker.io", (Object)"registry-1.docker.io", (Object)"docker.io"));
    private static final ImmutableMap<String, String> REGISTRY_HOST_MAP = ImmutableMap.of((Object)"docker.io", (Object)"registry-1.docker.io");

    public static List<String> getAliasesGroup(String registry) {
        for (ImmutableSet aliasGroup : REGISTRY_ALIAS_GROUPS) {
            if (!aliasGroup.contains((Object)registry)) continue;
            Stream<String> self = Stream.of(registry);
            Stream<String> withoutSelf = aliasGroup.stream().filter(alias -> !registry.equals(alias));
            return Stream.concat(self, withoutSelf).collect(Collectors.toList());
        }
        return Collections.singletonList(registry);
    }

    public static String getHost(String registry) {
        return (String)REGISTRY_HOST_MAP.getOrDefault((Object)registry, (Object)registry);
    }
}

