/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.globalconfig;

import com.google.cloud.tools.jib.filesystem.XdgDirectories;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.plugins.common.globalconfig.GlobalConfigTemplate;
import com.google.cloud.tools.jib.plugins.common.globalconfig.InvalidGlobalConfigException;
import com.google.cloud.tools.jib.plugins.common.globalconfig.RegistryMirrorsTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class GlobalConfig {
    private static final String CONFIG_FILENAME = "config.json";
    private final boolean disableUpdateCheck;
    private final ImmutableListMultimap<String, String> registryMirrors;

    public static GlobalConfig readConfig() throws IOException, InvalidGlobalConfigException {
        return GlobalConfig.readConfig(GlobalConfig.getConfigDir());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static GlobalConfig readConfig(Path configDir) throws IOException, InvalidGlobalConfigException {
        Path configFile = configDir.resolve(CONFIG_FILENAME);
        try {
            if (Files.exists(configFile, new LinkOption[0])) {
                GlobalConfigTemplate configJson = JsonTemplateMapper.readJsonFromFile(configFile, GlobalConfigTemplate.class);
                return GlobalConfig.from(configJson);
            }
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path tempConfigFile = Files.createTempFile(configDir, CONFIG_FILENAME, null, new FileAttribute[0]);
            tempConfigFile.toFile().deleteOnExit();
            GlobalConfigTemplate configJson = new GlobalConfigTemplate();
            try (OutputStream outputStream = Files.newOutputStream(tempConfigFile, new OpenOption[0]);){
                JsonTemplateMapper.writeTo(configJson, outputStream);
                Files.move(tempConfigFile, configFile, new CopyOption[0]);
                GlobalConfig globalConfig = GlobalConfig.from(configJson);
                return globalConfig;
            }
            catch (FileAlreadyExistsException ex) {
                return GlobalConfig.readConfig(configDir);
            }
        }
        catch (InvalidGlobalConfigException ex) {
            throw new InvalidGlobalConfigException(ex.getMessage() + "; see https://github.com/GoogleContainerTools/jib/blob/global-config-doc/docs/faq.md#where-is-the-global-jib-configuration-file-and-how-i-can-configure-it to fix or you may need to delete " + configFile);
        }
        catch (IOException ex) {
            throw new IOException("Failed to open or parse global Jib config file; see https://github.com/GoogleContainerTools/jib/blob/global-config-doc/docs/faq.md#where-is-the-global-jib-configuration-file-and-how-i-can-configure-it to fix or you may need to delete " + configFile, ex);
        }
    }

    private static GlobalConfig from(GlobalConfigTemplate configJson) throws InvalidGlobalConfigException {
        ImmutableListMultimap.Builder registryMirrors = ImmutableListMultimap.builder();
        for (RegistryMirrorsTemplate mirrorConfig : configJson.getRegistryMirrors()) {
            if (Strings.isNullOrEmpty((String)mirrorConfig.getRegistry())) {
                throw new InvalidGlobalConfigException("'registryMirrors.registry' property is missing");
            }
            if (mirrorConfig.getMirrors().isEmpty()) {
                throw new InvalidGlobalConfigException("'registryMirrors.mirrors' property is missing");
            }
            registryMirrors.putAll((Object)mirrorConfig.getRegistry(), mirrorConfig.getMirrors());
        }
        return new GlobalConfig(configJson.isDisableUpdateCheck(), (ImmutableListMultimap<String, String>)registryMirrors.build());
    }

    public static Path getConfigDir() {
        String configDirProperty = System.getProperty("jib.configDirectory");
        if (!Strings.isNullOrEmpty((String)configDirProperty)) {
            return Paths.get(configDirProperty, new String[0]);
        }
        return XdgDirectories.getConfigHome();
    }

    private GlobalConfig(boolean disableUpdateCheck, ImmutableListMultimap<String, String> registryMirrors) {
        this.disableUpdateCheck = disableUpdateCheck;
        this.registryMirrors = registryMirrors;
    }

    public boolean isDisableUpdateCheck() {
        return Boolean.getBoolean("jib.disableUpdateChecks") || this.disableUpdateCheck;
    }

    public ListMultimap<String, String> getRegistryMirrors() {
        return this.registryMirrors;
    }
}

