/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.events.TimerEvent;
import com.google.cloud.tools.jib.event.progress.ProgressEventHandler;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.maven.MavenExtensionData;
import com.google.cloud.tools.jib.maven.extension.JibMavenPluginExtension;
import com.google.cloud.tools.jib.maven.extension.MavenData;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.JavaContainerBuilderHelper;
import com.google.cloud.tools.jib.plugins.common.PluginExtensionLogger;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import com.google.cloud.tools.jib.plugins.common.TimerEventHandler;
import com.google.cloud.tools.jib.plugins.common.ZipUtil;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLoggerBuilder;
import com.google.cloud.tools.jib.plugins.common.logging.ProgressDisplayGenerator;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import com.google.cloud.tools.jib.plugins.extension.NullExtension;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.Os;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectProperties
implements ProjectProperties {
    public static final String PLUGIN_NAME = "jib-maven-plugin";
    public static final String PLUGIN_KEY = "com.google.cloud.tools:jib-maven-plugin";
    private static final String TOOL_NAME = "jib-maven-plugin";
    private static final String JAR_PLUGIN_NAME = "'maven-jar-plugin'";
    private static final Duration LOGGING_THREAD_SHUTDOWN_TIMEOUT = Duration.ofSeconds(1L);
    private final PluginDescriptor jibPluginDescriptor;
    private final MavenProject project;
    private final MavenSession session;
    private final SingleThreadedExecutor singleThreadedExecutor = new SingleThreadedExecutor();
    private final ConsoleLogger consoleLogger;
    private final TempDirectoryProvider tempDirectoryProvider;
    private final Supplier<List<JibMavenPluginExtension<?>>> extensionLoader;

    public static MavenProjectProperties getForProject(PluginDescriptor jibPluginDescriptor, MavenProject project, MavenSession session, Log log, TempDirectoryProvider tempDirectoryProvider) {
        Preconditions.checkNotNull((Object)jibPluginDescriptor);
        Supplier<List<JibMavenPluginExtension<?>>> extensionLoader = () -> {
            ArrayList<JibMavenPluginExtension> extensions = new ArrayList<JibMavenPluginExtension>();
            for (JibMavenPluginExtension extension : ServiceLoader.load(JibMavenPluginExtension.class)) {
                extensions.add(extension);
            }
            return extensions;
        };
        return new MavenProjectProperties(jibPluginDescriptor, project, session, log, tempDirectoryProvider, extensionLoader);
    }

    @Nullable
    public static String getProperty(String propertyName, @Nullable MavenProject project, @Nullable MavenSession session) {
        if (session != null && session.getSystemProperties().containsKey(propertyName)) {
            return session.getSystemProperties().getProperty(propertyName);
        }
        if (project != null && project.getProperties().containsKey(propertyName)) {
            return project.getProperties().getProperty(propertyName);
        }
        return null;
    }

    @VisibleForTesting
    static boolean isProgressFooterEnabled(MavenSession session) {
        if (!session.getRequest().isInteractiveMode()) {
            return false;
        }
        if ("plain".equals(System.getProperty("jib.console"))) {
            return false;
        }
        if (Os.isFamily((String)"windows")) {
            return true;
        }
        return System.console() != null && !"dumb".equals(System.getenv("TERM"));
    }

    @VisibleForTesting
    static int getVersionFromString(String versionString) {
        if (versionString.startsWith("1.")) {
            if (versionString.length() >= 3 && Character.isDigit(versionString.charAt(2))) {
                return versionString.charAt(2) - 48;
            }
            return 0;
        }
        int dotIndex = versionString.indexOf(".");
        try {
            if (dotIndex == -1) {
                return Integer.parseInt(versionString);
            }
            return Integer.parseInt(versionString.substring(0, versionString.indexOf(".")));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    @VisibleForTesting
    static Optional<String> getChildValue(@Nullable Xpp3Dom dom, String ... childNodePath) {
        if (dom == null) {
            return Optional.empty();
        }
        Xpp3Dom node = dom;
        for (String child : childNodePath) {
            if ((node = node.getChild(child)) != null) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(node.getValue());
    }

    @VisibleForTesting
    MavenProjectProperties(PluginDescriptor jibPluginDescriptor, MavenProject project, MavenSession session, Log log, TempDirectoryProvider tempDirectoryProvider, Supplier<List<JibMavenPluginExtension<?>>> extensionLoader) {
        this.jibPluginDescriptor = jibPluginDescriptor;
        this.project = project;
        this.session = session;
        this.tempDirectoryProvider = tempDirectoryProvider;
        this.extensionLoader = extensionLoader;
        ConsoleLoggerBuilder consoleLoggerBuilder = (MavenProjectProperties.isProgressFooterEnabled(session) ? ConsoleLoggerBuilder.rich(this.singleThreadedExecutor, true) : ConsoleLoggerBuilder.plain(this.singleThreadedExecutor).progress(arg_0 -> ((Log)log).info(arg_0))).lifecycle(arg_0 -> ((Log)log).info(arg_0));
        if (log.isDebugEnabled()) {
            consoleLoggerBuilder.debug(arg_0 -> ((Log)log).debug(arg_0)).info(arg_0 -> ((Log)log).debug(arg_0));
        }
        if (log.isWarnEnabled()) {
            consoleLoggerBuilder.warn(arg_0 -> ((Log)log).warn(arg_0));
        }
        if (log.isErrorEnabled()) {
            consoleLoggerBuilder.error(arg_0 -> ((Log)log).error(arg_0));
        }
        this.consoleLogger = consoleLoggerBuilder.build();
    }

    @Override
    public JibContainerBuilder createJibContainerBuilder(JavaContainerBuilder javaContainerBuilder, ContainerizingMode containerizingMode) throws IOException {
        try {
            if (this.isWarProject()) {
                Path war = this.getWarArtifact();
                Path explodedWarPath = this.tempDirectoryProvider.newDirectory();
                ZipUtil.unzip(war, explodedWarPath);
                return JavaContainerBuilderHelper.fromExplodedWar(javaContainerBuilder, explodedWarPath, this.getProjectDependencies().stream().map(Artifact::getFile).map(File::getName).collect(Collectors.toSet()));
            }
            switch (containerizingMode) {
                case EXPLODED: {
                    Path classesOutputDirectory = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
                    Predicate<Path> isClassFile = path -> path.getFileName().toString().endsWith(".class");
                    javaContainerBuilder.addResources(classesOutputDirectory, isClassFile.negate()).addClasses(classesOutputDirectory, isClassFile);
                    break;
                }
                case PACKAGED: {
                    javaContainerBuilder.addToClasspath(this.getJarArtifact());
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown containerizing mode: " + (Object)((Object)containerizingMode));
                }
            }
            Map<JavaContainerBuilder.LayerType, List<Path>> classifiedDependencies = this.classifyDependencies(this.project.getArtifacts(), this.getProjectDependencies());
            javaContainerBuilder.addDependencies((List)Preconditions.checkNotNull(classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.DEPENDENCIES)));
            javaContainerBuilder.addSnapshotDependencies((List)Preconditions.checkNotNull(classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.SNAPSHOT_DEPENDENCIES)));
            javaContainerBuilder.addProjectDependencies((List)Preconditions.checkNotNull(classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES)));
            return javaContainerBuilder.toContainerBuilder();
        }
        catch (IOException ex) {
            throw new IOException("Obtaining project build output files failed; make sure you have " + (containerizingMode == ContainerizingMode.PACKAGED ? "packaged" : "compiled") + " your project before trying to build the image. (Did you accidentally run \"mvn clean jib:build\" instead of \"mvn clean " + (containerizingMode == ContainerizingMode.PACKAGED ? "package" : "compile") + " jib:build\"?)", ex);
        }
    }

    @VisibleForTesting
    Set<Artifact> getProjectDependencies() {
        return this.session.getProjects().stream().map(MavenProject::getArtifact).filter(artifact -> !artifact.equals(this.project.getArtifact())).filter(artifact -> artifact.getFile() != null).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Map<JavaContainerBuilder.LayerType, List<Path>> classifyDependencies(Set<Artifact> dependencies, Set<Artifact> projectArtifacts) {
        HashMap<JavaContainerBuilder.LayerType, List<Path>> classifiedDependencies = new HashMap<JavaContainerBuilder.LayerType, List<Path>>();
        classifiedDependencies.put(JavaContainerBuilder.LayerType.DEPENDENCIES, new ArrayList());
        classifiedDependencies.put(JavaContainerBuilder.LayerType.SNAPSHOT_DEPENDENCIES, new ArrayList());
        classifiedDependencies.put(JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES, new ArrayList());
        for (Artifact artifact : dependencies) {
            if (projectArtifacts.contains(artifact)) {
                ((List)classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES)).add(artifact.getFile().toPath());
                continue;
            }
            if (artifact.isSnapshot()) {
                ((List)classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.SNAPSHOT_DEPENDENCIES)).add(artifact.getFile().toPath());
                continue;
            }
            ((List)classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.DEPENDENCIES)).add(artifact.getFile().toPath());
        }
        return classifiedDependencies;
    }

    @Override
    public List<Path> getClassFiles() throws IOException {
        return new DirectoryWalker(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0])).walk().asList();
    }

    @Override
    public List<Path> getDependencies() {
        return this.project.getArtifacts().stream().map(artifact -> artifact.getFile().toPath()).collect(Collectors.toList());
    }

    @Override
    public void waitForLoggingThread() {
        this.singleThreadedExecutor.shutDownAndAwaitTermination(LOGGING_THREAD_SHUTDOWN_TIMEOUT);
    }

    @Override
    public void configureEventHandlers(Containerizer containerizer) {
        containerizer.addEventHandler(LogEvent.class, this::log).addEventHandler(TimerEvent.class, new TimerEventHandler(message -> this.log(LogEvent.debug(message)))).addEventHandler(ProgressEvent.class, new ProgressEventHandler(update -> this.consoleLogger.setFooter(ProgressDisplayGenerator.generateProgressDisplay(update.getProgress(), update.getUnfinishedLeafTasks()))));
    }

    @Override
    public void log(LogEvent logEvent) {
        this.consoleLogger.log(logEvent.getLevel(), logEvent.getMessage());
    }

    @Override
    public String getToolName() {
        return "jib-maven-plugin";
    }

    @Override
    public String getToolVersion() {
        return this.jibPluginDescriptor.getVersion();
    }

    @Override
    public String getPluginName() {
        return "jib-maven-plugin";
    }

    @Override
    @Nullable
    public String getMainClassFromJarPlugin() {
        Plugin mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (mavenJarPlugin != null) {
            return MavenProjectProperties.getChildValue((Xpp3Dom)mavenJarPlugin.getConfiguration(), "archive", "manifest", "mainClass").orElse(null);
        }
        return null;
    }

    @Override
    public Path getDefaultCacheDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), "jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    @Override
    public boolean isWarProject() {
        String packaging = this.project.getPackaging();
        return "war".equals(packaging) || "gwt-app".equals(packaging);
    }

    @Override
    public String getName() {
        return this.project.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.project.getVersion();
    }

    @Override
    public int getMajorJavaVersion() {
        if (this.project.getProperties().getProperty("maven.compiler.target") != null) {
            return MavenProjectProperties.getVersionFromString(this.project.getProperties().getProperty("maven.compiler.target"));
        }
        if (this.project.getProperties().getProperty("maven.compiler.release") != null) {
            return MavenProjectProperties.getVersionFromString(this.project.getProperties().getProperty("maven.compiler.release"));
        }
        Plugin mavenCompilerPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (mavenCompilerPlugin != null) {
            Xpp3Dom pluginConfiguration = (Xpp3Dom)mavenCompilerPlugin.getConfiguration();
            Optional<String> target = MavenProjectProperties.getChildValue(pluginConfiguration, "target");
            if (target.isPresent()) {
                return MavenProjectProperties.getVersionFromString(target.get());
            }
            Optional<String> release = MavenProjectProperties.getChildValue(pluginConfiguration, "release");
            if (release.isPresent()) {
                return MavenProjectProperties.getVersionFromString(release.get());
            }
        }
        return 6;
    }

    @Override
    public boolean isOffline() {
        return this.session.isOffline();
    }

    @VisibleForTesting
    Path getWarArtifact() {
        Build build = this.project.getBuild();
        String warName = build.getFinalName();
        Plugin warPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-war-plugin");
        if (warPlugin != null) {
            for (PluginExecution execution : warPlugin.getExecutions()) {
                if (!"default-war".equals(execution.getId())) continue;
                Xpp3Dom configuration = (Xpp3Dom)execution.getConfiguration();
                warName = MavenProjectProperties.getChildValue(configuration, "warName").orElse(warName);
            }
        }
        return Paths.get(build.getDirectory(), warName + ".war");
    }

    @VisibleForTesting
    Path getJarArtifact() throws IOException {
        Path buildDirectory;
        Optional<Object> classifier = Optional.empty();
        Path outputDirectory = buildDirectory = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Plugin jarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (jarPlugin != null) {
            for (PluginExecution execution : jarPlugin.getExecutions()) {
                if (!"default-jar".equals(execution.getId())) continue;
                Xpp3Dom configuration = (Xpp3Dom)execution.getConfiguration();
                classifier = MavenProjectProperties.getChildValue(configuration, "classifier");
                Optional<String> directoryString = MavenProjectProperties.getChildValue(configuration, "outputDirectory");
                if (!directoryString.isPresent()) break;
                outputDirectory = this.project.getBasedir().toPath().resolve(directoryString.get());
                break;
            }
        }
        String finalName = this.project.getBuild().getFinalName();
        String suffix = ".jar";
        Optional<Xpp3Dom> bootConfiguration = this.getSpringBootRepackageConfiguration();
        if (bootConfiguration.isPresent()) {
            this.log(LogEvent.lifecycle("Spring Boot repackaging (fat JAR) detected; using the original JAR"));
            Optional<String> bootFinalName = MavenProjectProperties.getChildValue(bootConfiguration.get(), "finalName");
            Optional<String> bootClassifier = MavenProjectProperties.getChildValue(bootConfiguration.get(), "classifier");
            boolean sameDirectory = outputDirectory.equals(buildDirectory);
            boolean sameFinalName = !bootFinalName.isPresent() || finalName.equals(bootFinalName.get());
            boolean sameClassifier = classifier.equals(bootClassifier);
            if (sameDirectory && sameFinalName && sameClassifier) {
                suffix = ".jar.original";
            }
        }
        String noSuffixJarName = finalName + (classifier.isPresent() ? '-' + (String)classifier.get() : "");
        Path jarPath = outputDirectory.resolve(noSuffixJarName + suffix);
        this.log(LogEvent.debug("Using JAR: " + jarPath));
        if (".jar".equals(suffix)) {
            return jarPath;
        }
        Path tempDirectory = this.tempDirectoryProvider.newDirectory();
        Path newJarPath = tempDirectory.resolve(noSuffixJarName + ".original.jar");
        Files.copy(jarPath, newJarPath, new CopyOption[0]);
        return newJarPath;
    }

    @VisibleForTesting
    Optional<Xpp3Dom> getSpringBootRepackageConfiguration() {
        Plugin springBootPlugin = this.project.getPlugin("org.springframework.boot:spring-boot-maven-plugin");
        if (springBootPlugin != null) {
            for (PluginExecution execution : springBootPlugin.getExecutions()) {
                if (!execution.getGoals().contains("repackage")) continue;
                Xpp3Dom configuration = (Xpp3Dom)execution.getConfiguration();
                if (configuration == null) {
                    return Optional.of(new Xpp3Dom("configuration"));
                }
                boolean skip = Boolean.parseBoolean(MavenProjectProperties.getChildValue(configuration, "skip").orElse("false"));
                return skip ? Optional.empty() : Optional.of(configuration);
            }
        }
        return Optional.empty();
    }

    @Override
    public JibContainerBuilder runPluginExtensions(List<? extends RawConfiguration.ExtensionConfiguration> extensionConfigs, JibContainerBuilder jibContainerBuilder) throws JibPluginExtensionException {
        if (extensionConfigs.isEmpty()) {
            this.log(LogEvent.debug("No Jib plugin extensions configured to load"));
            return jibContainerBuilder;
        }
        List<JibMavenPluginExtension<?>> loadedExtensions = this.extensionLoader.get();
        JibMavenPluginExtension<?> extension = null;
        ContainerBuildPlan buildPlan = jibContainerBuilder.toContainerBuildPlan();
        try {
            for (RawConfiguration.ExtensionConfiguration extensionConfiguration : extensionConfigs) {
                extension = this.findConfiguredExtension(loadedExtensions, extensionConfiguration);
                this.log(LogEvent.lifecycle("Running extension: " + extensionConfiguration.getExtensionClass()));
                buildPlan = this.runPluginExtension(extension.getExtraConfigType(), extension, extensionConfiguration, buildPlan);
                ImageReference.parse(buildPlan.getBaseImage());
            }
            return jibContainerBuilder.applyContainerBuildPlan(buildPlan);
        }
        catch (InvalidImageReferenceException ex) {
            throw new JibPluginExtensionException(((JibMavenPluginExtension)Verify.verifyNotNull(extension)).getClass(), "invalid base image reference: " + buildPlan.getBaseImage(), (Throwable)ex);
        }
    }

    private <T> ContainerBuildPlan runPluginExtension(Optional<Class<T>> extraConfigType, JibMavenPluginExtension<?> extension, RawConfiguration.ExtensionConfiguration config, ContainerBuildPlan buildPlan) throws JibPluginExtensionException {
        Optional<Object> extraConfig = Optional.empty();
        if (config.getExtraConfiguration().isPresent()) {
            if (!extraConfigType.isPresent()) {
                throw new IllegalArgumentException("extension " + extension.getClass().getSimpleName() + " does not expect extension-specific configruation; remove the inapplicable <pluginExtension><configuration> from pom.xml");
            }
            if (!extraConfigType.get().isInstance(config.getExtraConfiguration().get())) {
                throw new JibPluginExtensionException(extension.getClass(), "extension-specific <configuration> for " + extension.getClass().getSimpleName() + " is not of type " + extraConfigType.get().getName() + " but " + config.getExtraConfiguration().get().getClass().getName() + "; specify the correct type with <pluginExtension><configuration implementation=\"" + extraConfigType.get().getName() + "\">");
            }
            extraConfig = config.getExtraConfiguration();
        }
        try {
            return extension.extendContainerBuildPlan(buildPlan, config.getProperties(), extraConfig, (MavenData)new MavenExtensionData(this.project, this.session), (ExtensionLogger)new PluginExtensionLogger(this::log));
        }
        catch (RuntimeException ex) {
            throw new JibPluginExtensionException(extension.getClass(), "extension crashed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private JibMavenPluginExtension<?> findConfiguredExtension(List<JibMavenPluginExtension<?>> extensions, RawConfiguration.ExtensionConfiguration config) throws JibPluginExtensionException {
        Predicate<JibMavenPluginExtension> matchesClassName = extension -> extension.getClass().getName().equals(config.getExtensionClass());
        Optional<JibMavenPluginExtension> found = extensions.stream().filter(matchesClassName).findFirst();
        if (!found.isPresent()) {
            throw new JibPluginExtensionException(NullExtension.class, "extension configured but not discovered on Jib runtime classpath: " + config.getExtensionClass());
        }
        return found.get();
    }
}

