/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PlatformChecker;
import com.google.cloud.tools.jib.builder.steps.ThrottledProgressEventDispatcherWrapper;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.ImageMetadataTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestAndConfigTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.UnlistedPlatformInManifestListException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestListTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class PullBaseImageStep
implements Callable<ImagesAndRegistryClient> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;

    PullBaseImageStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ImagesAndRegistryClient call() throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, BadContainerConfigurationFormatException, CacheCorruptedException, CredentialRetrievalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Image> pullBaseImages(RegistryClient registryClient, ProgressEventDispatcher progressEventDispatcher) throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, BadContainerConfigurationFormatException {
        Cache cache = this.buildContext.getBaseImageLayersCache();
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        ImageConfiguration baseImageConfig = this.buildContext.getBaseImageConfiguration();
        ManifestAndDigest<ManifestTemplate> manifestAndDigest = registryClient.pullManifest(baseImageConfig.getImageQualifier());
        eventHandlers.dispatch(LogEvent.lifecycle("Using base image with digest: " + manifestAndDigest.getDigest()));
        ManifestTemplate manifestTemplate = manifestAndDigest.getManifest();
        if (manifestTemplate instanceof V21ManifestTemplate) {
            V21ManifestTemplate v21Manifest = (V21ManifestTemplate)manifestTemplate;
            cache.writeMetadata(baseImageConfig.getImage(), v21Manifest);
            return Collections.singletonList(JsonToImageTranslator.toImage(v21Manifest));
        }
        if (manifestTemplate instanceof BuildableManifestTemplate) {
            BuildableManifestTemplate imageManifest = (BuildableManifestTemplate)manifestTemplate;
            ContainerConfigurationTemplate containerConfig = this.pullContainerConfigJson(manifestAndDigest, registryClient, progressEventDispatcher);
            PlatformChecker.checkManifestPlatform(this.buildContext, containerConfig);
            cache.writeMetadata(baseImageConfig.getImage(), imageManifest, containerConfig);
            return Collections.singletonList(JsonToImageTranslator.toImage(imageManifest, containerConfig));
        }
        Verify.verify((boolean)(manifestTemplate instanceof V22ManifestListTemplate));
        ArrayList<ManifestAndConfigTemplate> manifestsAndConfigs = new ArrayList<ManifestAndConfigTemplate>();
        ImmutableList.Builder images = ImmutableList.builder();
        for (Platform platform : this.buildContext.getContainerConfiguration().getPlatforms()) {
            String message = "Searching for architecture=%s, os=%s in the base image manifest list";
            eventHandlers.dispatch(LogEvent.info(String.format(message, platform.getArchitecture(), platform.getOs())));
            String manifestDigest = this.lookUpPlatformSpecificImageManifest((V22ManifestListTemplate)manifestTemplate, platform);
            ManifestAndDigest<ManifestTemplate> imageManifestAndDigest = registryClient.pullManifest(manifestDigest);
            BuildableManifestTemplate imageManifest = (BuildableManifestTemplate)imageManifestAndDigest.getManifest();
            ContainerConfigurationTemplate containerConfig = this.pullContainerConfigJson(imageManifestAndDigest, registryClient, progressEventDispatcher);
            manifestsAndConfigs.add(new ManifestAndConfigTemplate(imageManifest, containerConfig, manifestDigest));
            images.add((Object)JsonToImageTranslator.toImage(imageManifest, containerConfig));
        }
        cache.writeMetadata(baseImageConfig.getImage(), new ImageMetadataTemplate(manifestTemplate, manifestsAndConfigs));
        return images.build();
    }

    @VisibleForTesting
    String lookUpPlatformSpecificImageManifest(V22ManifestListTemplate manifestListTemplate, Platform platform) throws UnlistedPlatformInManifestListException {
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        List<String> digests = manifestListTemplate.getDigestsForPlatform(platform.getArchitecture(), platform.getOs());
        if (digests.size() == 0) {
            String errorMessage = this.buildContext.getBaseImageConfiguration().getImage() + " is a manifest list, but the list does not contain an image for architecture=%s, os=%s. If your intention was to specify a platform for your image, see https://github.com/GoogleContainerTools/jib/blob/master/docs/faq.md#how-do-i-specify-a-platform-in-the-manifest-list-or-oci-index-of-a-base-image";
            eventHandlers.dispatch(LogEvent.error(String.format(errorMessage, platform.getArchitecture(), platform.getOs())));
            throw new UnlistedPlatformInManifestListException(errorMessage);
        }
        return digests.get(0);
    }

    private ContainerConfigurationTemplate pullContainerConfigJson(ManifestAndDigest<?> manifestAndDigest, RegistryClient registryClient, ProgressEventDispatcher progressDispatcher) throws IOException, LayerPropertyNotFoundException, UnknownManifestFormatException {
        BuildableManifestTemplate manifest = (BuildableManifestTemplate)manifestAndDigest.getManifest();
        Preconditions.checkArgument((manifest.getSchemaVersion() == 2 ? 1 : 0) != 0);
        if (manifest.getContainerConfiguration() == null || manifest.getContainerConfiguration().getDigest() == null) {
            throw new UnknownManifestFormatException("Invalid container configuration in Docker V2.2/OCI manifest: \n" + JsonTemplateMapper.toUtf8String(manifest));
        }
        try (ThrottledProgressEventDispatcherWrapper progressDispatcherWrapper = new ThrottledProgressEventDispatcherWrapper(progressDispatcher.newChildProducer(), "pull container configuration " + manifest.getContainerConfiguration().getDigest());){
            String containerConfigString = Blobs.writeToString(registryClient.pullBlob(manifest.getContainerConfiguration().getDigest(), progressDispatcherWrapper::setProgressTarget, progressDispatcherWrapper::dispatchProgress));
            ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(containerConfigString, ContainerConfigurationTemplate.class);
            return containerConfigurationTemplate;
        }
    }

    @VisibleForTesting
    List<Image> getCachedBaseImages() throws IOException, CacheCorruptedException, BadContainerConfigurationFormatException, LayerCountMismatchException, UnlistedPlatformInManifestListException {
        ImageReference baseImage = this.buildContext.getBaseImageConfiguration().getImage();
        Optional<ImageMetadataTemplate> metadata = this.buildContext.getBaseImageLayersCache().retrieveMetadata(baseImage);
        if (!metadata.isPresent()) {
            return Collections.emptyList();
        }
        ManifestTemplate manifestList = metadata.get().getManifestList();
        List<ManifestAndConfigTemplate> manifestsAndConfigs = metadata.get().getManifestsAndConfigs();
        if (manifestList == null) {
            Verify.verify((manifestsAndConfigs.size() == 1 ? 1 : 0) != 0);
            ManifestTemplate manifest = manifestsAndConfigs.get(0).getManifest();
            if (manifest instanceof V21ManifestTemplate) {
                return Collections.singletonList(JsonToImageTranslator.toImage((V21ManifestTemplate)manifest));
            }
            ContainerConfigurationTemplate containerConfig = (ContainerConfigurationTemplate)Verify.verifyNotNull((Object)manifestsAndConfigs.get(0).getConfig());
            PlatformChecker.checkManifestPlatform(this.buildContext, containerConfig);
            return Collections.singletonList(JsonToImageTranslator.toImage((BuildableManifestTemplate)Verify.verifyNotNull((Object)manifest), containerConfig));
        }
        ImmutableList.Builder images = ImmutableList.builder();
        for (Platform platform : this.buildContext.getContainerConfiguration().getPlatforms()) {
            String manifestDigest = this.lookUpPlatformSpecificImageManifest((V22ManifestListTemplate)manifestList, platform);
            Optional<ManifestAndConfigTemplate> manifestAndConfigFound = manifestsAndConfigs.stream().filter(entry -> manifestDigest.equals(entry.getManifestDigest())).findFirst();
            if (!manifestAndConfigFound.isPresent()) {
                return Collections.emptyList();
            }
            ManifestTemplate manifest = (ManifestTemplate)Verify.verifyNotNull((Object)manifestAndConfigFound.get().getManifest());
            ContainerConfigurationTemplate containerConfig = (ContainerConfigurationTemplate)Verify.verifyNotNull((Object)manifestAndConfigFound.get().getConfig());
            images.add((Object)JsonToImageTranslator.toImage((BuildableManifestTemplate)manifest, containerConfig));
        }
        return images.build();
    }

    static class ImagesAndRegistryClient {
        final List<Image> images;
        @Nullable
        final RegistryClient registryClient;

        ImagesAndRegistryClient(List<Image> images, @Nullable RegistryClient registryClient) {
            this.images = images;
            this.registryClient = registryClient;
        }
    }
}

