/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.ThrottledProgressEventDispatcherWrapper;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestAndConfig;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestListTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class PullBaseImageStep
implements Callable<ImagesAndRegistryClient> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;

    PullBaseImageStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ImagesAndRegistryClient call() throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, BadContainerConfigurationFormatException, CacheCorruptedException, CredentialRetrievalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkImagePlatform(Image image) {
        boolean ok;
        Preconditions.checkState((this.buildContext.getContainerConfiguration().getPlatforms().size() == 1 ? 1 : 0) != 0);
        Platform platform = (Platform)this.buildContext.getContainerConfiguration().getPlatforms().iterator().next();
        boolean bl = ok = image.getArchitecture().equals(platform.getArchitecture()) && image.getOs().equals(platform.getOs());
        if (!ok) {
            String message = "platform of the cached manifest does not match the requested one";
            this.buildContext.getEventHandlers().dispatch(LogEvent.debug(message));
        }
        return ok;
    }

    private List<Image> pullBaseImages(RegistryClient registryClient, ProgressEventDispatcher progressEventDispatcher) throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, BadContainerConfigurationFormatException {
        ManifestAndDigest<?> manifestAndDigest = registryClient.pullManifest(this.buildContext.getBaseImageConfiguration().getImageQualifier());
        Object manifestTemplate = manifestAndDigest.getManifest();
        if (manifestTemplate instanceof V22ManifestListTemplate) {
            ImmutableList.Builder images = ImmutableList.builder();
            for (Platform platform : this.buildContext.getContainerConfiguration().getPlatforms()) {
                manifestAndDigest = this.obtainPlatformSpecificImageManifest(registryClient, (V22ManifestListTemplate)manifestTemplate, platform);
                images.add((Object)this.jsonManifestToImage(manifestAndDigest, registryClient, progressEventDispatcher));
            }
            return images.build();
        }
        return Collections.singletonList(this.jsonManifestToImage(manifestAndDigest, registryClient, progressEventDispatcher));
    }

    @VisibleForTesting
    ManifestAndDigest<?> obtainPlatformSpecificImageManifest(RegistryClient registryClient, V22ManifestListTemplate manifestListTemplate, Platform platform) throws IOException, RegistryException {
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        eventHandlers.dispatch(LogEvent.lifecycle("The base image reference is a manifest list, searching for architecture=" + platform.getArchitecture() + ", os=" + platform.getOs()));
        List<String> digests = manifestListTemplate.getDigestsForPlatform(platform.getArchitecture(), platform.getOs());
        if (digests.size() == 0) {
            String errorMessage = this.buildContext.getBaseImageConfiguration().getImage() + " is a manifest list, but the list does not contain an image manifest for the platform architecture=" + platform.getArchitecture() + ", os=" + platform.getOs() + ". If your intention was to specify a platform for your image, see https://github.com/GoogleContainerTools/jib/blob/master/docs/faq.md#how-do-i-specify-a-platform-in-the-manifest-list-or-oci-index-of-a-base-image to learn more about specifying a platform";
            eventHandlers.dispatch(LogEvent.error(errorMessage));
            throw new RegistryException(errorMessage);
        }
        return registryClient.pullManifest(digests.get(0));
    }

    private Image jsonManifestToImage(ManifestAndDigest<?> manifestAndDigest, RegistryClient registryClient, ProgressEventDispatcher progressEventDispatcher) throws IOException, LayerPropertyNotFoundException, BadContainerConfigurationFormatException, UnknownManifestFormatException, LayerCountMismatchException {
        EventHandlers eventHandlers = this.buildContext.getEventHandlers();
        Object manifestTemplate = manifestAndDigest.getManifest();
        switch (manifestTemplate.getSchemaVersion()) {
            case 1: {
                V21ManifestTemplate v21ManifestTemplate = (V21ManifestTemplate)manifestTemplate;
                this.buildContext.getBaseImageLayersCache().writeMetadata(this.buildContext.getBaseImageConfiguration().getImage(), v21ManifestTemplate);
                return JsonToImageTranslator.toImage(v21ManifestTemplate);
            }
            case 2: {
                eventHandlers.dispatch(LogEvent.lifecycle("Using base image with digest: " + manifestAndDigest.getDigest()));
                BuildableManifestTemplate buildableManifestTemplate = (BuildableManifestTemplate)manifestTemplate;
                if (buildableManifestTemplate.getContainerConfiguration() == null || buildableManifestTemplate.getContainerConfiguration().getDigest() == null) {
                    throw new UnknownManifestFormatException("Invalid container configuration in Docker V2.2/OCI manifest: \n" + JsonTemplateMapper.toUtf8String(buildableManifestTemplate));
                }
                DescriptorDigest containerConfigurationDigest = buildableManifestTemplate.getContainerConfiguration().getDigest();
                try (ThrottledProgressEventDispatcherWrapper progressEventDispatcherWrapper = new ThrottledProgressEventDispatcherWrapper(progressEventDispatcher.newChildProducer(), "pull container configuration " + containerConfigurationDigest);){
                    String containerConfigurationString = Blobs.writeToString(registryClient.pullBlob(containerConfigurationDigest, progressEventDispatcherWrapper::setProgressTarget, progressEventDispatcherWrapper::dispatchProgress));
                    ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(containerConfigurationString, ContainerConfigurationTemplate.class);
                    this.buildContext.getBaseImageLayersCache().writeMetadata(this.buildContext.getBaseImageConfiguration().getImage(), buildableManifestTemplate, containerConfigurationTemplate);
                    Image image = JsonToImageTranslator.toImage(buildableManifestTemplate, containerConfigurationTemplate);
                    return image;
                }
            }
        }
        throw new IllegalStateException("Unknown manifest schema version: " + manifestTemplate.getSchemaVersion());
    }

    private Optional<Image> getCachedBaseImage() throws IOException, CacheCorruptedException, BadContainerConfigurationFormatException, LayerCountMismatchException {
        ImageReference baseImage = this.buildContext.getBaseImageConfiguration().getImage();
        Optional<ManifestAndConfig> metadata = this.buildContext.getBaseImageLayersCache().retrieveMetadata(baseImage);
        if (!metadata.isPresent()) {
            return Optional.empty();
        }
        ManifestTemplate manifestTemplate = metadata.get().getManifest();
        if (manifestTemplate instanceof V21ManifestTemplate) {
            return Optional.of(JsonToImageTranslator.toImage((V21ManifestTemplate)manifestTemplate));
        }
        ContainerConfigurationTemplate configurationTemplate = metadata.get().getConfig().orElseThrow(IllegalStateException::new);
        return Optional.of(JsonToImageTranslator.toImage((BuildableManifestTemplate)manifestTemplate, configurationTemplate));
    }

    static class ImagesAndRegistryClient {
        final List<Image> images;
        @Nullable
        final RegistryClient registryClient;

        ImagesAndRegistryClient(List<Image> images, @Nullable RegistryClient registryClient) {
            this.images = images;
            this.registryClient = registryClient;
        }
    }
}

