/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.InsecureRegistryException;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class AuthenticatePushStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating with push to %s";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep;
    private final ListenableFuture<Authorization> listenableFuture;

    AuthenticatePushStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.retrieveTargetRegistryCredentialsStep = retrieveTargetRegistryCredentialsStep;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(retrieveTargetRegistryCredentialsStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Authorization call() throws ExecutionException, IOException, RegistryException {
        Credential registryCredential = NonBlockingSteps.get(this.retrieveTargetRegistryCredentialsStep);
        String registry = this.buildConfiguration.getTargetImageConfiguration().getImageRegistry();
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("authenticating push to " + registry, 1L);
             TimerEventDispatcher ignored2 = new TimerEventDispatcher(this.buildConfiguration.getEventHandlers(), String.format(DESCRIPTION, registry));){
            RegistryAuthenticator registryAuthenticator = this.buildConfiguration.newTargetImageRegistryClientFactory().newRegistryClient().getRegistryAuthenticator();
            if (registryAuthenticator != null) {
                Authorization authorization = registryAuthenticator.authenticatePush(registryCredential);
                return authorization;
            }
        }
        catch (InsecureRegistryException insecureRegistryException) {
            // empty catch block
        }
        if (registryCredential == null) return null;
        if (registryCredential.isOAuth2RefreshToken()) return null;
        Authorization authorization = Authorization.fromBasicCredentials(registryCredential.getUsername(), registryCredential.getPassword());
        return authorization;
    }
}

