/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class DockerDaemonImage {
    private final ImageReference imageReference;
    @Nullable
    private Path dockerExecutable;
    private Map<String, String> dockerEnvironment = Collections.emptyMap();

    public static DockerDaemonImage named(ImageReference imageReference) {
        return new DockerDaemonImage(imageReference);
    }

    public static DockerDaemonImage named(String imageReference) throws InvalidImageReferenceException {
        return DockerDaemonImage.named(ImageReference.parse(imageReference));
    }

    private DockerDaemonImage(ImageReference imageReference) {
        this.imageReference = imageReference;
    }

    public DockerDaemonImage setDockerExecutable(Path dockerExecutable) {
        this.dockerExecutable = dockerExecutable;
        return this;
    }

    public DockerDaemonImage setDockerEnvironment(Map<String, String> dockerEnvironment) {
        this.dockerEnvironment = dockerEnvironment;
        return this;
    }

    ImageReference getImageReference() {
        return this.imageReference;
    }

    Optional<Path> getDockerExecutable() {
        return Optional.ofNullable(this.dockerExecutable);
    }

    Map<String, String> getDockerEnvironment() {
        return this.dockerEnvironment;
    }
}

