/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.JibEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.builder.steps.StepsRunner;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.filesystem.UserCacheHome;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Containerizer {
    public static final Path DEFAULT_BASE_CACHE_DIRECTORY = UserCacheHome.getCacheHome().resolve("google-cloud-tools-java").resolve("jib");
    private static final String DEFAULT_TOOL_NAME = "jib-core";
    private static final String DESCRIPTION_FOR_DOCKER_REGISTRY = "Building and pushing image";
    private static final String DESCRIPTION_FOR_DOCKER_DAEMON = "Building image to Docker daemon";
    private static final String DESCRIPTION_FOR_TARBALL = "Building image tarball";
    private final String description;
    private final ImageConfiguration imageConfiguration;
    private final Function<BuildConfiguration, StepsRunner> stepsRunnerFactory;
    private final boolean mustBeOnline;
    private final Set<String> additionalTags = new HashSet<String>();
    private final EventHandlers.Builder eventHandlersBuilder = EventHandlers.builder();
    @Nullable
    private ExecutorService executorService;
    private Path baseImageLayersCacheDirectory = DEFAULT_BASE_CACHE_DIRECTORY;
    @Nullable
    private Path applicationLayersCacheDirectory;
    private boolean allowInsecureRegistries = false;
    private boolean offline = false;
    private String toolName = "jib-core";

    public static Containerizer to(RegistryImage registryImage) {
        ImageConfiguration imageConfiguration = ImageConfiguration.builder(registryImage.getImageReference()).setCredentialRetrievers(registryImage.getCredentialRetrievers()).build();
        Function<BuildConfiguration, StepsRunner> stepsRunnerFactory = buildConfiguration -> StepsRunner.begin(buildConfiguration).retrieveTargetRegistryCredentials().authenticatePush().pullBaseImage().pullAndCacheBaseImageLayers().pushBaseImageLayers().buildAndCacheApplicationLayers().buildImage().pushContainerConfiguration().pushApplicationLayers().pushImage();
        return new Containerizer(DESCRIPTION_FOR_DOCKER_REGISTRY, imageConfiguration, stepsRunnerFactory, true);
    }

    public static Containerizer to(DockerDaemonImage dockerDaemonImage) {
        ImageConfiguration imageConfiguration = ImageConfiguration.builder(dockerDaemonImage.getImageReference()).build();
        DockerClient.Builder dockerClientBuilder = DockerClient.builder();
        dockerDaemonImage.getDockerExecutable().ifPresent(dockerClientBuilder::setDockerExecutable);
        dockerClientBuilder.setDockerEnvironment((ImmutableMap<String, String>)ImmutableMap.copyOf(dockerDaemonImage.getDockerEnvironment()));
        Function<BuildConfiguration, StepsRunner> stepsRunnerFactory = buildConfiguration -> StepsRunner.begin(buildConfiguration).pullBaseImage().pullAndCacheBaseImageLayers().buildAndCacheApplicationLayers().buildImage().loadDocker(dockerClientBuilder.build());
        return new Containerizer(DESCRIPTION_FOR_DOCKER_DAEMON, imageConfiguration, stepsRunnerFactory, false);
    }

    public static Containerizer to(TarImage tarImage) {
        ImageConfiguration imageConfiguration = ImageConfiguration.builder(tarImage.getImageReference()).build();
        Function<BuildConfiguration, StepsRunner> stepsRunnerFactory = buildConfiguration -> StepsRunner.begin(buildConfiguration).pullBaseImage().pullAndCacheBaseImageLayers().buildAndCacheApplicationLayers().buildImage().writeTarFile(tarImage.getOutputFile());
        return new Containerizer(DESCRIPTION_FOR_TARBALL, imageConfiguration, stepsRunnerFactory, false);
    }

    private Containerizer(String description, ImageConfiguration imageConfiguration, Function<BuildConfiguration, StepsRunner> stepsRunnerFactory, boolean mustBeOnline) {
        this.description = description;
        this.imageConfiguration = imageConfiguration;
        this.stepsRunnerFactory = stepsRunnerFactory;
        this.mustBeOnline = mustBeOnline;
    }

    public Containerizer withAdditionalTag(String tag) {
        Preconditions.checkArgument((boolean)ImageReference.isValidTag(tag), (String)"invalid tag '%s'", (Object)tag);
        this.additionalTags.add(tag);
        return this;
    }

    public Containerizer setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Containerizer setBaseImageLayersCache(Path cacheDirectory) {
        this.baseImageLayersCacheDirectory = cacheDirectory;
        return this;
    }

    public Containerizer setApplicationLayersCache(Path cacheDirectory) {
        this.applicationLayersCacheDirectory = cacheDirectory;
        return this;
    }

    public <E extends JibEvent> Containerizer addEventHandler(Class<E> eventType, Consumer<? super E> eventConsumer) {
        this.eventHandlersBuilder.add(eventType, eventConsumer);
        return this;
    }

    public Containerizer addEventHandler(Consumer<JibEvent> eventConsumer) {
        this.eventHandlersBuilder.add(JibEvent.class, eventConsumer);
        return this;
    }

    public Containerizer setAllowInsecureRegistries(boolean allowInsecureRegistries) {
        this.allowInsecureRegistries = allowInsecureRegistries;
        return this;
    }

    public Containerizer setOfflineMode(boolean offline) {
        if (this.mustBeOnline && offline) {
            throw new IllegalStateException("Cannot build to a container registry in offline mode");
        }
        this.offline = offline;
        return this;
    }

    public Containerizer setToolName(String toolName) {
        this.toolName = toolName;
        return this;
    }

    Set<String> getAdditionalTags() {
        return this.additionalTags;
    }

    Optional<ExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService);
    }

    Path getBaseImageLayersCacheDirectory() {
        return this.baseImageLayersCacheDirectory;
    }

    Path getApplicationLayersCacheDirectory() throws CacheDirectoryCreationException {
        if (this.applicationLayersCacheDirectory == null) {
            try {
                Path temporaryDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
                temporaryDirectory.toFile().deleteOnExit();
                this.applicationLayersCacheDirectory = temporaryDirectory;
            }
            catch (IOException ex) {
                throw new CacheDirectoryCreationException(ex);
            }
        }
        return this.applicationLayersCacheDirectory;
    }

    EventHandlers buildEventHandlers() {
        return this.eventHandlersBuilder.build();
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    boolean isOfflineMode() {
        return this.offline;
    }

    String getToolName() {
        return this.toolName;
    }

    String getDescription() {
        return this.description;
    }

    ImageConfiguration getImageConfiguration() {
        return this.imageConfiguration;
    }

    StepsRunner createStepsRunner(BuildConfiguration buildConfiguration) {
        return this.stepsRunnerFactory.apply(buildConfiguration);
    }
}

