/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryNoResponseException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.HttpHostConnectException;

class RegistryEndpointCaller<T> {
    @VisibleForTesting
    static final int STATUS_CODE_PERMANENT_REDIRECT = 308;
    private static final String DEFAULT_PROTOCOL = "https";
    private final Function<URL, Connection> connectionFactory;
    private final RequestState initialRequestState;
    private final String userAgent;
    private final RegistryEndpointProvider<T> registryEndpointProvider;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowHttp;

    RegistryEndpointCaller(String userAgent, String apiRouteBase, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowHttp) throws MalformedURLException {
        this(userAgent, apiRouteBase, registryEndpointProvider, authorization, registryEndpointRequestProperties, allowHttp, Connection::new);
    }

    @VisibleForTesting
    RegistryEndpointCaller(String userAgent, String apiRouteBase, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowHttp, Function<URL, Connection> connectionFactory) throws MalformedURLException {
        this.initialRequestState = new RequestState(authorization, registryEndpointProvider.getApiRoute("https://" + apiRouteBase));
        this.userAgent = userAgent;
        this.registryEndpointProvider = registryEndpointProvider;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowHttp = allowHttp;
        this.connectionFactory = connectionFactory;
    }

    @Nullable
    T call() throws IOException, RegistryException {
        return this.call(this.initialRequestState);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private T call(RequestState requestState) throws IOException, RegistryException {
        boolean isHttpProtocol = "http".equals(requestState.url.getProtocol());
        if (!this.allowHttp && isHttpProtocol) {
            throw new InsecureRegistryException(requestState.url);
        }
        try (Connection connection = this.connectionFactory.apply(requestState.url);){
            Request.Builder requestBuilder = Request.builder().setUserAgent(this.userAgent).setAccept(this.registryEndpointProvider.getAccept()).setBody(this.registryEndpointProvider.getContent());
            if (!isHttpProtocol) {
                requestBuilder.setAuthorization(requestState.authorization);
            }
            Response response = connection.send(this.registryEndpointProvider.getHttpMethod(), requestBuilder.build());
            T t = this.registryEndpointProvider.handleResponse(response);
            return t;
        }
        catch (HttpResponseException ex) {
            try {
                return this.registryEndpointProvider.handleHttpResponseException(ex);
            }
            catch (HttpResponseException httpResponseException) {
                if (httpResponseException.getStatusCode() == 400 || httpResponseException.getStatusCode() == 404 || httpResponseException.getStatusCode() == 405) {
                    ErrorResponseTemplate errorResponse = JsonTemplateMapper.readJson(httpResponseException.getContent(), ErrorResponseTemplate.class);
                    RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.registryEndpointProvider.getActionDescription(), httpResponseException);
                    Iterator<ErrorEntryTemplate> iterator = errorResponse.getErrors().iterator();
                    while (iterator.hasNext()) {
                        ErrorEntryTemplate errorEntry = iterator.next();
                        registryErrorExceptionBuilder.addReason(errorEntry);
                    }
                    throw registryErrorExceptionBuilder.build();
                }
                if (httpResponseException.getStatusCode() == 401) throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException);
                if (httpResponseException.getStatusCode() == 403) {
                    throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException);
                }
                if (httpResponseException.getStatusCode() != 307 && httpResponseException.getStatusCode() != 301) {
                    if (httpResponseException.getStatusCode() != 308) throw httpResponseException;
                }
                URL redirectLocation = new URL(requestState.url, httpResponseException.getHeaders().getLocation());
                return this.call(new RequestState(requestState.authorization, redirectLocation));
            }
        }
        catch (SSLPeerUnverifiedException | HttpHostConnectException ex) {
            if (!DEFAULT_PROTOCOL.equals(requestState.url.getProtocol())) throw ex;
            GenericUrl httpUrl = new GenericUrl(requestState.url);
            httpUrl.setScheme("http");
            return this.call(new RequestState(requestState.authorization, httpUrl.toURL()));
        }
        catch (NoHttpResponseException ex) {
            throw new RegistryNoResponseException(ex);
        }
    }

    private static class RequestState {
        @Nullable
        private final Authorization authorization;
        private final URL url;

        private RequestState(@Nullable Authorization authorization, URL url) {
            this.authorization = authorization;
            this.url = url;
        }
    }
}

