/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;

class LayerMetadata {
    private List<String> sourceFiles;
    private final FileTime lastModifiedTime;

    static LayerMetadata from(List<Path> sourceFiles, FileTime lastModifiedTime) {
        ArrayList<String> sourceFilesStrings = new ArrayList<String>(sourceFiles.size());
        for (Path sourceFile : sourceFiles) {
            sourceFilesStrings.add(sourceFile.toString());
        }
        return new LayerMetadata(sourceFilesStrings, lastModifiedTime);
    }

    LayerMetadata(List<String> sourceFiles, FileTime lastModifiedTime) {
        this.sourceFiles = sourceFiles;
        this.lastModifiedTime = lastModifiedTime;
    }

    List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @VisibleForTesting
    void setSourceFiles(List<String> sourceFiles) {
        this.sourceFiles = sourceFiles;
    }
}

