/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Caches
implements Closeable {
    private final Cache baseCache;
    private final Cache applicationCache;

    private Caches(Path baseCacheDirectory, Path applicationCacheDirectory) throws CacheMetadataCorruptedException, IOException {
        this.applicationCache = Cache.init(applicationCacheDirectory);
        this.baseCache = Files.isSameFile(baseCacheDirectory, applicationCacheDirectory) ? this.applicationCache : Cache.init(baseCacheDirectory);
    }

    public Cache getBaseCache() {
        return this.baseCache;
    }

    public Cache getApplicationCache() {
        return this.applicationCache;
    }

    @Override
    public void close() throws IOException {
        this.applicationCache.close();
        if (this.baseCache != this.applicationCache) {
            this.baseCache.close();
        }
    }

    public static class Initializer {
        private static final String OWNERSHIP_FILE_NAME = ".jib";
        private final Path baseImageLayersCacheDirectory;
        private final boolean shouldEnsureOwnershipOfBaseImageLayersCacheDirectory;
        private final Path applicationLayersCacheDirectory;
        private final boolean shouldEnsureOwnershipOfApplicationLayersCacheDirectory;

        @VisibleForTesting
        static void ensureOwnership(Path cacheDirectory) throws CacheDirectoryNotOwnedException, CacheDirectoryCreationException {
            Path ownershipFile = cacheDirectory.resolve(OWNERSHIP_FILE_NAME);
            if (Files.exists(cacheDirectory, new LinkOption[0])) {
                if (!Files.exists(ownershipFile, new LinkOption[0])) {
                    throw new CacheDirectoryNotOwnedException(cacheDirectory);
                }
            } else {
                try {
                    Files.createDirectories(cacheDirectory, new FileAttribute[0]);
                    Files.createFile(ownershipFile, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new CacheDirectoryCreationException(cacheDirectory, (Throwable)ex);
                }
            }
        }

        public Initializer(Path baseImageLayersCacheDirectory, boolean shouldEnsureOwnershipOfBaseImageLayersCacheDirectory, Path applicationLayersCacheDirectory, boolean shouldEnsureOwnershipOfApplicationLayersCacheDirectory) {
            this.baseImageLayersCacheDirectory = baseImageLayersCacheDirectory;
            this.shouldEnsureOwnershipOfBaseImageLayersCacheDirectory = shouldEnsureOwnershipOfBaseImageLayersCacheDirectory;
            this.applicationLayersCacheDirectory = applicationLayersCacheDirectory;
            this.shouldEnsureOwnershipOfApplicationLayersCacheDirectory = shouldEnsureOwnershipOfApplicationLayersCacheDirectory;
        }

        public Caches init() throws CacheMetadataCorruptedException, CacheDirectoryNotOwnedException, CacheDirectoryCreationException, IOException {
            if (this.shouldEnsureOwnershipOfBaseImageLayersCacheDirectory) {
                Initializer.ensureOwnership(this.baseImageLayersCacheDirectory);
            }
            if (this.shouldEnsureOwnershipOfApplicationLayersCacheDirectory) {
                Initializer.ensureOwnership(this.applicationLayersCacheDirectory);
            }
            return new Caches(this.baseImageLayersCacheDirectory, this.applicationLayersCacheDirectory);
        }
    }
}

