/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class PullBaseImageStep
implements AsyncStep<BaseImageWithAuthorization>,
Callable<BaseImageWithAuthorization> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildConfiguration buildConfiguration;
    private final ListenableFuture<BaseImageWithAuthorization> listenableFuture;

    PullBaseImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<BaseImageWithAuthorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BaseImageWithAuthorization call() throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, ExecutionException {
        this.buildConfiguration.getBuildLogger().lifecycle("Getting base image " + this.buildConfiguration.getBaseImageReference() + "...");
        Throwable throwable = null;
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(null), null);
            return baseImageWithAuthorization;
        }
        catch (RegistryUnauthorizedException ex) {
            ListeningExecutorService directExecutorService = MoreExecutors.newDirectExecutorService();
            RetrieveRegistryCredentialsStep retrieveBaseRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forBaseImage(directExecutorService, this.buildConfiguration);
            Authorization registryCredentials = NonBlockingSteps.get(retrieveBaseRegistryCredentialsStep);
            BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(registryCredentials), registryCredentials);
            return baseImageWithAuthorization;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private Image<Layer> pullBaseImage(@Nullable Authorization registryCredentials) throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException {
        RegistryClient.Factory registryClientFactory = RegistryClient.factory(this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository());
        RegistryClient registryClient = this.buildConfiguration.getAllowHttp() ? registryClientFactory.newAllowHttp() : registryClientFactory.newWithAuthorization(registryCredentials);
        ManifestTemplate manifestTemplate = registryClient.pullManifest(this.buildConfiguration.getBaseImageTag());
        switch (manifestTemplate.getSchemaVersion()) {
            case 1: {
                V21ManifestTemplate v21ManifestTemplate = (V21ManifestTemplate)manifestTemplate;
                return JsonToImageTranslator.toImage(v21ManifestTemplate);
            }
            case 2: {
                V22ManifestTemplate v22ManifestTemplate = (V22ManifestTemplate)manifestTemplate;
                if (v22ManifestTemplate.getContainerConfiguration() == null || v22ManifestTemplate.getContainerConfiguration().getDigest() == null) {
                    throw new UnknownManifestFormatException("Invalid container configuration in Docker V2.2 manifest: \n" + Blobs.writeToString(JsonTemplateMapper.toBlob(v22ManifestTemplate)));
                }
                ByteArrayOutputStream containerConfigurationOutputStream = new ByteArrayOutputStream();
                registryClient.pullBlob(v22ManifestTemplate.getContainerConfiguration().getDigest(), containerConfigurationOutputStream);
                String containerConfigurationString = new String(containerConfigurationOutputStream.toByteArray(), StandardCharsets.UTF_8);
                ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(containerConfigurationString, ContainerConfigurationTemplate.class);
                return JsonToImageTranslator.toImage(v22ManifestTemplate, containerConfigurationTemplate);
            }
        }
        throw new IllegalStateException("Unknown manifest schema version");
    }

    static class BaseImageWithAuthorization {
        private final Image<Layer> baseImage;
        @Nullable
        private final Authorization baseImageAuthorization;

        private BaseImageWithAuthorization(Image<Layer> baseImage, @Nullable Authorization baseImageAuthorization) {
            this.baseImage = baseImage;
            this.baseImageAuthorization = baseImageAuthorization;
        }

        Image<Layer> getBaseImage() {
            return this.baseImage;
        }

        @Nullable
        Authorization getBaseImageAuthorization() {
            return this.baseImageAuthorization;
        }
    }
}

