/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;

public class BuildConfiguration {
    private final BuildLogger buildLogger;
    private final ImageReference baseImageReference;
    @Nullable
    private final String baseImageCredentialHelperName;
    @Nullable
    private final RegistryCredentials knownBaseRegistryCredentials;
    private final ImageReference targetImageReference;
    @Nullable
    private final String targetImageCredentialHelperName;
    @Nullable
    private final RegistryCredentials knownTargetRegistryCredentials;
    private final String mainClass;
    private final ImmutableList<String> javaArguments;
    private final ImmutableList<String> jvmFlags;
    private final ImmutableMap<String, String> environmentMap;
    private final ImmutableList<String> exposedPorts;
    private final Class<? extends BuildableManifestTemplate> targetFormat;
    @Nullable
    private final CacheConfiguration applicationLayersCacheConfiguration;
    @Nullable
    private final CacheConfiguration baseImageLayersCacheConfiguration;
    private final boolean allowHttp;

    public static boolean isValidJavaClass(String className) {
        for (String part : Splitter.on((char)'.').split((CharSequence)className)) {
            if (SourceVersion.isIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    public static Builder builder(BuildLogger buildLogger) {
        return new Builder(buildLogger);
    }

    private BuildConfiguration(BuildLogger buildLogger, ImageReference baseImageReference, @Nullable String baseImageCredentialHelperName, @Nullable RegistryCredentials knownBaseRegistryCredentials, ImageReference targetImageReference, @Nullable String targetImageCredentialHelperName, @Nullable RegistryCredentials knownTargetRegistryCredentials, String mainClass, ImmutableList<String> javaArguments, ImmutableList<String> jvmFlags, ImmutableMap<String, String> environmentMap, ImmutableList<String> exposedPorts, Class<? extends BuildableManifestTemplate> targetFormat, @Nullable CacheConfiguration applicationLayersCacheConfiguration, @Nullable CacheConfiguration baseImageLayersCacheConfiguration, boolean allowHttp) {
        this.buildLogger = buildLogger;
        this.baseImageReference = baseImageReference;
        this.baseImageCredentialHelperName = baseImageCredentialHelperName;
        this.knownBaseRegistryCredentials = knownBaseRegistryCredentials;
        this.targetImageReference = targetImageReference;
        this.targetImageCredentialHelperName = targetImageCredentialHelperName;
        this.knownTargetRegistryCredentials = knownTargetRegistryCredentials;
        this.mainClass = mainClass;
        this.javaArguments = javaArguments;
        this.jvmFlags = jvmFlags;
        this.environmentMap = environmentMap;
        this.exposedPorts = exposedPorts;
        this.targetFormat = targetFormat;
        this.applicationLayersCacheConfiguration = applicationLayersCacheConfiguration;
        this.baseImageLayersCacheConfiguration = baseImageLayersCacheConfiguration;
        this.allowHttp = allowHttp;
    }

    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    public ImageReference getBaseImageReference() {
        return this.baseImageReference;
    }

    public String getBaseImageRegistry() {
        return this.baseImageReference.getRegistry();
    }

    public String getBaseImageRepository() {
        return this.baseImageReference.getRepository();
    }

    public String getBaseImageTag() {
        return this.baseImageReference.getTag();
    }

    @Nullable
    public String getBaseImageCredentialHelperName() {
        return this.baseImageCredentialHelperName;
    }

    @Nullable
    public RegistryCredentials getKnownBaseRegistryCredentials() {
        return this.knownBaseRegistryCredentials;
    }

    public ImageReference getTargetImageReference() {
        return this.targetImageReference;
    }

    public String getTargetImageRegistry() {
        return this.targetImageReference.getRegistry();
    }

    public String getTargetImageRepository() {
        return this.targetImageReference.getRepository();
    }

    public String getTargetImageTag() {
        return this.targetImageReference.getTag();
    }

    @Nullable
    public String getTargetImageCredentialHelperName() {
        return this.targetImageCredentialHelperName;
    }

    @Nullable
    public RegistryCredentials getKnownTargetRegistryCredentials() {
        return this.knownTargetRegistryCredentials;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    public ImmutableList<String> getJvmFlags() {
        return this.jvmFlags;
    }

    public ImmutableMap<String, String> getEnvironment() {
        return this.environmentMap;
    }

    public ImmutableList<String> getExposedPorts() {
        return this.exposedPorts;
    }

    public Class<? extends BuildableManifestTemplate> getTargetFormat() {
        return this.targetFormat;
    }

    @Nullable
    public CacheConfiguration getApplicationLayersCacheConfiguration() {
        return this.applicationLayersCacheConfiguration;
    }

    @Nullable
    public CacheConfiguration getBaseImageLayersCacheConfiguration() {
        return this.baseImageLayersCacheConfiguration;
    }

    public boolean getAllowHttp() {
        return this.allowHttp;
    }

    public static class Builder {
        @Nullable
        private ImageReference baseImageReference;
        @Nullable
        private String baseImageCredentialHelperName;
        @Nullable
        private RegistryCredentials knownBaseRegistryCredentials;
        @Nullable
        private ImageReference targetImageReference;
        @Nullable
        private String targetImageCredentialHelperName;
        @Nullable
        private RegistryCredentials knownTargetRegistryCredentials;
        @Nullable
        private String mainClass;
        private ImmutableList<String> javaArguments = ImmutableList.of();
        private ImmutableList<String> jvmFlags = ImmutableList.of();
        private ImmutableMap<String, String> environmentMap = ImmutableMap.of();
        private ImmutableList<String> exposedPorts = ImmutableList.of();
        private Class<? extends BuildableManifestTemplate> targetFormat = V22ManifestTemplate.class;
        @Nullable
        private CacheConfiguration applicationLayersCacheConfiguration;
        @Nullable
        private CacheConfiguration baseImageLayersCacheConfiguration;
        private boolean allowHttp = false;
        private BuildLogger buildLogger;

        private Builder(BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
        }

        public Builder setBaseImage(@Nullable ImageReference imageReference) {
            this.baseImageReference = imageReference;
            return this;
        }

        public Builder setTargetImage(@Nullable ImageReference imageReference) {
            this.targetImageReference = imageReference;
            return this;
        }

        public Builder setBaseImageCredentialHelperName(@Nullable String credentialHelperName) {
            this.baseImageCredentialHelperName = credentialHelperName;
            return this;
        }

        public Builder setTargetImageCredentialHelperName(@Nullable String credentialHelperName) {
            this.targetImageCredentialHelperName = credentialHelperName;
            return this;
        }

        public Builder setKnownBaseRegistryCredentials(@Nullable RegistryCredentials knownRegistryCrendentials) {
            this.knownBaseRegistryCredentials = knownRegistryCrendentials;
            return this;
        }

        public Builder setKnownTargetRegistryCredentials(@Nullable RegistryCredentials knownRegistryCrendentials) {
            this.knownTargetRegistryCredentials = knownRegistryCrendentials;
            return this;
        }

        public Builder setMainClass(@Nullable String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Builder setJavaArguments(@Nullable List<String> javaArguments) {
            if (javaArguments != null) {
                Preconditions.checkArgument((!javaArguments.contains(null) ? 1 : 0) != 0);
                this.javaArguments = ImmutableList.copyOf(javaArguments);
            }
            return this;
        }

        public Builder setJvmFlags(@Nullable List<String> jvmFlags) {
            if (jvmFlags != null) {
                Preconditions.checkArgument((!jvmFlags.contains(null) ? 1 : 0) != 0);
                this.jvmFlags = ImmutableList.copyOf(jvmFlags);
            }
            return this;
        }

        public Builder setEnvironment(@Nullable Map<String, String> environmentMap) {
            if (environmentMap != null) {
                Preconditions.checkArgument((!environmentMap.containsKey(null) && !environmentMap.containsValue(null) ? 1 : 0) != 0);
                this.environmentMap = ImmutableMap.copyOf(environmentMap);
            }
            return this;
        }

        public Builder setExposedPorts(@Nullable List<String> exposedPorts) {
            if (exposedPorts != null) {
                Preconditions.checkArgument((!exposedPorts.contains(null) ? 1 : 0) != 0);
                this.exposedPorts = ImmutableList.copyOf(exposedPorts);
            }
            return this;
        }

        public Builder setTargetFormat(Class<? extends BuildableManifestTemplate> targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }

        public Builder setApplicationLayersCacheConfiguration(@Nullable CacheConfiguration applicationLayersCacheConfiguration) {
            this.applicationLayersCacheConfiguration = applicationLayersCacheConfiguration;
            return this;
        }

        public Builder setBaseImageLayersCacheConfiguration(@Nullable CacheConfiguration baseImageLayersCacheConfiguration) {
            this.baseImageLayersCacheConfiguration = baseImageLayersCacheConfiguration;
            return this;
        }

        public Builder setAllowHttp(boolean allowHttp) {
            this.allowHttp = allowHttp;
            return this;
        }

        public BuildConfiguration build() {
            ArrayList<String> errorMessages = new ArrayList<String>();
            if (this.baseImageReference == null) {
                errorMessages.add("base image is required but not set");
            }
            if (this.targetImageReference == null) {
                errorMessages.add("target image is required but not set");
            }
            if (this.mainClass == null) {
                errorMessages.add("main class is required but not set");
            }
            switch (errorMessages.size()) {
                case 0: {
                    if (this.baseImageReference == null || this.targetImageReference == null || this.mainClass == null) {
                        throw new IllegalStateException("Required fields should not be null");
                    }
                    if (this.baseImageReference.usesDefaultTag()) {
                        this.buildLogger.warn("Base image '" + this.baseImageReference + "' does not use a specific image digest - build may not be reproducible");
                    }
                    return new BuildConfiguration(this.buildLogger, this.baseImageReference, this.baseImageCredentialHelperName, this.knownBaseRegistryCredentials, this.targetImageReference, this.targetImageCredentialHelperName, this.knownTargetRegistryCredentials, this.mainClass, this.javaArguments, this.jvmFlags, this.environmentMap, this.exposedPorts, this.targetFormat, this.applicationLayersCacheConfiguration, this.baseImageLayersCacheConfiguration, this.allowHttp);
                }
                case 1: {
                    throw new IllegalStateException((String)errorMessages.get(0));
                }
                case 2: {
                    throw new IllegalStateException((String)errorMessages.get(0) + " and " + (String)errorMessages.get(1));
                }
            }
            StringBuilder errorMessage = new StringBuilder((String)errorMessages.get(0));
            for (int errorMessageIndex = 1; errorMessageIndex < errorMessages.size(); ++errorMessageIndex) {
                if (errorMessageIndex == errorMessages.size() - 1) {
                    errorMessage.append(", and ");
                } else {
                    errorMessage.append(", ");
                }
                errorMessage.append((String)errorMessages.get(errorMessageIndex));
            }
            throw new IllegalStateException(errorMessage.toString());
        }
    }
}

