/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.nio.file.attribute.FileTime;

class LayerMetadata {
    private ImmutableList<LayerMetadataEntry> entries;
    private final FileTime lastModifiedTime;

    static LayerMetadata from(ImmutableList<LayerEntry> layerEntries, FileTime lastModifiedTime) {
        ImmutableList.Builder entries = ImmutableList.builderWithExpectedSize((int)layerEntries.size());
        for (LayerEntry layerEntry : layerEntries) {
            entries.add((Object)new LayerMetadataEntry(layerEntry.getAbsoluteSourceFileString(), layerEntry.getAbsoluteExtractionPathString()));
        }
        return new LayerMetadata((ImmutableList<LayerMetadataEntry>)entries.build(), lastModifiedTime);
    }

    LayerMetadata(ImmutableList<LayerMetadataEntry> entries, FileTime lastModifiedTime) {
        this.entries = entries;
        this.lastModifiedTime = lastModifiedTime;
    }

    ImmutableList<LayerMetadataEntry> getEntries() {
        return this.entries;
    }

    FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @VisibleForTesting
    void setEntries(ImmutableList<LayerMetadataEntry> layerMetadataEntries) {
        this.entries = layerMetadataEntries;
    }

    static class LayerMetadataEntry {
        private final String absoluteSourceFileString;
        private final String absoluteExtractionPathString;

        String getAbsoluteSourceFileString() {
            return this.absoluteSourceFileString;
        }

        String getAbsoluteExtractionPathString() {
            return this.absoluteExtractionPathString;
        }

        @VisibleForTesting
        LayerMetadataEntry(String absoluteSourceFileString, String absoluteExtractionPathString) {
            this.absoluteSourceFileString = absoluteSourceFileString;
            this.absoluteExtractionPathString = absoluteExtractionPathString;
        }
    }
}

