/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.SourceImage;
import com.google.cloud.tools.jib.api.TargetImage;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.configuration.credentials.CredentialRetriever;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class RegistryImage
implements SourceImage,
TargetImage {
    private final ImageReference imageReference;
    private List<CredentialRetriever> credentialRetrievers = new ArrayList<CredentialRetriever>();

    public static RegistryImage named(ImageReference imageReference) {
        return new RegistryImage(imageReference);
    }

    public static RegistryImage named(String imageReference) throws InvalidImageReferenceException {
        return RegistryImage.named(ImageReference.parse(imageReference));
    }

    private RegistryImage(ImageReference imageReference) {
        this.imageReference = imageReference;
    }

    public RegistryImage addCredential(String username, String password) {
        this.addCredentialRetriever(() -> Optional.of(Credential.basic(username, password)));
        return this;
    }

    public RegistryImage addCredentialRetriever(CredentialRetriever credentialRetriever) {
        this.credentialRetrievers.add(credentialRetriever);
        return this;
    }

    ImageReference getImageReference() {
        return this.imageReference;
    }

    List<CredentialRetriever> getCredentialRetrievers() {
        return Collections.unmodifiableList(this.credentialRetrievers);
    }
}

