/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.SourceImage;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class JibContainerBuilder {
    private final SourceImage baseImage;
    private List<LayerConfiguration> layerConfigurations = new ArrayList<LayerConfiguration>();
    private Map<String, String> environment = new HashMap<String, String>();
    private List<Port> ports = new ArrayList<Port>();
    private Map<String, String> labels = new HashMap<String, String>();
    @Nullable
    private ImmutableList<String> entrypoint;
    @Nullable
    private ImmutableList<String> programArguments;

    JibContainerBuilder(SourceImage baseImage) {
        this.baseImage = baseImage;
    }

    public JibContainerBuilder addLayer(List<Path> files, AbsoluteUnixPath pathInContainer) throws IOException {
        LayerConfiguration.Builder layerConfigurationBuilder = LayerConfiguration.builder();
        for (Path file : files) {
            layerConfigurationBuilder.addEntryRecursive(file, pathInContainer.resolve(file.getFileName()));
        }
        return this.addLayer(layerConfigurationBuilder.build());
    }

    public JibContainerBuilder setLayers(List<LayerConfiguration> layerConfigurations) {
        this.layerConfigurations = new ArrayList<LayerConfiguration>(layerConfigurations);
        return this;
    }

    public JibContainerBuilder setLayers(LayerConfiguration ... layerConfigurations) {
        return this.setLayers(Arrays.asList(layerConfigurations));
    }

    public JibContainerBuilder addLayer(LayerConfiguration layerConfiguration) {
        this.layerConfigurations.add(layerConfiguration);
        return this;
    }

    public JibContainerBuilder setEntrypoint(List<String> entrypoint) {
        this.entrypoint = ImmutableList.copyOf(entrypoint);
        return this;
    }

    public JibContainerBuilder setEntrypoint(String ... entrypoint) {
        return this.setEntrypoint(Arrays.asList(entrypoint));
    }

    public JibContainerBuilder setProgramArguments(List<String> programArguments) {
        this.programArguments = ImmutableList.copyOf(programArguments);
        return this;
    }

    public JibContainerBuilder setProgramArguments(String ... programArguments) {
        return this.setProgramArguments(Arrays.asList(programArguments));
    }

    public JibContainerBuilder setEnvironment(Map<String, String> environmentMap) {
        this.environment = new HashMap<String, String>(environmentMap);
        return this;
    }

    public JibContainerBuilder addEnvironmentVariable(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public JibContainerBuilder setExposedPorts(List<Port> ports) {
        this.ports = new ArrayList<Port>(ports);
        return this;
    }

    public JibContainerBuilder setExposedPorts(Port ... ports) {
        return this.setExposedPorts(Arrays.asList(ports));
    }

    public JibContainerBuilder addExposedPort(Port port) {
        this.ports.add(port);
        return this;
    }

    public JibContainerBuilder setLabels(Map<String, String> labelMap) {
        this.labels = new HashMap<String, String>(labelMap);
        return this;
    }

    public JibContainerBuilder addLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }
}

