/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class CacheMetadata {
    private final ImageLayers.Builder<CachedLayerWithMetadata> layersBuilder = ImageLayers.builder();

    CacheMetadata() {
    }

    synchronized ImageLayers<CachedLayerWithMetadata> getLayers() {
        return this.layersBuilder.build();
    }

    synchronized void addLayer(CachedLayerWithMetadata layer) throws LayerPropertyNotFoundException {
        this.layersBuilder.add(layer);
    }

    synchronized LayerFilter filterLayers() {
        return new LayerFilter(this.layersBuilder.build());
    }

    static class LayerFilter {
        private final ImageLayers<CachedLayerWithMetadata> layers;
        @Nullable
        private ImmutableList<Path> sourceFiles;

        private LayerFilter(ImageLayers<CachedLayerWithMetadata> layers) {
            this.layers = layers;
        }

        LayerFilter bySourceFiles(ImmutableList<Path> sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        ImageLayers<CachedLayerWithMetadata> filter() throws CacheMetadataCorruptedException {
            try {
                ImageLayers.Builder filteredLayersBuilder = ImageLayers.builder();
                for (CachedLayerWithMetadata layer : this.layers) {
                    if (this.sourceFiles != null) {
                        if (layer.getMetadata() == null) continue;
                        List<String> cachedLayerSourceFilePaths = layer.getMetadata().getSourceFiles();
                        if (cachedLayerSourceFilePaths != null) {
                            ArrayList<Path> cachedLayerSourceFiles = new ArrayList<Path>();
                            for (String sourceFile : cachedLayerSourceFilePaths) {
                                cachedLayerSourceFiles.add(Paths.get(sourceFile, new String[0]));
                            }
                            if (!cachedLayerSourceFiles.equals(this.sourceFiles)) continue;
                        }
                    }
                    filteredLayersBuilder.add(layer);
                }
                return filteredLayersBuilder.build();
            }
            catch (LayerPropertyNotFoundException ex) {
                throw new CacheMetadataCorruptedException(ex);
            }
        }
    }
}

