/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CacheMetadataTranslator;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;

public class Cache
implements Closeable {
    private final Path cacheDirectory;
    private final CacheMetadata cacheMetadata;

    public static Cache init(Path cacheDirectory) throws NotDirectoryException, CacheMetadataCorruptedException {
        if (!Files.isDirectory(cacheDirectory, new LinkOption[0])) {
            throw new NotDirectoryException("The cache can only write to a directory");
        }
        CacheMetadata cacheMetadata = Cache.loadCacheMetadata(cacheDirectory);
        return new Cache(cacheDirectory, cacheMetadata);
    }

    private static CacheMetadata loadCacheMetadata(Path cacheDirectory) throws CacheMetadataCorruptedException {
        Path cacheMetadataJsonFile = cacheDirectory.resolve("metadata.json");
        if (!Files.exists(cacheMetadataJsonFile, new LinkOption[0])) {
            return new CacheMetadata();
        }
        try {
            CacheMetadataTemplate cacheMetadataJson = JsonTemplateMapper.readJsonFromFile(cacheMetadataJsonFile, CacheMetadataTemplate.class);
            return CacheMetadataTranslator.fromTemplate(cacheMetadataJson, cacheDirectory);
        }
        catch (IOException ex) {
            throw new CacheMetadataCorruptedException(ex);
        }
    }

    private Cache(Path cacheDirectory, CacheMetadata cacheMetadata) {
        this.cacheDirectory = cacheDirectory;
        this.cacheMetadata = cacheMetadata;
    }

    @Override
    public void close() throws IOException {
        this.saveCacheMetadata(this.cacheDirectory);
    }

    void addLayerToMetadata(CachedLayer cachedLayer, @Nullable LayerMetadata layerMetadata) throws LayerPropertyNotFoundException {
        this.cacheMetadata.addLayer(new CachedLayerWithMetadata(cachedLayer, layerMetadata));
    }

    @VisibleForTesting
    Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    @VisibleForTesting
    CacheMetadata getMetadata() {
        return this.cacheMetadata;
    }

    private void saveCacheMetadata(Path cacheDirectory) throws IOException {
        Path cacheMetadataJsonFile = cacheDirectory.resolve("metadata.json");
        CacheMetadataTemplate cacheMetadataJson = CacheMetadataTranslator.toTemplate(this.cacheMetadata);
        try (BufferedOutputStream fileOutputStream = new BufferedOutputStream(Files.newOutputStream(cacheMetadataJsonFile, new OpenOption[0]));){
            JsonTemplateMapper.toBlob(cacheMetadataJson).writeTo(fileOutputStream);
        }
    }
}

