/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.deploy;

import com.google.cloud.tools.maven.deploy.AbstractDeployMojo;
import com.google.cloud.tools.maven.deploy.AppDeployer;
import com.google.cloud.tools.maven.deploy.ConfigProcessor;
import com.google.cloud.tools.maven.deploy.NoOpDeployer;
import com.google.cloud.tools.maven.stage.AppEngineWebXmlStager;
import com.google.cloud.tools.maven.stage.AppYamlStager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;

public interface Deployer {
    public void deploy() throws MojoExecutionException;

    public void deployAll() throws MojoExecutionException;

    public void deployCron() throws MojoExecutionException;

    public void deployDispatch() throws MojoExecutionException;

    public void deployDos() throws MojoExecutionException;

    public void deployIndex() throws MojoExecutionException;

    public void deployQueue() throws MojoExecutionException;

    public static class Factory {
        Deployer newDeployer(AbstractDeployMojo deployMojo) throws MojoExecutionException {
            if (!deployMojo.isAppEngineCompatiblePackaging()) {
                return new NoOpDeployer();
            }
            if (deployMojo.getArtifact() == null || !Files.exists(deployMojo.getArtifact(), new LinkOption[0])) {
                throw new MojoExecutionException("\nCould not determine appengine environment, did you package your application?\nRun 'mvn package appengine:deploy'");
            }
            ConfigProcessor configProcessor = new ConfigProcessor(deployMojo.getAppEngineFactory().newConfigReader());
            AppDeployer.ConfigBuilder configBuilder = new AppDeployer.ConfigBuilder(deployMojo, configProcessor);
            if (deployMojo.isAppEngineWebXmlBased()) {
                AppEngineWebXmlStager stager = AppEngineWebXmlStager.newAppEngineWebXmlStager(deployMojo);
                Path appengineDirectory = deployMojo.getStagingDirectory().resolve("WEB-INF").resolve("appengine-generated");
                return new AppDeployer(deployMojo, stager, configBuilder, appengineDirectory);
            }
            AppYamlStager stager = AppYamlStager.newAppYamlStager(deployMojo);
            Path appengineDirctory = deployMojo.getAppEngineDirectory() == null ? deployMojo.getMavenProject().getBasedir().toPath().resolve("src").resolve("main").resolve("appengine") : deployMojo.getAppEngineDirectory();
            return new AppDeployer(deployMojo, stager, configBuilder, appengineDirctory);
        }
    }
}

