/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.postgres;

import com.google.cloud.sql.core.SslSocketFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class SocketFactory
extends javax.net.SocketFactory {
    private static final Logger logger = Logger.getLogger(SocketFactory.class.getName());
    private static final String CLOUD_SQL_PREFIX = "/cloudsql/";
    private static final String POSTGRES_SUFFIX = "/.s.PGSQL.5432";
    private static final String INSTANCE_PROPERTY_KEY = "cloudSqlInstance";
    private static final String IP_TYPES_KEY = "ipTypes";
    private final String instanceName;
    private final List<String> ipTypes;

    public SocketFactory(Properties info) {
        this.instanceName = info.getProperty(INSTANCE_PROPERTY_KEY);
        Preconditions.checkArgument((this.instanceName != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property not set. Please specify this property in the JDBC URL or the connection Properties with value in form \"project:region:instance\"");
        this.ipTypes = SslSocketFactory.listIpTypes((String)info.getProperty(IP_TYPES_KEY, "PUBLIC,PRIVATE"));
    }

    @Deprecated
    public SocketFactory(String instanceName) {
        this(SocketFactory.createDefaultProperties(instanceName));
    }

    private static Properties createDefaultProperties(String instanceName) {
        Properties info = new Properties();
        info.setProperty(INSTANCE_PROPERTY_KEY, instanceName);
        return info;
    }

    @Override
    public Socket createSocket() throws IOException {
        String gaeEnv = System.getenv("GAE_ENV");
        String runEnv = System.getProperty("com.google.appengine.runtime.environment");
        Boolean forceUnixSocket = System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null;
        if (forceUnixSocket.booleanValue() || "standard".equals(gaeEnv) && "Production".equals(runEnv)) {
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via unix socket.", this.instanceName));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(CLOUD_SQL_PREFIX + this.instanceName + POSTGRES_SUFFIX));
            return UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        logger.info(String.format("Connecting to Cloud SQL instance [%s] via ssl socket.", this.instanceName));
        return SslSocketFactory.getInstance().create(this.instanceName, this.ipTypes);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }
}

