/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.core.publisher;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.spring.pubsub.core.PubSubDeliveryException;
import com.google.cloud.spring.pubsub.core.publisher.PubSubPublisherOperations;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConverter;
import com.google.cloud.spring.pubsub.support.converter.SimplePubSubMessageConverter;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class PubSubPublisherTemplate
implements PubSubPublisherOperations {
    private static final Log LOGGER = LogFactory.getLog(PubSubPublisherTemplate.class);
    private PubSubMessageConverter pubSubMessageConverter = new SimplePubSubMessageConverter();
    private final PublisherFactory publisherFactory;

    public PubSubPublisherTemplate(PublisherFactory publisherFactory) {
        Assert.notNull((Object)publisherFactory, (String)"The publisherFactory can't be null.");
        this.publisherFactory = publisherFactory;
    }

    public PubSubMessageConverter getMessageConverter() {
        return this.pubSubMessageConverter;
    }

    public void setMessageConverter(PubSubMessageConverter pubSubMessageConverter) {
        Assert.notNull((Object)pubSubMessageConverter, (String)"The pubSubMessageConverter can't be null.");
        this.pubSubMessageConverter = pubSubMessageConverter;
    }

    @Override
    public <T> CompletableFuture<String> publish(String topic, T payload, Map<String, String> headers) {
        return this.publish(topic, this.pubSubMessageConverter.toPubSubMessage(payload, headers));
    }

    @Override
    public <T> CompletableFuture<String> publish(String topic, T payload) {
        return this.publish(topic, payload, null);
    }

    @Override
    public CompletableFuture<String> publish(final String topic, final PubsubMessage pubsubMessage) {
        Assert.hasText((String)topic, (String)"The topic can't be null or empty.");
        Assert.notNull((Object)pubsubMessage, (String)"The pubsubMessage can't be null.");
        ApiFuture publishFuture = this.publisherFactory.createPublisher(topic).publish(pubsubMessage);
        final CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        ApiFutures.addCallback((ApiFuture)publishFuture, (ApiFutureCallback)new ApiFutureCallback<String>(){

            public void onFailure(Throwable throwable) {
                String errorMessage = "Publishing to " + topic + " topic failed.";
                LOGGER.warn((Object)errorMessage, throwable);
                PubSubDeliveryException pubSubDeliveryException = new PubSubDeliveryException(pubsubMessage, errorMessage, throwable);
                completableFuture.completeExceptionally((Throwable)((Object)pubSubDeliveryException));
            }

            public void onSuccess(String result) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Publishing to " + topic + " was successful. Message ID: " + result));
                }
                completableFuture.complete(result);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completableFuture;
    }

    public PublisherFactory getPublisherFactory() {
        return this.publisherFactory;
    }
}

