/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support;

import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;

public class CachingPublisherFactory
implements PublisherFactory {
    private final ConcurrentHashMap<String, Publisher> publishers = new ConcurrentHashMap();
    private final PublisherFactory delegate;

    public CachingPublisherFactory(PublisherFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Publisher createPublisher(String topic) {
        return this.publishers.computeIfAbsent(topic, this.delegate::createPublisher);
    }

    public PublisherFactory getDelegate() {
        return this.delegate;
    }

    @PreDestroy
    public void shutdown() {
        this.publishers.forEachValue(1L, Publisher::shutdown);
    }
}

