/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.storage;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.spring.autoconfigure.core.GcpProperties;
import com.google.cloud.spring.autoconfigure.storage.GcpStorageProperties;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.storage.GoogleStorageProtocolResolver;
import com.google.cloud.spring.storage.GoogleStorageProtocolResolverSettings;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ConditionalOnClass(value={GoogleStorageProtocolResolverSettings.class, Storage.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.storage.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GcpProperties.class, GcpStorageProperties.class})
@Import(value={GoogleStorageProtocolResolver.class})
public class GcpStorageAutoConfiguration {
    private final GcpProjectIdProvider gcpProjectIdProvider;
    private final CredentialsProvider credentialsProvider;
    private final String universeDomain;
    private final String host;

    public GcpStorageAutoConfiguration(GcpProjectIdProvider coreProjectIdProvider, CredentialsProvider credentialsProvider, GcpStorageProperties gcpStorageProperties) throws IOException {
        this.gcpProjectIdProvider = gcpStorageProperties.getProjectId() != null ? gcpStorageProperties::getProjectId : coreProjectIdProvider;
        this.credentialsProvider = gcpStorageProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpStorageProperties) : credentialsProvider;
        this.universeDomain = gcpStorageProperties.getUniverseDomain();
        this.host = gcpStorageProperties.getHost();
    }

    @Bean
    @ConditionalOnMissingBean
    public Storage storage() throws IOException {
        StorageOptions.Builder storageOptionsBuilder = (StorageOptions.Builder)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpStorageAutoConfiguration.class))).setProjectId(this.gcpProjectIdProvider.getProjectId())).setCredentials(this.credentialsProvider.getCredentials());
        if (this.universeDomain != null) {
            storageOptionsBuilder.setUniverseDomain(this.universeDomain);
        }
        if (this.host != null) {
            storageOptionsBuilder.setHost(this.verifyAndFetchHost(this.host));
        }
        return (Storage)storageOptionsBuilder.build().getService();
    }

    private String verifyAndFetchHost(String host) {
        URL url;
        try {
            url = new URL(host);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid host format: " + host + ". Please verify that the specified host follows the 'https://${service}.${universeDomain}/' format");
        }
        return url.getProtocol() + "://" + url.getHost() + "/";
    }
}

