/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

public enum DatabaseType {
    MYSQL("com.mysql.cj.jdbc.Driver", "jdbc:mysql://%s/%s?socketFactory=com.google.cloud.sql.mysql.SocketFactory", "r2dbc:gcp:mysql://%s/%s", "root"),
    POSTGRESQL("org.postgresql.Driver", "jdbc:postgresql://%s/%s?socketFactory=com.google.cloud.sql.postgres.SocketFactory", "r2dbc:gcp:postgres://%s/%s", "postgres");

    private final String jdbcDriverName;
    private final String jdbcUrlTemplate;
    private final String r2dbcUrlTemplate;
    private final String defaultUsername;

    private DatabaseType(String jdbcDriverName, String jdbcUrlTemplate, String r2dbcUrlTemplate, String defaultUsername) {
        this.jdbcDriverName = jdbcDriverName;
        this.jdbcUrlTemplate = jdbcUrlTemplate;
        this.r2dbcUrlTemplate = r2dbcUrlTemplate;
        this.defaultUsername = defaultUsername;
    }

    public String getJdbcDriverName() {
        return this.jdbcDriverName;
    }

    public String getJdbcUrlTemplate() {
        return this.jdbcUrlTemplate;
    }

    public String getR2dbcUrlTemplate() {
        return this.r2dbcUrlTemplate;
    }

    public String getDefaultUsername() {
        return this.defaultUsername;
    }
}

