/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.metrics;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.spring.autoconfigure.metrics.GcpMetricsProperties;
import com.google.cloud.spring.autoconfigure.metrics.GcpStackdriverPropertiesConfigAdapter;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import io.micrometer.core.instrument.Clock;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverMeterRegistry;
import java.io.IOException;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.stackdriver.StackdriverMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.stackdriver.StackdriverProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={StackdriverMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnClass(value={StackdriverMeterRegistry.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnEnabledMetricsExport(value="stackdriver")
@EnableConfigurationProperties(value={GcpMetricsProperties.class, StackdriverProperties.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.metrics.enabled"}, matchIfMissing=true, havingValue="true")
public class GcpStackdriverMetricsAutoConfiguration {
    private final StackdriverProperties stackdriverProperties;
    private final String projectId;
    private final CredentialsProvider credentialsProvider;

    public GcpStackdriverMetricsAutoConfiguration(GcpMetricsProperties gcpMetricsProperties, StackdriverProperties stackdriverProperties, GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.stackdriverProperties = stackdriverProperties;
        this.projectId = gcpMetricsProperties.getProjectId() != null ? gcpMetricsProperties.getProjectId() : gcpProjectIdProvider.getProjectId();
        this.credentialsProvider = gcpMetricsProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpMetricsProperties) : credentialsProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public StackdriverConfig stackdriverConfig() {
        return new GcpStackdriverPropertiesConfigAdapter(this.stackdriverProperties, this.projectId, this.credentialsProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricServiceSettings metricServiceSettings() throws IOException {
        return ((MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpStackdriverMetricsAutoConfiguration.class))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public StackdriverMeterRegistry stackdriverMeterRegistry(StackdriverConfig stackdriverConfig, Clock clock, MetricServiceSettings metricServiceSettings) {
        return StackdriverMeterRegistry.builder((StackdriverConfig)stackdriverConfig).clock(clock).metricServiceSettings(() -> metricServiceSettings).build();
    }
}

