/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.config;

import com.google.api.gax.core.CredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.spring.autoconfigure.config.GcpConfigProperties;
import com.google.cloud.spring.autoconfigure.config.GoogleConfigEnvironment;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class GoogleConfigPropertySourceLocator
implements PropertySourceLocator {
    private static final String RUNTIMECONFIG_API_ROOT = "https://runtimeconfig.googleapis.com/v1beta1/";
    private static final String ALL_VARIABLES_PATH = "projects/{project}/configs/{name}_{profile}/variables?returnValues=true";
    private static final String PROPERTY_SOURCE_NAME = "spring-cloud-gcp";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private String projectId;
    private Credentials credentials;
    private String name;
    private String profile;
    private int timeout;
    private boolean enabled;

    public GoogleConfigPropertySourceLocator(GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider, GcpConfigProperties gcpConfigProperties) throws IOException {
        Assert.notNull((Object)gcpConfigProperties, (String)"Google Config properties must not be null");
        if (gcpConfigProperties.isEnabled()) {
            Assert.notNull((Object)credentialsProvider, (String)"Credentials provider cannot be null");
            Assert.notNull((Object)projectIdProvider, (String)"Project ID provider cannot be null");
            this.credentials = gcpConfigProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpConfigProperties).getCredentials() : credentialsProvider.getCredentials();
            this.projectId = gcpConfigProperties.getProjectId() != null ? gcpConfigProperties.getProjectId() : projectIdProvider.getProjectId();
            Assert.notNull((Object)this.credentials, (String)"Credentials must not be null");
            Assert.notNull((Object)this.projectId, (String)"Project ID must not be null");
            this.timeout = gcpConfigProperties.getTimeoutMillis();
            this.name = gcpConfigProperties.getName();
            this.profile = gcpConfigProperties.getProfile();
            this.enabled = gcpConfigProperties.isEnabled();
            Assert.notNull((Object)this.name, (String)"Config name must not be null");
            Assert.notNull((Object)this.profile, (String)"Config profile must not be null");
        }
    }

    private HttpEntity<Void> getAuthorizedRequest() throws IOException {
        HttpHeaders headers = new HttpHeaders();
        Map credentialHeaders = this.credentials.getRequestMetadata();
        Assert.notNull((Object)credentialHeaders, (String)"No valid credential header(s) found");
        credentialHeaders.forEach((key, values) -> values.forEach(value -> headers.add(key, value)));
        Assert.isTrue((boolean)headers.containsKey((Object)AUTHORIZATION_HEADER), (String)"Authorization header required");
        new UserAgentHeaderProvider(this.getClass()).getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        return new HttpEntity((MultiValueMap)headers);
    }

    GoogleConfigEnvironment getRemoteEnvironment() throws IOException, HttpClientErrorException {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setReadTimeout(this.timeout);
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HttpEntity<Void> requestEntity = this.getAuthorizedRequest();
        ResponseEntity response = template.exchange("https://runtimeconfig.googleapis.com/v1beta1/projects/{project}/configs/{name}_{profile}/variables?returnValues=true", HttpMethod.GET, requestEntity, GoogleConfigEnvironment.class, new Object[]{this.projectId, this.name, this.profile});
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new HttpClientErrorException(response.getStatusCode(), "Invalid response from Runtime Configurator API");
        }
        return (GoogleConfigEnvironment)response.getBody();
    }

    public PropertySource<?> locate(Environment environment) {
        Map<String, Object> config;
        if (!this.enabled) {
            return new MapPropertySource(PROPERTY_SOURCE_NAME, Collections.emptyMap());
        }
        try {
            GoogleConfigEnvironment googleConfigEnvironment = this.getRemoteEnvironment();
            Assert.notNull((Object)googleConfigEnvironment, (String)"Configuration not in expected format.");
            config = googleConfigEnvironment.getConfig();
        }
        catch (Exception ex) {
            String message = String.format("Error loading configuration for %s/%s_%s", this.projectId, this.name, this.profile);
            throw new RuntimeException(message, ex);
        }
        return new MapPropertySource(PROPERTY_SOURCE_NAME, config);
    }

    public String getProjectId() {
        return this.projectId;
    }
}

