/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.bigquery;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.spring.autoconfigure.bigquery.GcpBigQueryProperties;
import com.google.cloud.spring.autoconfigure.core.GcpContextAutoConfiguration;
import com.google.cloud.spring.bigquery.core.BigQueryTemplate;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.bigquery.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={BigQuery.class, BigQueryTemplate.class})
@EnableConfigurationProperties(value={GcpBigQueryProperties.class})
public class GcpBigQueryAutoConfiguration {
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private final String datasetName;
    private int jsonWriterBatchSize;
    private int threadPoolSize;

    GcpBigQueryAutoConfiguration(GcpBigQueryProperties gcpBigQueryProperties, GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.projectId = gcpBigQueryProperties.getProjectId() != null ? gcpBigQueryProperties.getProjectId() : projectIdProvider.getProjectId();
        this.credentialsProvider = gcpBigQueryProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpBigQueryProperties) : credentialsProvider;
        this.datasetName = gcpBigQueryProperties.getDatasetName();
        this.jsonWriterBatchSize = gcpBigQueryProperties.getJsonWriterBatchSize();
        this.threadPoolSize = this.getThreadPoolSize(gcpBigQueryProperties.getThreadPoolSize());
    }

    private int getThreadPoolSize(int threadPoolSize) {
        int defaultThreadPoolSize = 4;
        int maxThreadPoolSize = 100;
        return threadPoolSize <= 0 || threadPoolSize > maxThreadPoolSize ? defaultThreadPoolSize : threadPoolSize;
    }

    @Bean
    @ConditionalOnMissingBean
    public BigQuery bigQuery() throws IOException {
        BigQueryOptions bigQueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(this.projectId)).setCredentials(this.credentialsProvider.getCredentials())).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpBigQueryAutoConfiguration.class))).build();
        return (BigQuery)bigQueryOptions.getService();
    }

    @Bean
    @ConditionalOnMissingBean
    public BigQueryWriteClient bigQueryWriteClient() throws IOException {
        BigQueryWriteSettings bigQueryWriteSettings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setQuotaProjectId(this.projectId)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpBigQueryAutoConfiguration.class))).build();
        return BigQueryWriteClient.create((BigQueryWriteSettings)bigQueryWriteSettings);
    }

    @Bean
    @ConditionalOnMissingBean(name={"bigQueryThreadPoolTaskScheduler"})
    public ThreadPoolTaskScheduler bigQueryThreadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.threadPoolSize);
        scheduler.setThreadNamePrefix("gcp-bigquery");
        scheduler.setDaemon(true);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean
    public BigQueryTemplate bigQueryTemplate(BigQuery bigQuery, BigQueryWriteClient bigQueryWriteClient, @Qualifier(value="bigQueryThreadPoolTaskScheduler") ThreadPoolTaskScheduler bigQueryThreadPoolTaskScheduler) {
        HashMap<String, Object> bqInitSettings = new HashMap<String, Object>();
        bqInitSettings.put("DATASET_NAME", this.datasetName);
        bqInitSettings.put("JSON_WRITER_BATCH_SIZE", this.jsonWriterBatchSize);
        return new BigQueryTemplate(bigQuery, bigQueryWriteClient, bqInitSettings, (TaskScheduler)bigQueryThreadPoolTaskScheduler);
    }
}

