/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.resource;

import com.google.auto.value.AutoValue;
import com.google.cloud.opentelemetry.resource.AutoValue_ResourceTranslator_AttributeMapping;
import com.google.cloud.opentelemetry.resource.GcpResource;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ResourceTranslator {
    private static List<AttributeMapping> GCE_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("zone", ResourceAttributes.CLOUD_AVAILABILITY_ZONE), AttributeMapping.create("instance_id", ResourceAttributes.HOST_ID));
    private static List<AttributeMapping> K8S_CONTAINER_LABELS = Arrays.asList(AttributeMapping.create("location", ResourceAttributes.CLOUD_AVAILABILITY_ZONE), AttributeMapping.create("cluster_name", ResourceAttributes.K8S_CLUSTER_NAME), AttributeMapping.create("namespace_name", ResourceAttributes.K8S_NAMESPACE_NAME), AttributeMapping.create("container_name", ResourceAttributes.K8S_CONTAINER_NAME), AttributeMapping.create("pod_name", ResourceAttributes.K8S_POD_NAME));
    private static List<AttributeMapping> AWS_EC2_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("instance_id", ResourceAttributes.HOST_ID), AttributeMapping.create("region", ResourceAttributes.CLOUD_AVAILABILITY_ZONE), AttributeMapping.create("aws_account", ResourceAttributes.CLOUD_ACCOUNT_ID));
    private static List<AttributeMapping> GENERIC_TASK_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, ResourceAttributes.CLOUD_REGION), "global"), AttributeMapping.create("namespace", ResourceAttributes.SERVICE_NAMESPACE, ""), AttributeMapping.create("job", ResourceAttributes.SERVICE_NAME, ""), AttributeMapping.create("task_id", ResourceAttributes.SERVICE_INSTANCE_ID, ""));

    private ResourceTranslator() {
    }

    public static GcpResource mapResource(Resource resource) {
        String platform = (String)resource.getAttribute(ResourceAttributes.CLOUD_PLATFORM);
        if (platform == null) {
            return ResourceTranslator.mapBase(resource, "generic_task", GENERIC_TASK_LABELS);
        }
        switch (platform) {
            case "gcp_compute_engine": {
                return ResourceTranslator.mapBase(resource, "gce_instance", GCE_INSTANCE_LABELS);
            }
            case "gcp_kubernetes_engine": {
                return ResourceTranslator.mapBase(resource, "k8s_container", K8S_CONTAINER_LABELS);
            }
            case "aws_ec2": {
                return ResourceTranslator.mapBase(resource, "aws_ec2_instance", AWS_EC2_INSTANCE_LABELS);
            }
        }
        return ResourceTranslator.mapBase(resource, "generic_task", GENERIC_TASK_LABELS);
    }

    private static GcpResource mapBase(Resource resource, String mrType, List<AttributeMapping> mappings) {
        GcpResource.Builder mr = GcpResource.builder();
        mr.setResourceType(mrType);
        for (AttributeMapping mapping : mappings) {
            mapping.fill(resource, mr);
        }
        return mr.build();
    }

    @AutoValue
    public static abstract class AttributeMapping {
        public abstract String getLabelName();

        public abstract List<AttributeKey<?>> getOtelKeys();

        public abstract Optional<String> fallbackLiteral();

        public void fill(Resource resource, GcpResource.Builder builder) {
            for (AttributeKey<?> key : this.getOtelKeys()) {
                Object value2 = resource.getAttribute(key);
                if (value2 == null) continue;
                builder.addResourceLabels(this.getLabelName(), value2.toString());
                return;
            }
            this.fallbackLiteral().ifPresent(value -> builder.addResourceLabels(this.getLabelName(), (String)value));
        }

        public static AttributeMapping create(String labelName, AttributeKey<?> otelKey) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, Collections.singletonList(otelKey), Optional.empty());
        }

        public static AttributeMapping create(String labelName, AttributeKey<?> otelKey, String fallbackLiteral) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, Collections.singletonList(otelKey), Optional.of(fallbackLiteral));
        }

        public static AttributeMapping create(String labelName, List<AttributeKey<?>> otelKeys) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, otelKeys, Optional.empty());
        }

        public static AttributeMapping create(String labelName, List<AttributeKey<?>> otelKeys, String fallbackLiteral) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, otelKeys, Optional.of(fallbackLiteral));
        }
    }
}

