/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.example.trace;

import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.opentelemetry.trace.TraceExporter;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.time.Duration;
import java.util.Random;

public class TraceExporterExample {
    private static final Tracer tracer = GlobalOpenTelemetry.getTracer((String)"io.opentelemetry.example.TraceExporterExample");
    private static final Random random = new Random();

    private static void setupTraceExporter() {
        TraceConfiguration configuration = TraceConfiguration.builder().setDeadline(Duration.ofMillis(30000L)).build();
        try {
            TraceExporter traceExporter = TraceExporter.createWithConfiguration((TraceConfiguration)configuration);
            OpenTelemetrySdk.getGlobalTracerManagement().addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)traceExporter).build());
        }
        catch (IOException e) {
            System.out.println("Uncaught Exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void myUseCase(String description) {
        Span span = tracer.spanBuilder(description).startSpan();
        try (Scope scope = span.makeCurrent();){
            span.addEvent("Event A");
            for (int i = 0; i < 3; ++i) {
                String work = String.format("%s - Work #%d", description, i + 1);
                TraceExporterExample.doWork(work);
            }
            span.addEvent("Event B");
        }
        finally {
            span.end();
        }
    }

    private static void doWork(String description) {
        Span span = tracer.spanBuilder(description).startSpan();
        try (Scope scope = span.makeCurrent();){
            Thread.sleep(100 + random.nextInt(5) * 100);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            span.end();
        }
    }

    public static void main(String[] args) {
        TraceExporterExample.setupTraceExporter();
        TraceExporterExample.myUseCase("One");
        TraceExporterExample.myUseCase("Two");
        OpenTelemetrySdk.getGlobalTracerManagement().shutdown();
    }
}

