/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.executions.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.executions.v1.CancelExecutionRequest;
import com.google.cloud.workflows.executions.v1.CreateExecutionRequest;
import com.google.cloud.workflows.executions.v1.Execution;
import com.google.cloud.workflows.executions.v1.ExecutionsClient;
import com.google.cloud.workflows.executions.v1.GetExecutionRequest;
import com.google.cloud.workflows.executions.v1.ListExecutionsRequest;
import com.google.cloud.workflows.executions.v1.ListExecutionsResponse;
import com.google.cloud.workflows.executions.v1.stub.ExecutionsStub;
import com.google.cloud.workflows.executions.v1.stub.GrpcExecutionsStub;
import com.google.cloud.workflows.executions.v1.stub.HttpJsonExecutionsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ExecutionsStubSettings
extends StubSettings<ExecutionsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings;
    private final UnaryCallSettings<CreateExecutionRequest, Execution> createExecutionSettings;
    private final UnaryCallSettings<GetExecutionRequest, Execution> getExecutionSettings;
    private final UnaryCallSettings<CancelExecutionRequest, Execution> cancelExecutionSettings;
    private static final PagedListDescriptor<ListExecutionsRequest, ListExecutionsResponse, Execution> LIST_EXECUTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListExecutionsRequest, ListExecutionsResponse, Execution>(){

        public String emptyToken() {
            return "";
        }

        public ListExecutionsRequest injectToken(ListExecutionsRequest payload, String token) {
            return ListExecutionsRequest.newBuilder((ListExecutionsRequest)payload).setPageToken(token).build();
        }

        public ListExecutionsRequest injectPageSize(ListExecutionsRequest payload, int pageSize) {
            return ListExecutionsRequest.newBuilder((ListExecutionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExecutionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExecutionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Execution> extractResources(ListExecutionsResponse payload) {
            return payload.getExecutionsList() == null ? ImmutableList.of() : payload.getExecutionsList();
        }
    };
    private static final PagedListResponseFactory<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> LIST_EXECUTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse>(){

        public ApiFuture<ExecutionsClient.ListExecutionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> callable, ListExecutionsRequest request, ApiCallContext context, ApiFuture<ListExecutionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXECUTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExecutionsClient.ListExecutionsPagedResponse.createAsync((PageContext<ListExecutionsRequest, ListExecutionsResponse, Execution>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings() {
        return this.listExecutionsSettings;
    }

    public UnaryCallSettings<CreateExecutionRequest, Execution> createExecutionSettings() {
        return this.createExecutionSettings;
    }

    public UnaryCallSettings<GetExecutionRequest, Execution> getExecutionSettings() {
        return this.getExecutionSettings;
    }

    public UnaryCallSettings<CancelExecutionRequest, Execution> cancelExecutionSettings() {
        return this.cancelExecutionSettings;
    }

    public ExecutionsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcExecutionsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonExecutionsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ExecutionsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "workflowexecutions";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "workflowexecutions.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "workflowexecutions.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExecutionsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExecutionsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExecutionsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ExecutionsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExecutionsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listExecutionsSettings = settingsBuilder.listExecutionsSettings().build();
        this.createExecutionSettings = settingsBuilder.createExecutionSettings().build();
        this.getExecutionSettings = settingsBuilder.getExecutionSettings().build();
        this.cancelExecutionSettings = settingsBuilder.cancelExecutionSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExecutionsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings;
        private final UnaryCallSettings.Builder<CreateExecutionRequest, Execution> createExecutionSettings;
        private final UnaryCallSettings.Builder<GetExecutionRequest, Execution> getExecutionSettings;
        private final UnaryCallSettings.Builder<CancelExecutionRequest, Execution> cancelExecutionSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listExecutionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXECUTIONS_PAGE_STR_FACT);
            this.createExecutionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getExecutionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelExecutionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listExecutionsSettings, this.createExecutionSettings, this.getExecutionSettings, this.cancelExecutionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ExecutionsStubSettings settings) {
            super((StubSettings)settings);
            this.listExecutionsSettings = settings.listExecutionsSettings.toBuilder();
            this.createExecutionSettings = settings.createExecutionSettings.toBuilder();
            this.getExecutionSettings = settings.getExecutionSettings.toBuilder();
            this.cancelExecutionSettings = settings.cancelExecutionSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listExecutionsSettings, this.createExecutionSettings, this.getExecutionSettings, this.cancelExecutionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExecutionsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExecutionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExecutionsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ExecutionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ExecutionsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ExecutionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExecutionsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ExecutionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listExecutionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createExecutionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getExecutionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.cancelExecutionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListExecutionsRequest, ListExecutionsResponse, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsSettings() {
            return this.listExecutionsSettings;
        }

        public UnaryCallSettings.Builder<CreateExecutionRequest, Execution> createExecutionSettings() {
            return this.createExecutionSettings;
        }

        public UnaryCallSettings.Builder<GetExecutionRequest, Execution> getExecutionSettings() {
            return this.getExecutionSettings;
        }

        public UnaryCallSettings.Builder<CancelExecutionRequest, Execution> cancelExecutionSettings() {
            return this.cancelExecutionSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ExecutionsStubSettings.getDefaultEndpoint();
        }

        public ExecutionsStubSettings build() throws IOException {
            return new ExecutionsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

