/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.Analysis;
import com.google.cloud.visionai.v1.BatchRunProcessRequest;
import com.google.cloud.visionai.v1.BatchRunProcessResponse;
import com.google.cloud.visionai.v1.CreateAnalysisRequest;
import com.google.cloud.visionai.v1.CreateOperatorRequest;
import com.google.cloud.visionai.v1.CreateProcessRequest;
import com.google.cloud.visionai.v1.DeleteAnalysisRequest;
import com.google.cloud.visionai.v1.DeleteOperatorRequest;
import com.google.cloud.visionai.v1.DeleteProcessRequest;
import com.google.cloud.visionai.v1.GetAnalysisRequest;
import com.google.cloud.visionai.v1.GetOperatorRequest;
import com.google.cloud.visionai.v1.GetProcessRequest;
import com.google.cloud.visionai.v1.ListAnalysesRequest;
import com.google.cloud.visionai.v1.ListAnalysesResponse;
import com.google.cloud.visionai.v1.ListOperatorsRequest;
import com.google.cloud.visionai.v1.ListOperatorsResponse;
import com.google.cloud.visionai.v1.ListProcessesRequest;
import com.google.cloud.visionai.v1.ListProcessesResponse;
import com.google.cloud.visionai.v1.ListPublicOperatorsRequest;
import com.google.cloud.visionai.v1.ListPublicOperatorsResponse;
import com.google.cloud.visionai.v1.LiveVideoAnalyticsClient;
import com.google.cloud.visionai.v1.OperationMetadata;
import com.google.cloud.visionai.v1.Operator;
import com.google.cloud.visionai.v1.Process;
import com.google.cloud.visionai.v1.ResolveOperatorInfoRequest;
import com.google.cloud.visionai.v1.ResolveOperatorInfoResponse;
import com.google.cloud.visionai.v1.UpdateAnalysisRequest;
import com.google.cloud.visionai.v1.UpdateOperatorRequest;
import com.google.cloud.visionai.v1.UpdateProcessRequest;
import com.google.cloud.visionai.v1.stub.GrpcLiveVideoAnalyticsStub;
import com.google.cloud.visionai.v1.stub.HttpJsonLiveVideoAnalyticsStub;
import com.google.cloud.visionai.v1.stub.LiveVideoAnalyticsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class LiveVideoAnalyticsStubSettings
extends StubSettings<LiveVideoAnalyticsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListPublicOperatorsRequest, ListPublicOperatorsResponse, LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse> listPublicOperatorsSettings;
    private final UnaryCallSettings<ResolveOperatorInfoRequest, ResolveOperatorInfoResponse> resolveOperatorInfoSettings;
    private final PagedCallSettings<ListOperatorsRequest, ListOperatorsResponse, LiveVideoAnalyticsClient.ListOperatorsPagedResponse> listOperatorsSettings;
    private final UnaryCallSettings<GetOperatorRequest, Operator> getOperatorSettings;
    private final UnaryCallSettings<CreateOperatorRequest, Operation> createOperatorSettings;
    private final OperationCallSettings<CreateOperatorRequest, Operator, OperationMetadata> createOperatorOperationSettings;
    private final UnaryCallSettings<UpdateOperatorRequest, Operation> updateOperatorSettings;
    private final OperationCallSettings<UpdateOperatorRequest, Operator, OperationMetadata> updateOperatorOperationSettings;
    private final UnaryCallSettings<DeleteOperatorRequest, Operation> deleteOperatorSettings;
    private final OperationCallSettings<DeleteOperatorRequest, Empty, OperationMetadata> deleteOperatorOperationSettings;
    private final PagedCallSettings<ListAnalysesRequest, ListAnalysesResponse, LiveVideoAnalyticsClient.ListAnalysesPagedResponse> listAnalysesSettings;
    private final UnaryCallSettings<GetAnalysisRequest, Analysis> getAnalysisSettings;
    private final UnaryCallSettings<CreateAnalysisRequest, Operation> createAnalysisSettings;
    private final OperationCallSettings<CreateAnalysisRequest, Analysis, OperationMetadata> createAnalysisOperationSettings;
    private final UnaryCallSettings<UpdateAnalysisRequest, Operation> updateAnalysisSettings;
    private final OperationCallSettings<UpdateAnalysisRequest, Analysis, OperationMetadata> updateAnalysisOperationSettings;
    private final UnaryCallSettings<DeleteAnalysisRequest, Operation> deleteAnalysisSettings;
    private final OperationCallSettings<DeleteAnalysisRequest, Empty, OperationMetadata> deleteAnalysisOperationSettings;
    private final PagedCallSettings<ListProcessesRequest, ListProcessesResponse, LiveVideoAnalyticsClient.ListProcessesPagedResponse> listProcessesSettings;
    private final UnaryCallSettings<GetProcessRequest, Process> getProcessSettings;
    private final UnaryCallSettings<CreateProcessRequest, Operation> createProcessSettings;
    private final OperationCallSettings<CreateProcessRequest, Process, OperationMetadata> createProcessOperationSettings;
    private final UnaryCallSettings<UpdateProcessRequest, Operation> updateProcessSettings;
    private final OperationCallSettings<UpdateProcessRequest, Process, OperationMetadata> updateProcessOperationSettings;
    private final UnaryCallSettings<DeleteProcessRequest, Operation> deleteProcessSettings;
    private final OperationCallSettings<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings;
    private final UnaryCallSettings<BatchRunProcessRequest, Operation> batchRunProcessSettings;
    private final OperationCallSettings<BatchRunProcessRequest, BatchRunProcessResponse, OperationMetadata> batchRunProcessOperationSettings;
    private static final PagedListDescriptor<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator> LIST_PUBLIC_OPERATORS_PAGE_STR_DESC = new PagedListDescriptor<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator>(){

        public String emptyToken() {
            return "";
        }

        public ListPublicOperatorsRequest injectToken(ListPublicOperatorsRequest payload, String token) {
            return ListPublicOperatorsRequest.newBuilder((ListPublicOperatorsRequest)payload).setPageToken(token).build();
        }

        public ListPublicOperatorsRequest injectPageSize(ListPublicOperatorsRequest payload, int pageSize) {
            return ListPublicOperatorsRequest.newBuilder((ListPublicOperatorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPublicOperatorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPublicOperatorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operator> extractResources(ListPublicOperatorsResponse payload) {
            return payload.getOperatorsList();
        }
    };
    private static final PagedListDescriptor<ListOperatorsRequest, ListOperatorsResponse, Operator> LIST_OPERATORS_PAGE_STR_DESC = new PagedListDescriptor<ListOperatorsRequest, ListOperatorsResponse, Operator>(){

        public String emptyToken() {
            return "";
        }

        public ListOperatorsRequest injectToken(ListOperatorsRequest payload, String token) {
            return ListOperatorsRequest.newBuilder((ListOperatorsRequest)payload).setPageToken(token).build();
        }

        public ListOperatorsRequest injectPageSize(ListOperatorsRequest payload, int pageSize) {
            return ListOperatorsRequest.newBuilder((ListOperatorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOperatorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOperatorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operator> extractResources(ListOperatorsResponse payload) {
            return payload.getOperatorsList();
        }
    };
    private static final PagedListDescriptor<ListAnalysesRequest, ListAnalysesResponse, Analysis> LIST_ANALYSES_PAGE_STR_DESC = new PagedListDescriptor<ListAnalysesRequest, ListAnalysesResponse, Analysis>(){

        public String emptyToken() {
            return "";
        }

        public ListAnalysesRequest injectToken(ListAnalysesRequest payload, String token) {
            return ListAnalysesRequest.newBuilder((ListAnalysesRequest)payload).setPageToken(token).build();
        }

        public ListAnalysesRequest injectPageSize(ListAnalysesRequest payload, int pageSize) {
            return ListAnalysesRequest.newBuilder((ListAnalysesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAnalysesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAnalysesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Analysis> extractResources(ListAnalysesResponse payload) {
            return payload.getAnalysesList();
        }
    };
    private static final PagedListDescriptor<ListProcessesRequest, ListProcessesResponse, Process> LIST_PROCESSES_PAGE_STR_DESC = new PagedListDescriptor<ListProcessesRequest, ListProcessesResponse, Process>(){

        public String emptyToken() {
            return "";
        }

        public ListProcessesRequest injectToken(ListProcessesRequest payload, String token) {
            return ListProcessesRequest.newBuilder((ListProcessesRequest)payload).setPageToken(token).build();
        }

        public ListProcessesRequest injectPageSize(ListProcessesRequest payload, int pageSize) {
            return ListProcessesRequest.newBuilder((ListProcessesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProcessesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProcessesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Process> extractResources(ListProcessesResponse payload) {
            return payload.getProcessesList();
        }
    };
    private static final PagedListResponseFactory<ListPublicOperatorsRequest, ListPublicOperatorsResponse, LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse> LIST_PUBLIC_OPERATORS_PAGE_STR_FACT = new PagedListResponseFactory<ListPublicOperatorsRequest, ListPublicOperatorsResponse, LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse>(){

        public ApiFuture<LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPublicOperatorsRequest, ListPublicOperatorsResponse> callable, ListPublicOperatorsRequest request, ApiCallContext context, ApiFuture<ListPublicOperatorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PUBLIC_OPERATORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse.createAsync((PageContext<ListPublicOperatorsRequest, ListPublicOperatorsResponse, Operator>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOperatorsRequest, ListOperatorsResponse, LiveVideoAnalyticsClient.ListOperatorsPagedResponse> LIST_OPERATORS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperatorsRequest, ListOperatorsResponse, LiveVideoAnalyticsClient.ListOperatorsPagedResponse>(){

        public ApiFuture<LiveVideoAnalyticsClient.ListOperatorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOperatorsRequest, ListOperatorsResponse> callable, ListOperatorsRequest request, ApiCallContext context, ApiFuture<ListOperatorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_OPERATORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LiveVideoAnalyticsClient.ListOperatorsPagedResponse.createAsync((PageContext<ListOperatorsRequest, ListOperatorsResponse, Operator>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAnalysesRequest, ListAnalysesResponse, LiveVideoAnalyticsClient.ListAnalysesPagedResponse> LIST_ANALYSES_PAGE_STR_FACT = new PagedListResponseFactory<ListAnalysesRequest, ListAnalysesResponse, LiveVideoAnalyticsClient.ListAnalysesPagedResponse>(){

        public ApiFuture<LiveVideoAnalyticsClient.ListAnalysesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAnalysesRequest, ListAnalysesResponse> callable, ListAnalysesRequest request, ApiCallContext context, ApiFuture<ListAnalysesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ANALYSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LiveVideoAnalyticsClient.ListAnalysesPagedResponse.createAsync((PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProcessesRequest, ListProcessesResponse, LiveVideoAnalyticsClient.ListProcessesPagedResponse> LIST_PROCESSES_PAGE_STR_FACT = new PagedListResponseFactory<ListProcessesRequest, ListProcessesResponse, LiveVideoAnalyticsClient.ListProcessesPagedResponse>(){

        public ApiFuture<LiveVideoAnalyticsClient.ListProcessesPagedResponse> getFuturePagedResponse(UnaryCallable<ListProcessesRequest, ListProcessesResponse> callable, ListProcessesRequest request, ApiCallContext context, ApiFuture<ListProcessesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROCESSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LiveVideoAnalyticsClient.ListProcessesPagedResponse.createAsync((PageContext<ListProcessesRequest, ListProcessesResponse, Process>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListPublicOperatorsRequest, ListPublicOperatorsResponse, LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse> listPublicOperatorsSettings() {
        return this.listPublicOperatorsSettings;
    }

    public UnaryCallSettings<ResolveOperatorInfoRequest, ResolveOperatorInfoResponse> resolveOperatorInfoSettings() {
        return this.resolveOperatorInfoSettings;
    }

    public PagedCallSettings<ListOperatorsRequest, ListOperatorsResponse, LiveVideoAnalyticsClient.ListOperatorsPagedResponse> listOperatorsSettings() {
        return this.listOperatorsSettings;
    }

    public UnaryCallSettings<GetOperatorRequest, Operator> getOperatorSettings() {
        return this.getOperatorSettings;
    }

    public UnaryCallSettings<CreateOperatorRequest, Operation> createOperatorSettings() {
        return this.createOperatorSettings;
    }

    public OperationCallSettings<CreateOperatorRequest, Operator, OperationMetadata> createOperatorOperationSettings() {
        return this.createOperatorOperationSettings;
    }

    public UnaryCallSettings<UpdateOperatorRequest, Operation> updateOperatorSettings() {
        return this.updateOperatorSettings;
    }

    public OperationCallSettings<UpdateOperatorRequest, Operator, OperationMetadata> updateOperatorOperationSettings() {
        return this.updateOperatorOperationSettings;
    }

    public UnaryCallSettings<DeleteOperatorRequest, Operation> deleteOperatorSettings() {
        return this.deleteOperatorSettings;
    }

    public OperationCallSettings<DeleteOperatorRequest, Empty, OperationMetadata> deleteOperatorOperationSettings() {
        return this.deleteOperatorOperationSettings;
    }

    public PagedCallSettings<ListAnalysesRequest, ListAnalysesResponse, LiveVideoAnalyticsClient.ListAnalysesPagedResponse> listAnalysesSettings() {
        return this.listAnalysesSettings;
    }

    public UnaryCallSettings<GetAnalysisRequest, Analysis> getAnalysisSettings() {
        return this.getAnalysisSettings;
    }

    public UnaryCallSettings<CreateAnalysisRequest, Operation> createAnalysisSettings() {
        return this.createAnalysisSettings;
    }

    public OperationCallSettings<CreateAnalysisRequest, Analysis, OperationMetadata> createAnalysisOperationSettings() {
        return this.createAnalysisOperationSettings;
    }

    public UnaryCallSettings<UpdateAnalysisRequest, Operation> updateAnalysisSettings() {
        return this.updateAnalysisSettings;
    }

    public OperationCallSettings<UpdateAnalysisRequest, Analysis, OperationMetadata> updateAnalysisOperationSettings() {
        return this.updateAnalysisOperationSettings;
    }

    public UnaryCallSettings<DeleteAnalysisRequest, Operation> deleteAnalysisSettings() {
        return this.deleteAnalysisSettings;
    }

    public OperationCallSettings<DeleteAnalysisRequest, Empty, OperationMetadata> deleteAnalysisOperationSettings() {
        return this.deleteAnalysisOperationSettings;
    }

    public PagedCallSettings<ListProcessesRequest, ListProcessesResponse, LiveVideoAnalyticsClient.ListProcessesPagedResponse> listProcessesSettings() {
        return this.listProcessesSettings;
    }

    public UnaryCallSettings<GetProcessRequest, Process> getProcessSettings() {
        return this.getProcessSettings;
    }

    public UnaryCallSettings<CreateProcessRequest, Operation> createProcessSettings() {
        return this.createProcessSettings;
    }

    public OperationCallSettings<CreateProcessRequest, Process, OperationMetadata> createProcessOperationSettings() {
        return this.createProcessOperationSettings;
    }

    public UnaryCallSettings<UpdateProcessRequest, Operation> updateProcessSettings() {
        return this.updateProcessSettings;
    }

    public OperationCallSettings<UpdateProcessRequest, Process, OperationMetadata> updateProcessOperationSettings() {
        return this.updateProcessOperationSettings;
    }

    public UnaryCallSettings<DeleteProcessRequest, Operation> deleteProcessSettings() {
        return this.deleteProcessSettings;
    }

    public OperationCallSettings<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings() {
        return this.deleteProcessOperationSettings;
    }

    public UnaryCallSettings<BatchRunProcessRequest, Operation> batchRunProcessSettings() {
        return this.batchRunProcessSettings;
    }

    public OperationCallSettings<BatchRunProcessRequest, BatchRunProcessResponse, OperationMetadata> batchRunProcessOperationSettings() {
        return this.batchRunProcessOperationSettings;
    }

    public LiveVideoAnalyticsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcLiveVideoAnalyticsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLiveVideoAnalyticsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "visionai";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "visionai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "visionai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LiveVideoAnalyticsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LiveVideoAnalyticsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LiveVideoAnalyticsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return LiveVideoAnalyticsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LiveVideoAnalyticsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listPublicOperatorsSettings = settingsBuilder.listPublicOperatorsSettings().build();
        this.resolveOperatorInfoSettings = settingsBuilder.resolveOperatorInfoSettings().build();
        this.listOperatorsSettings = settingsBuilder.listOperatorsSettings().build();
        this.getOperatorSettings = settingsBuilder.getOperatorSettings().build();
        this.createOperatorSettings = settingsBuilder.createOperatorSettings().build();
        this.createOperatorOperationSettings = settingsBuilder.createOperatorOperationSettings().build();
        this.updateOperatorSettings = settingsBuilder.updateOperatorSettings().build();
        this.updateOperatorOperationSettings = settingsBuilder.updateOperatorOperationSettings().build();
        this.deleteOperatorSettings = settingsBuilder.deleteOperatorSettings().build();
        this.deleteOperatorOperationSettings = settingsBuilder.deleteOperatorOperationSettings().build();
        this.listAnalysesSettings = settingsBuilder.listAnalysesSettings().build();
        this.getAnalysisSettings = settingsBuilder.getAnalysisSettings().build();
        this.createAnalysisSettings = settingsBuilder.createAnalysisSettings().build();
        this.createAnalysisOperationSettings = settingsBuilder.createAnalysisOperationSettings().build();
        this.updateAnalysisSettings = settingsBuilder.updateAnalysisSettings().build();
        this.updateAnalysisOperationSettings = settingsBuilder.updateAnalysisOperationSettings().build();
        this.deleteAnalysisSettings = settingsBuilder.deleteAnalysisSettings().build();
        this.deleteAnalysisOperationSettings = settingsBuilder.deleteAnalysisOperationSettings().build();
        this.listProcessesSettings = settingsBuilder.listProcessesSettings().build();
        this.getProcessSettings = settingsBuilder.getProcessSettings().build();
        this.createProcessSettings = settingsBuilder.createProcessSettings().build();
        this.createProcessOperationSettings = settingsBuilder.createProcessOperationSettings().build();
        this.updateProcessSettings = settingsBuilder.updateProcessSettings().build();
        this.updateProcessOperationSettings = settingsBuilder.updateProcessOperationSettings().build();
        this.deleteProcessSettings = settingsBuilder.deleteProcessSettings().build();
        this.deleteProcessOperationSettings = settingsBuilder.deleteProcessOperationSettings().build();
        this.batchRunProcessSettings = settingsBuilder.batchRunProcessSettings().build();
        this.batchRunProcessOperationSettings = settingsBuilder.batchRunProcessOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LiveVideoAnalyticsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListPublicOperatorsRequest, ListPublicOperatorsResponse, LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse> listPublicOperatorsSettings;
        private final UnaryCallSettings.Builder<ResolveOperatorInfoRequest, ResolveOperatorInfoResponse> resolveOperatorInfoSettings;
        private final PagedCallSettings.Builder<ListOperatorsRequest, ListOperatorsResponse, LiveVideoAnalyticsClient.ListOperatorsPagedResponse> listOperatorsSettings;
        private final UnaryCallSettings.Builder<GetOperatorRequest, Operator> getOperatorSettings;
        private final UnaryCallSettings.Builder<CreateOperatorRequest, Operation> createOperatorSettings;
        private final OperationCallSettings.Builder<CreateOperatorRequest, Operator, OperationMetadata> createOperatorOperationSettings;
        private final UnaryCallSettings.Builder<UpdateOperatorRequest, Operation> updateOperatorSettings;
        private final OperationCallSettings.Builder<UpdateOperatorRequest, Operator, OperationMetadata> updateOperatorOperationSettings;
        private final UnaryCallSettings.Builder<DeleteOperatorRequest, Operation> deleteOperatorSettings;
        private final OperationCallSettings.Builder<DeleteOperatorRequest, Empty, OperationMetadata> deleteOperatorOperationSettings;
        private final PagedCallSettings.Builder<ListAnalysesRequest, ListAnalysesResponse, LiveVideoAnalyticsClient.ListAnalysesPagedResponse> listAnalysesSettings;
        private final UnaryCallSettings.Builder<GetAnalysisRequest, Analysis> getAnalysisSettings;
        private final UnaryCallSettings.Builder<CreateAnalysisRequest, Operation> createAnalysisSettings;
        private final OperationCallSettings.Builder<CreateAnalysisRequest, Analysis, OperationMetadata> createAnalysisOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAnalysisRequest, Operation> updateAnalysisSettings;
        private final OperationCallSettings.Builder<UpdateAnalysisRequest, Analysis, OperationMetadata> updateAnalysisOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAnalysisRequest, Operation> deleteAnalysisSettings;
        private final OperationCallSettings.Builder<DeleteAnalysisRequest, Empty, OperationMetadata> deleteAnalysisOperationSettings;
        private final PagedCallSettings.Builder<ListProcessesRequest, ListProcessesResponse, LiveVideoAnalyticsClient.ListProcessesPagedResponse> listProcessesSettings;
        private final UnaryCallSettings.Builder<GetProcessRequest, Process> getProcessSettings;
        private final UnaryCallSettings.Builder<CreateProcessRequest, Operation> createProcessSettings;
        private final OperationCallSettings.Builder<CreateProcessRequest, Process, OperationMetadata> createProcessOperationSettings;
        private final UnaryCallSettings.Builder<UpdateProcessRequest, Operation> updateProcessSettings;
        private final OperationCallSettings.Builder<UpdateProcessRequest, Process, OperationMetadata> updateProcessOperationSettings;
        private final UnaryCallSettings.Builder<DeleteProcessRequest, Operation> deleteProcessSettings;
        private final OperationCallSettings.Builder<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings;
        private final UnaryCallSettings.Builder<BatchRunProcessRequest, Operation> batchRunProcessSettings;
        private final OperationCallSettings.Builder<BatchRunProcessRequest, BatchRunProcessResponse, OperationMetadata> batchRunProcessOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listPublicOperatorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PUBLIC_OPERATORS_PAGE_STR_FACT);
            this.resolveOperatorInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOperatorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_OPERATORS_PAGE_STR_FACT);
            this.getOperatorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createOperatorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createOperatorOperationSettings = OperationCallSettings.newBuilder();
            this.updateOperatorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperatorOperationSettings = OperationCallSettings.newBuilder();
            this.deleteOperatorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperatorOperationSettings = OperationCallSettings.newBuilder();
            this.listAnalysesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ANALYSES_PAGE_STR_FACT);
            this.getAnalysisSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAnalysisSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAnalysisOperationSettings = OperationCallSettings.newBuilder();
            this.updateAnalysisSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAnalysisOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAnalysisSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAnalysisOperationSettings = OperationCallSettings.newBuilder();
            this.listProcessesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROCESSES_PAGE_STR_FACT);
            this.getProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createProcessOperationSettings = OperationCallSettings.newBuilder();
            this.updateProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProcessOperationSettings = OperationCallSettings.newBuilder();
            this.deleteProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessOperationSettings = OperationCallSettings.newBuilder();
            this.batchRunProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchRunProcessOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPublicOperatorsSettings, this.resolveOperatorInfoSettings, this.listOperatorsSettings, this.getOperatorSettings, this.createOperatorSettings, this.updateOperatorSettings, this.deleteOperatorSettings, this.listAnalysesSettings, this.getAnalysisSettings, this.createAnalysisSettings, this.updateAnalysisSettings, this.deleteAnalysisSettings, (Object[])new UnaryCallSettings.Builder[]{this.listProcessesSettings, this.getProcessSettings, this.createProcessSettings, this.updateProcessSettings, this.deleteProcessSettings, this.batchRunProcessSettings});
            Builder.initDefaults(this);
        }

        protected Builder(LiveVideoAnalyticsStubSettings settings) {
            super((StubSettings)settings);
            this.listPublicOperatorsSettings = settings.listPublicOperatorsSettings.toBuilder();
            this.resolveOperatorInfoSettings = settings.resolveOperatorInfoSettings.toBuilder();
            this.listOperatorsSettings = settings.listOperatorsSettings.toBuilder();
            this.getOperatorSettings = settings.getOperatorSettings.toBuilder();
            this.createOperatorSettings = settings.createOperatorSettings.toBuilder();
            this.createOperatorOperationSettings = settings.createOperatorOperationSettings.toBuilder();
            this.updateOperatorSettings = settings.updateOperatorSettings.toBuilder();
            this.updateOperatorOperationSettings = settings.updateOperatorOperationSettings.toBuilder();
            this.deleteOperatorSettings = settings.deleteOperatorSettings.toBuilder();
            this.deleteOperatorOperationSettings = settings.deleteOperatorOperationSettings.toBuilder();
            this.listAnalysesSettings = settings.listAnalysesSettings.toBuilder();
            this.getAnalysisSettings = settings.getAnalysisSettings.toBuilder();
            this.createAnalysisSettings = settings.createAnalysisSettings.toBuilder();
            this.createAnalysisOperationSettings = settings.createAnalysisOperationSettings.toBuilder();
            this.updateAnalysisSettings = settings.updateAnalysisSettings.toBuilder();
            this.updateAnalysisOperationSettings = settings.updateAnalysisOperationSettings.toBuilder();
            this.deleteAnalysisSettings = settings.deleteAnalysisSettings.toBuilder();
            this.deleteAnalysisOperationSettings = settings.deleteAnalysisOperationSettings.toBuilder();
            this.listProcessesSettings = settings.listProcessesSettings.toBuilder();
            this.getProcessSettings = settings.getProcessSettings.toBuilder();
            this.createProcessSettings = settings.createProcessSettings.toBuilder();
            this.createProcessOperationSettings = settings.createProcessOperationSettings.toBuilder();
            this.updateProcessSettings = settings.updateProcessSettings.toBuilder();
            this.updateProcessOperationSettings = settings.updateProcessOperationSettings.toBuilder();
            this.deleteProcessSettings = settings.deleteProcessSettings.toBuilder();
            this.deleteProcessOperationSettings = settings.deleteProcessOperationSettings.toBuilder();
            this.batchRunProcessSettings = settings.batchRunProcessSettings.toBuilder();
            this.batchRunProcessOperationSettings = settings.batchRunProcessOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPublicOperatorsSettings, this.resolveOperatorInfoSettings, this.listOperatorsSettings, this.getOperatorSettings, this.createOperatorSettings, this.updateOperatorSettings, this.deleteOperatorSettings, this.listAnalysesSettings, this.getAnalysisSettings, this.createAnalysisSettings, this.updateAnalysisSettings, this.deleteAnalysisSettings, (Object[])new UnaryCallSettings.Builder[]{this.listProcessesSettings, this.getProcessSettings, this.createProcessSettings, this.updateProcessSettings, this.deleteProcessSettings, this.batchRunProcessSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LiveVideoAnalyticsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LiveVideoAnalyticsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LiveVideoAnalyticsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LiveVideoAnalyticsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)LiveVideoAnalyticsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)LiveVideoAnalyticsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LiveVideoAnalyticsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LiveVideoAnalyticsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listPublicOperatorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.resolveOperatorInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOperatorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.getOperatorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.createOperatorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params"));
            builder.updateOperatorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.deleteOperatorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.listAnalysesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.getAnalysisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.createAnalysisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params"));
            builder.updateAnalysisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.deleteAnalysisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params"));
            builder.listProcessesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchRunProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createOperatorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_5_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operator.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateOperatorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operator.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteOperatorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAnalysisOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_7_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_7_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Analysis.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAnalysisOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Analysis.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAnalysisOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_8_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createProcessOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Process.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateProcessOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Process.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteProcessOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchRunProcessOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchRunProcessResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListPublicOperatorsRequest, ListPublicOperatorsResponse, LiveVideoAnalyticsClient.ListPublicOperatorsPagedResponse> listPublicOperatorsSettings() {
            return this.listPublicOperatorsSettings;
        }

        public UnaryCallSettings.Builder<ResolveOperatorInfoRequest, ResolveOperatorInfoResponse> resolveOperatorInfoSettings() {
            return this.resolveOperatorInfoSettings;
        }

        public PagedCallSettings.Builder<ListOperatorsRequest, ListOperatorsResponse, LiveVideoAnalyticsClient.ListOperatorsPagedResponse> listOperatorsSettings() {
            return this.listOperatorsSettings;
        }

        public UnaryCallSettings.Builder<GetOperatorRequest, Operator> getOperatorSettings() {
            return this.getOperatorSettings;
        }

        public UnaryCallSettings.Builder<CreateOperatorRequest, Operation> createOperatorSettings() {
            return this.createOperatorSettings;
        }

        public OperationCallSettings.Builder<CreateOperatorRequest, Operator, OperationMetadata> createOperatorOperationSettings() {
            return this.createOperatorOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateOperatorRequest, Operation> updateOperatorSettings() {
            return this.updateOperatorSettings;
        }

        public OperationCallSettings.Builder<UpdateOperatorRequest, Operator, OperationMetadata> updateOperatorOperationSettings() {
            return this.updateOperatorOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteOperatorRequest, Operation> deleteOperatorSettings() {
            return this.deleteOperatorSettings;
        }

        public OperationCallSettings.Builder<DeleteOperatorRequest, Empty, OperationMetadata> deleteOperatorOperationSettings() {
            return this.deleteOperatorOperationSettings;
        }

        public PagedCallSettings.Builder<ListAnalysesRequest, ListAnalysesResponse, LiveVideoAnalyticsClient.ListAnalysesPagedResponse> listAnalysesSettings() {
            return this.listAnalysesSettings;
        }

        public UnaryCallSettings.Builder<GetAnalysisRequest, Analysis> getAnalysisSettings() {
            return this.getAnalysisSettings;
        }

        public UnaryCallSettings.Builder<CreateAnalysisRequest, Operation> createAnalysisSettings() {
            return this.createAnalysisSettings;
        }

        public OperationCallSettings.Builder<CreateAnalysisRequest, Analysis, OperationMetadata> createAnalysisOperationSettings() {
            return this.createAnalysisOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAnalysisRequest, Operation> updateAnalysisSettings() {
            return this.updateAnalysisSettings;
        }

        public OperationCallSettings.Builder<UpdateAnalysisRequest, Analysis, OperationMetadata> updateAnalysisOperationSettings() {
            return this.updateAnalysisOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAnalysisRequest, Operation> deleteAnalysisSettings() {
            return this.deleteAnalysisSettings;
        }

        public OperationCallSettings.Builder<DeleteAnalysisRequest, Empty, OperationMetadata> deleteAnalysisOperationSettings() {
            return this.deleteAnalysisOperationSettings;
        }

        public PagedCallSettings.Builder<ListProcessesRequest, ListProcessesResponse, LiveVideoAnalyticsClient.ListProcessesPagedResponse> listProcessesSettings() {
            return this.listProcessesSettings;
        }

        public UnaryCallSettings.Builder<GetProcessRequest, Process> getProcessSettings() {
            return this.getProcessSettings;
        }

        public UnaryCallSettings.Builder<CreateProcessRequest, Operation> createProcessSettings() {
            return this.createProcessSettings;
        }

        public OperationCallSettings.Builder<CreateProcessRequest, Process, OperationMetadata> createProcessOperationSettings() {
            return this.createProcessOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateProcessRequest, Operation> updateProcessSettings() {
            return this.updateProcessSettings;
        }

        public OperationCallSettings.Builder<UpdateProcessRequest, Process, OperationMetadata> updateProcessOperationSettings() {
            return this.updateProcessOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteProcessRequest, Operation> deleteProcessSettings() {
            return this.deleteProcessSettings;
        }

        public OperationCallSettings.Builder<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings() {
            return this.deleteProcessOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchRunProcessRequest, Operation> batchRunProcessSettings() {
            return this.batchRunProcessSettings;
        }

        public OperationCallSettings.Builder<BatchRunProcessRequest, BatchRunProcessResponse, OperationMetadata> batchRunProcessOperationSettings() {
            return this.batchRunProcessOperationSettings;
        }

        public LiveVideoAnalyticsStubSettings build() throws IOException {
            return new LiveVideoAnalyticsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_8_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_5_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_7_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_8_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"no_retry_5_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"no_retry_7_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

