/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.videointelligence.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.FixedChannelProvider;
import com.google.api.gax.grpc.FixedExecutorProvider;
import com.google.api.gax.grpc.OperationCallable;
import com.google.api.gax.grpc.OperationFuture;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.videointelligence.v1beta1.AnnotateVideoProgress;
import com.google.cloud.videointelligence.v1beta1.AnnotateVideoRequest;
import com.google.cloud.videointelligence.v1beta1.AnnotateVideoResponse;
import com.google.cloud.videointelligence.v1beta1.Feature;
import com.google.cloud.videointelligence.v1beta1.VideoContext;
import com.google.cloud.videointelligence.v1beta1.VideoIntelligenceServiceSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.OperationsSettings;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class VideoIntelligenceServiceClient
implements AutoCloseable {
    private final VideoIntelligenceServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final OperationsClient operationsClient;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<AnnotateVideoRequest, Operation> annotateVideoCallable;
    private final OperationCallable<AnnotateVideoRequest, AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoOperationCallable;

    public static final VideoIntelligenceServiceClient create() throws IOException {
        return VideoIntelligenceServiceClient.create(VideoIntelligenceServiceSettings.defaultBuilder().build());
    }

    public static final VideoIntelligenceServiceClient create(VideoIntelligenceServiceSettings settings) throws IOException {
        return new VideoIntelligenceServiceClient(settings);
    }

    protected VideoIntelligenceServiceClient(VideoIntelligenceServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        ClientContext clientContext = ClientContext.newBuilder().setExecutor(this.executor).setChannel((Channel)this.channel).setCredentials(credentials).build();
        OperationsSettings operationsSettings = OperationsSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.executor)).setChannelProvider((ChannelProvider)FixedChannelProvider.create((ManagedChannel)this.channel)).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials)).build();
        this.operationsClient = OperationsClient.create((OperationsSettings)operationsSettings);
        this.annotateVideoCallable = UnaryCallable.create((SimpleCallSettings)settings.annotateVideoSettings().getInitialCallSettings(), (ClientContext)clientContext);
        this.annotateVideoOperationCallable = OperationCallable.create(settings.annotateVideoSettings(), (ClientContext)clientContext, (OperationsClient)this.operationsClient);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    VideoIntelligenceServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    VideoIntelligenceServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final VideoIntelligenceServiceSettings getSettings() {
        return this.settings;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoAsync(String inputUri, List<Feature> features, VideoContext videoContext, String outputUri, String locationId) {
        AnnotateVideoRequest request = AnnotateVideoRequest.newBuilder().setInputUri(inputUri).addAllFeatures(features).setVideoContext(videoContext).setOutputUri(outputUri).setLocationId(locationId).build();
        return this.annotateVideoAsync(request);
    }

    public final OperationFuture<AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoAsync(AnnotateVideoRequest request) {
        return this.annotateVideoOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AnnotateVideoRequest, AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoOperationCallable() {
        return this.annotateVideoOperationCallable;
    }

    public final UnaryCallable<AnnotateVideoRequest, Operation> annotateVideoCallable() {
        return this.annotateVideoCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

