/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.api.PredictionServiceClient;
import com.google.cloud.vertexai.api.PredictionServiceSettings;
import com.google.cloud.vertexai.api.stub.PredictionServiceStubSettings;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VertexAI
implements AutoCloseable {
    private final String projectId;
    private final String location;
    private final GoogleCredentials credentials;
    private Transport transport = Transport.GRPC;
    private PredictionServiceClient predictionServiceClient = null;
    private PredictionServiceClient predictionServiceRestClient = null;

    public VertexAI(String projectId, String location, GoogleCredentials credentials) {
        this.projectId = projectId;
        this.location = location;
        this.credentials = credentials;
    }

    public VertexAI(String projectId, String location, Transport transport, GoogleCredentials credentials) {
        this(projectId, location, credentials);
        this.transport = transport;
    }

    public VertexAI(String projectId, String location, String ... scopes) throws IOException {
        Logger logger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
        Level previousLevel = logger.getLevel();
        logger.setLevel(Level.SEVERE);
        List defaultScopes = PredictionServiceStubSettings.defaultCredentialsProviderBuilder().getScopesToApply();
        GoogleCredentials credentials = scopes.length == 0 ? GoogleCredentials.getApplicationDefault().createScoped((Collection)defaultScopes) : GoogleCredentials.getApplicationDefault().createScoped(scopes);
        logger.setLevel(previousLevel);
        this.projectId = projectId;
        this.location = location;
        this.credentials = credentials;
    }

    public VertexAI(String projectId, String location, Transport transport, String ... scopes) throws IOException {
        this(projectId, location, scopes);
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public GoogleCredentials getCredentials() {
        return this.credentials;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public PredictionServiceClient getPredictionServiceClient() throws IOException {
        if (this.predictionServiceClient == null) {
            PredictionServiceSettings settings = ((PredictionServiceSettings.Builder)((PredictionServiceSettings.Builder)PredictionServiceSettings.newBuilder().setEndpoint(String.format("%s-aiplatform.googleapis.com:443", this.location))).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)this.credentials))).build();
            this.predictionServiceClient = PredictionServiceClient.create(settings);
        }
        return this.predictionServiceClient;
    }

    public PredictionServiceClient getPredictionServiceRestClient() throws IOException {
        if (this.predictionServiceRestClient == null) {
            PredictionServiceSettings settings = ((PredictionServiceSettings.Builder)((PredictionServiceSettings.Builder)PredictionServiceSettings.newHttpJsonBuilder().setEndpoint(String.format("%s-aiplatform.googleapis.com:443", this.location))).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)this.credentials))).build();
            this.predictionServiceRestClient = PredictionServiceClient.create(settings);
        }
        return this.predictionServiceRestClient;
    }

    @Override
    public void close() {
        if (this.predictionServiceClient != null) {
            this.predictionServiceClient.close();
        }
        if (this.predictionServiceRestClient != null) {
            this.predictionServiceRestClient.close();
        }
    }
}

