/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.testing;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.translate.TranslateOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class RemoteTranslateHelper {
    private static final Logger logger = Logger.getLogger(RemoteTranslateHelper.class.getName());
    private final TranslateOptions options;

    private RemoteTranslateHelper(TranslateOptions options) {
        this.options = options;
    }

    public TranslateOptions getOptions() {
        return this.options;
    }

    public static RemoteTranslateHelper create(String projectId, InputStream keyStream) throws TranslateHelperException {
        try {
            HttpTransportOptions transportOptions = TranslateOptions.getDefaultHttpTransportOptions();
            transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
            TranslateOptions translateOptions = ((TranslateOptions.Builder)((TranslateOptions.Builder)TranslateOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)keyStream))).setProjectId(projectId).setRetrySettings(RemoteTranslateHelper.retryParams())).setTransportOptions((TransportOptions)transportOptions).build();
            return new RemoteTranslateHelper(translateOptions);
        }
        catch (IOException ex) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, ex.getMessage());
            }
            throw TranslateHelperException.translate(ex);
        }
    }

    @Deprecated
    public static RemoteTranslateHelper create(String apiKey) {
        HttpTransportOptions transportOptions = TranslateOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        TranslateOptions translateOptions = ((TranslateOptions.Builder)TranslateOptions.newBuilder().setApiKey(apiKey).setRetrySettings(RemoteTranslateHelper.retryParams())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteTranslateHelper(translateOptions);
    }

    public static RemoteTranslateHelper create() {
        HttpTransportOptions transportOptions = TranslateOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        TranslateOptions translateOption = ((TranslateOptions.Builder)TranslateOptions.newBuilder().setRetrySettings(RemoteTranslateHelper.retryParams())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteTranslateHelper(translateOption);
    }

    private static RetrySettings retryParams() {
        return RetrySettings.newBuilder().setMaxAttempts(10).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.0).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).build();
    }

    public static class TranslateHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -1356870058436149798L;

        public TranslateHelperException(String message) {
            super(message);
        }

        public TranslateHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static TranslateHelperException translate(Exception ex) {
            return new TranslateHelperException(ex.getMessage(), ex);
        }
    }
}

