/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.trace.v1.TraceServiceSettings;
import com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.cloud.trace.v1.stub.TraceServiceStubSettings;
import com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.Traces;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TraceServiceClient
implements BackgroundResource {
    private final TraceServiceSettings settings;
    private final TraceServiceStub stub;

    public static final TraceServiceClient create() throws IOException {
        return TraceServiceClient.create(TraceServiceSettings.newBuilder().build());
    }

    public static final TraceServiceClient create(TraceServiceSettings settings) throws IOException {
        return new TraceServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TraceServiceClient create(TraceServiceStub stub) {
        return new TraceServiceClient(stub);
    }

    protected TraceServiceClient(TraceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TraceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TraceServiceClient(TraceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TraceServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TraceServiceStub getStub() {
        return this.stub;
    }

    public final void patchTraces(String projectId, Traces traces) {
        PatchTracesRequest request = PatchTracesRequest.newBuilder().setProjectId(projectId).setTraces(traces).build();
        this.patchTraces(request);
    }

    public final void patchTraces(PatchTracesRequest request) {
        this.patchTracesCallable().call((Object)request);
    }

    public final UnaryCallable<PatchTracesRequest, Empty> patchTracesCallable() {
        return this.stub.patchTracesCallable();
    }

    public final Trace getTrace(String projectId, String traceId) {
        GetTraceRequest request = GetTraceRequest.newBuilder().setProjectId(projectId).setTraceId(traceId).build();
        return this.getTrace(request);
    }

    private final Trace getTrace(GetTraceRequest request) {
        return (Trace)this.getTraceCallable().call((Object)request);
    }

    public final UnaryCallable<GetTraceRequest, Trace> getTraceCallable() {
        return this.stub.getTraceCallable();
    }

    public final ListTracesPagedResponse listTraces(String projectId) {
        ListTracesRequest request = ListTracesRequest.newBuilder().setProjectId(projectId).build();
        return this.listTraces(request);
    }

    public final ListTracesPagedResponse listTraces(ListTracesRequest request) {
        return (ListTracesPagedResponse)((Object)this.listTracesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTracesRequest, ListTracesPagedResponse> listTracesPagedCallable() {
        return this.stub.listTracesPagedCallable();
    }

    public final UnaryCallable<ListTracesRequest, ListTracesResponse> listTracesCallable() {
        return this.stub.listTracesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTracesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTracesRequest, ListTracesResponse, Trace, ListTracesPage, ListTracesFixedSizeCollection> {
        private ListTracesFixedSizeCollection(List<ListTracesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTracesFixedSizeCollection createEmptyCollection() {
            return new ListTracesFixedSizeCollection(null, 0);
        }

        protected ListTracesFixedSizeCollection createCollection(List<ListTracesPage> pages, int collectionSize) {
            return new ListTracesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTracesPage
    extends AbstractPage<ListTracesRequest, ListTracesResponse, Trace, ListTracesPage> {
        private ListTracesPage(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ListTracesResponse response) {
            super(context, (Object)response);
        }

        private static ListTracesPage createEmptyPage() {
            return new ListTracesPage(null, null);
        }

        protected ListTracesPage createPage(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ListTracesResponse response) {
            return new ListTracesPage(context, response);
        }

        public ApiFuture<ListTracesPage> createPageAsync(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ApiFuture<ListTracesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTracesPagedResponse
    extends AbstractPagedListResponse<ListTracesRequest, ListTracesResponse, Trace, ListTracesPage, ListTracesFixedSizeCollection> {
        public static ApiFuture<ListTracesPagedResponse> createAsync(PageContext<ListTracesRequest, ListTracesResponse, Trace> context, ApiFuture<ListTracesResponse> futureResponse) {
            ApiFuture<ListTracesPage> futurePage = ListTracesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTracesPage, ListTracesPagedResponse>(){

                public ListTracesPagedResponse apply(ListTracesPage input) {
                    return new ListTracesPagedResponse(input);
                }
            });
        }

        private ListTracesPagedResponse(ListTracesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTracesFixedSizeCollection.createEmptyCollection());
        }
    }
}

