/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.tpu.v1.AcceleratorType;
import com.google.cloud.tpu.v1.CreateNodeRequest;
import com.google.cloud.tpu.v1.DeleteNodeRequest;
import com.google.cloud.tpu.v1.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v1.GetNodeRequest;
import com.google.cloud.tpu.v1.GetTensorFlowVersionRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v1.ListNodesRequest;
import com.google.cloud.tpu.v1.ListNodesResponse;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsRequest;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsResponse;
import com.google.cloud.tpu.v1.Node;
import com.google.cloud.tpu.v1.OperationMetadata;
import com.google.cloud.tpu.v1.ReimageNodeRequest;
import com.google.cloud.tpu.v1.StartNodeRequest;
import com.google.cloud.tpu.v1.StopNodeRequest;
import com.google.cloud.tpu.v1.TensorFlowVersion;
import com.google.cloud.tpu.v1.TpuClient;
import com.google.cloud.tpu.v1.stub.GrpcTpuCallableFactory;
import com.google.cloud.tpu.v1.stub.TpuStub;
import com.google.cloud.tpu.v1.stub.TpuStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcTpuStub
extends TpuStub {
    private static final MethodDescriptor<ListNodesRequest, ListNodesResponse> listNodesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/ListNodes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNodesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNodesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNodeRequest, Node> getNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/GetNode").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Node.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateNodeRequest, Operation> createNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/CreateNode").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteNodeRequest, Operation> deleteNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/DeleteNode").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ReimageNodeRequest, Operation> reimageNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/ReimageNode").setRequestMarshaller(ProtoUtils.marshaller((Message)ReimageNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StopNodeRequest, Operation> stopNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/StopNode").setRequestMarshaller(ProtoUtils.marshaller((Message)StopNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StartNodeRequest, Operation> startNodeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/StartNode").setRequestMarshaller(ProtoUtils.marshaller((Message)StartNodeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse> listTensorFlowVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/ListTensorFlowVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTensorFlowVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTensorFlowVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/GetTensorFlowVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTensorFlowVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TensorFlowVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/ListAcceleratorTypes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAcceleratorTypesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAcceleratorTypesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tpu.v1.Tpu/GetAcceleratorType").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAcceleratorTypeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AcceleratorType.getDefaultInstance())).build();
    private final UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable;
    private final UnaryCallable<ListNodesRequest, TpuClient.ListNodesPagedResponse> listNodesPagedCallable;
    private final UnaryCallable<GetNodeRequest, Node> getNodeCallable;
    private final UnaryCallable<CreateNodeRequest, Operation> createNodeCallable;
    private final OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable;
    private final UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable;
    private final OperationCallable<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationCallable;
    private final UnaryCallable<ReimageNodeRequest, Operation> reimageNodeCallable;
    private final OperationCallable<ReimageNodeRequest, Node, OperationMetadata> reimageNodeOperationCallable;
    private final UnaryCallable<StopNodeRequest, Operation> stopNodeCallable;
    private final OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable;
    private final UnaryCallable<StartNodeRequest, Operation> startNodeCallable;
    private final OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable;
    private final UnaryCallable<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse> listTensorFlowVersionsCallable;
    private final UnaryCallable<ListTensorFlowVersionsRequest, TpuClient.ListTensorFlowVersionsPagedResponse> listTensorFlowVersionsPagedCallable;
    private final UnaryCallable<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionCallable;
    private final UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable;
    private final UnaryCallable<ListAcceleratorTypesRequest, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable;
    private final UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTpuStub create(TpuStubSettings settings) throws IOException {
        return new GrpcTpuStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTpuStub create(ClientContext clientContext) throws IOException {
        return new GrpcTpuStub(TpuStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTpuStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTpuStub(TpuStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTpuStub(TpuStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTpuCallableFactory());
    }

    protected GrpcTpuStub(TpuStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listNodesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNodesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListNodesRequest>(){

            public Map<String, String> extract(ListNodesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNodeMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetNodeRequest>(){

            public Map<String, String> extract(GetNodeRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createNodeMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateNodeRequest>(){

            public Map<String, String> extract(CreateNodeRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteNodeMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteNodeRequest>(){

            public Map<String, String> extract(DeleteNodeRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings reimageNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reimageNodeMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReimageNodeRequest>(){

            public Map<String, String> extract(ReimageNodeRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings stopNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopNodeMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<StopNodeRequest>(){

            public Map<String, String> extract(StopNodeRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings startNodeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startNodeMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<StartNodeRequest>(){

            public Map<String, String> extract(StartNodeRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listTensorFlowVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTensorFlowVersionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListTensorFlowVersionsRequest>(){

            public Map<String, String> extract(ListTensorFlowVersionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getTensorFlowVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTensorFlowVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetTensorFlowVersionRequest>(){

            public Map<String, String> extract(GetTensorFlowVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listAcceleratorTypesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAcceleratorTypesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListAcceleratorTypesRequest>(){

            public Map<String, String> extract(ListAcceleratorTypesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getAcceleratorTypeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAcceleratorTypeMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAcceleratorTypeRequest>(){

            public Map<String, String> extract(GetAcceleratorTypeRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listNodesCallable = callableFactory.createUnaryCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.listNodesPagedCallable = callableFactory.createPagedCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.getNodeCallable = callableFactory.createUnaryCallable(getNodeTransportSettings, settings.getNodeSettings(), clientContext);
        this.createNodeCallable = callableFactory.createUnaryCallable(createNodeTransportSettings, settings.createNodeSettings(), clientContext);
        this.createNodeOperationCallable = callableFactory.createOperationCallable(createNodeTransportSettings, settings.createNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteNodeCallable = callableFactory.createUnaryCallable(deleteNodeTransportSettings, settings.deleteNodeSettings(), clientContext);
        this.deleteNodeOperationCallable = callableFactory.createOperationCallable(deleteNodeTransportSettings, settings.deleteNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.reimageNodeCallable = callableFactory.createUnaryCallable(reimageNodeTransportSettings, settings.reimageNodeSettings(), clientContext);
        this.reimageNodeOperationCallable = callableFactory.createOperationCallable(reimageNodeTransportSettings, settings.reimageNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.stopNodeCallable = callableFactory.createUnaryCallable(stopNodeTransportSettings, settings.stopNodeSettings(), clientContext);
        this.stopNodeOperationCallable = callableFactory.createOperationCallable(stopNodeTransportSettings, settings.stopNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.startNodeCallable = callableFactory.createUnaryCallable(startNodeTransportSettings, settings.startNodeSettings(), clientContext);
        this.startNodeOperationCallable = callableFactory.createOperationCallable(startNodeTransportSettings, settings.startNodeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listTensorFlowVersionsCallable = callableFactory.createUnaryCallable(listTensorFlowVersionsTransportSettings, settings.listTensorFlowVersionsSettings(), clientContext);
        this.listTensorFlowVersionsPagedCallable = callableFactory.createPagedCallable(listTensorFlowVersionsTransportSettings, settings.listTensorFlowVersionsSettings(), clientContext);
        this.getTensorFlowVersionCallable = callableFactory.createUnaryCallable(getTensorFlowVersionTransportSettings, settings.getTensorFlowVersionSettings(), clientContext);
        this.listAcceleratorTypesCallable = callableFactory.createUnaryCallable(listAcceleratorTypesTransportSettings, settings.listAcceleratorTypesSettings(), clientContext);
        this.listAcceleratorTypesPagedCallable = callableFactory.createPagedCallable(listAcceleratorTypesTransportSettings, settings.listAcceleratorTypesSettings(), clientContext);
        this.getAcceleratorTypeCallable = callableFactory.createUnaryCallable(getAcceleratorTypeTransportSettings, settings.getAcceleratorTypeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable() {
        return this.listNodesCallable;
    }

    @Override
    public UnaryCallable<ListNodesRequest, TpuClient.ListNodesPagedResponse> listNodesPagedCallable() {
        return this.listNodesPagedCallable;
    }

    @Override
    public UnaryCallable<GetNodeRequest, Node> getNodeCallable() {
        return this.getNodeCallable;
    }

    @Override
    public UnaryCallable<CreateNodeRequest, Operation> createNodeCallable() {
        return this.createNodeCallable;
    }

    @Override
    public OperationCallable<CreateNodeRequest, Node, OperationMetadata> createNodeOperationCallable() {
        return this.createNodeOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteNodeRequest, Operation> deleteNodeCallable() {
        return this.deleteNodeCallable;
    }

    @Override
    public OperationCallable<DeleteNodeRequest, Node, OperationMetadata> deleteNodeOperationCallable() {
        return this.deleteNodeOperationCallable;
    }

    @Override
    public UnaryCallable<ReimageNodeRequest, Operation> reimageNodeCallable() {
        return this.reimageNodeCallable;
    }

    @Override
    public OperationCallable<ReimageNodeRequest, Node, OperationMetadata> reimageNodeOperationCallable() {
        return this.reimageNodeOperationCallable;
    }

    @Override
    public UnaryCallable<StopNodeRequest, Operation> stopNodeCallable() {
        return this.stopNodeCallable;
    }

    @Override
    public OperationCallable<StopNodeRequest, Node, OperationMetadata> stopNodeOperationCallable() {
        return this.stopNodeOperationCallable;
    }

    @Override
    public UnaryCallable<StartNodeRequest, Operation> startNodeCallable() {
        return this.startNodeCallable;
    }

    @Override
    public OperationCallable<StartNodeRequest, Node, OperationMetadata> startNodeOperationCallable() {
        return this.startNodeOperationCallable;
    }

    @Override
    public UnaryCallable<ListTensorFlowVersionsRequest, ListTensorFlowVersionsResponse> listTensorFlowVersionsCallable() {
        return this.listTensorFlowVersionsCallable;
    }

    @Override
    public UnaryCallable<ListTensorFlowVersionsRequest, TpuClient.ListTensorFlowVersionsPagedResponse> listTensorFlowVersionsPagedCallable() {
        return this.listTensorFlowVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetTensorFlowVersionRequest, TensorFlowVersion> getTensorFlowVersionCallable() {
        return this.getTensorFlowVersionCallable;
    }

    @Override
    public UnaryCallable<ListAcceleratorTypesRequest, ListAcceleratorTypesResponse> listAcceleratorTypesCallable() {
        return this.listAcceleratorTypesCallable;
    }

    @Override
    public UnaryCallable<ListAcceleratorTypesRequest, TpuClient.ListAcceleratorTypesPagedResponse> listAcceleratorTypesPagedCallable() {
        return this.listAcceleratorTypesPagedCallable;
    }

    @Override
    public UnaryCallable<GetAcceleratorTypeRequest, AcceleratorType> getAcceleratorTypeCallable() {
        return this.getAcceleratorTypeCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

