/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tasks.v2beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.tasks.v2beta3.CloudTasksClient;
import com.google.cloud.tasks.v2beta3.CreateQueueRequest;
import com.google.cloud.tasks.v2beta3.CreateTaskRequest;
import com.google.cloud.tasks.v2beta3.DeleteQueueRequest;
import com.google.cloud.tasks.v2beta3.DeleteTaskRequest;
import com.google.cloud.tasks.v2beta3.GetQueueRequest;
import com.google.cloud.tasks.v2beta3.GetTaskRequest;
import com.google.cloud.tasks.v2beta3.ListQueuesRequest;
import com.google.cloud.tasks.v2beta3.ListQueuesResponse;
import com.google.cloud.tasks.v2beta3.ListTasksRequest;
import com.google.cloud.tasks.v2beta3.ListTasksResponse;
import com.google.cloud.tasks.v2beta3.PauseQueueRequest;
import com.google.cloud.tasks.v2beta3.PurgeQueueRequest;
import com.google.cloud.tasks.v2beta3.Queue;
import com.google.cloud.tasks.v2beta3.ResumeQueueRequest;
import com.google.cloud.tasks.v2beta3.RunTaskRequest;
import com.google.cloud.tasks.v2beta3.Task;
import com.google.cloud.tasks.v2beta3.UpdateQueueRequest;
import com.google.cloud.tasks.v2beta3.stub.CloudTasksStub;
import com.google.cloud.tasks.v2beta3.stub.CloudTasksStubSettings;
import com.google.cloud.tasks.v2beta3.stub.GrpcCloudTasksCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCloudTasksStub
extends CloudTasksStub {
    private static final MethodDescriptor<ListQueuesRequest, ListQueuesResponse> listQueuesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/ListQueues").setRequestMarshaller(ProtoUtils.marshaller((Message)ListQueuesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListQueuesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetQueueRequest, Queue> getQueueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/GetQueue").setRequestMarshaller(ProtoUtils.marshaller((Message)GetQueueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Queue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateQueueRequest, Queue> createQueueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/CreateQueue").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateQueueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Queue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateQueueRequest, Queue> updateQueueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/UpdateQueue").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateQueueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Queue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteQueueRequest, Empty> deleteQueueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/DeleteQueue").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteQueueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<PurgeQueueRequest, Queue> purgeQueueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/PurgeQueue").setRequestMarshaller(ProtoUtils.marshaller((Message)PurgeQueueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Queue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<PauseQueueRequest, Queue> pauseQueueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/PauseQueue").setRequestMarshaller(ProtoUtils.marshaller((Message)PauseQueueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Queue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ResumeQueueRequest, Queue> resumeQueueMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/ResumeQueue").setRequestMarshaller(ProtoUtils.marshaller((Message)ResumeQueueRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Queue.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListTasksRequest, ListTasksResponse> listTasksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/ListTasks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTasksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTasksResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetTaskRequest, Task> getTaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/GetTask").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Task.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateTaskRequest, Task> createTaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/CreateTask").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Task.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteTaskRequest, Empty> deleteTaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/DeleteTask").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RunTaskRequest, Task> runTaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.tasks.v2beta3.CloudTasks/RunTask").setRequestMarshaller(ProtoUtils.marshaller((Message)RunTaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Task.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListQueuesRequest, ListQueuesResponse> listQueuesCallable;
    private final UnaryCallable<ListQueuesRequest, CloudTasksClient.ListQueuesPagedResponse> listQueuesPagedCallable;
    private final UnaryCallable<GetQueueRequest, Queue> getQueueCallable;
    private final UnaryCallable<CreateQueueRequest, Queue> createQueueCallable;
    private final UnaryCallable<UpdateQueueRequest, Queue> updateQueueCallable;
    private final UnaryCallable<DeleteQueueRequest, Empty> deleteQueueCallable;
    private final UnaryCallable<PurgeQueueRequest, Queue> purgeQueueCallable;
    private final UnaryCallable<PauseQueueRequest, Queue> pauseQueueCallable;
    private final UnaryCallable<ResumeQueueRequest, Queue> resumeQueueCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable;
    private final UnaryCallable<ListTasksRequest, CloudTasksClient.ListTasksPagedResponse> listTasksPagedCallable;
    private final UnaryCallable<GetTaskRequest, Task> getTaskCallable;
    private final UnaryCallable<CreateTaskRequest, Task> createTaskCallable;
    private final UnaryCallable<DeleteTaskRequest, Empty> deleteTaskCallable;
    private final UnaryCallable<RunTaskRequest, Task> runTaskCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, CloudTasksClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudTasksStub create(CloudTasksStubSettings settings) throws IOException {
        return new GrpcCloudTasksStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudTasksStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudTasksStub(CloudTasksStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudTasksStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudTasksStub(CloudTasksStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudTasksStub(CloudTasksStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudTasksCallableFactory());
    }

    protected GrpcCloudTasksStub(CloudTasksStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listQueuesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listQueuesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getQueueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getQueueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createQueueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createQueueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateQueueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateQueueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("queue.name", String.valueOf(request.getQueue().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteQueueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteQueueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings purgeQueueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(purgeQueueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings pauseQueueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(pauseQueueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings resumeQueueTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resumeQueueMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings listTasksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTasksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTaskMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createTaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTaskMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteTaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTaskMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings runTaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runTaskMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listQueuesCallable = callableFactory.createUnaryCallable(listQueuesTransportSettings, settings.listQueuesSettings(), clientContext);
        this.listQueuesPagedCallable = callableFactory.createPagedCallable(listQueuesTransportSettings, settings.listQueuesSettings(), clientContext);
        this.getQueueCallable = callableFactory.createUnaryCallable(getQueueTransportSettings, settings.getQueueSettings(), clientContext);
        this.createQueueCallable = callableFactory.createUnaryCallable(createQueueTransportSettings, settings.createQueueSettings(), clientContext);
        this.updateQueueCallable = callableFactory.createUnaryCallable(updateQueueTransportSettings, settings.updateQueueSettings(), clientContext);
        this.deleteQueueCallable = callableFactory.createUnaryCallable(deleteQueueTransportSettings, settings.deleteQueueSettings(), clientContext);
        this.purgeQueueCallable = callableFactory.createUnaryCallable(purgeQueueTransportSettings, settings.purgeQueueSettings(), clientContext);
        this.pauseQueueCallable = callableFactory.createUnaryCallable(pauseQueueTransportSettings, settings.pauseQueueSettings(), clientContext);
        this.resumeQueueCallable = callableFactory.createUnaryCallable(resumeQueueTransportSettings, settings.resumeQueueSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.listTasksCallable = callableFactory.createUnaryCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.listTasksPagedCallable = callableFactory.createPagedCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.getTaskCallable = callableFactory.createUnaryCallable(getTaskTransportSettings, settings.getTaskSettings(), clientContext);
        this.createTaskCallable = callableFactory.createUnaryCallable(createTaskTransportSettings, settings.createTaskSettings(), clientContext);
        this.deleteTaskCallable = callableFactory.createUnaryCallable(deleteTaskTransportSettings, settings.deleteTaskSettings(), clientContext);
        this.runTaskCallable = callableFactory.createUnaryCallable(runTaskTransportSettings, settings.runTaskSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListQueuesRequest, ListQueuesResponse> listQueuesCallable() {
        return this.listQueuesCallable;
    }

    @Override
    public UnaryCallable<ListQueuesRequest, CloudTasksClient.ListQueuesPagedResponse> listQueuesPagedCallable() {
        return this.listQueuesPagedCallable;
    }

    @Override
    public UnaryCallable<GetQueueRequest, Queue> getQueueCallable() {
        return this.getQueueCallable;
    }

    @Override
    public UnaryCallable<CreateQueueRequest, Queue> createQueueCallable() {
        return this.createQueueCallable;
    }

    @Override
    public UnaryCallable<UpdateQueueRequest, Queue> updateQueueCallable() {
        return this.updateQueueCallable;
    }

    @Override
    public UnaryCallable<DeleteQueueRequest, Empty> deleteQueueCallable() {
        return this.deleteQueueCallable;
    }

    @Override
    public UnaryCallable<PurgeQueueRequest, Queue> purgeQueueCallable() {
        return this.purgeQueueCallable;
    }

    @Override
    public UnaryCallable<PauseQueueRequest, Queue> pauseQueueCallable() {
        return this.pauseQueueCallable;
    }

    @Override
    public UnaryCallable<ResumeQueueRequest, Queue> resumeQueueCallable() {
        return this.resumeQueueCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.listTasksCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, CloudTasksClient.ListTasksPagedResponse> listTasksPagedCallable() {
        return this.listTasksPagedCallable;
    }

    @Override
    public UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.getTaskCallable;
    }

    @Override
    public UnaryCallable<CreateTaskRequest, Task> createTaskCallable() {
        return this.createTaskCallable;
    }

    @Override
    public UnaryCallable<DeleteTaskRequest, Empty> deleteTaskCallable() {
        return this.deleteTaskCallable;
    }

    @Override
    public UnaryCallable<RunTaskRequest, Task> runTaskCallable() {
        return this.runTaskCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, CloudTasksClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

